/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.registries.entity.living.boss.firron.Firron;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class FirronKeyframePacket {
    private final UUID entityId;
    private final String keyframe;

    public FirronKeyframePacket(UUID entityId, String keyframe) {
        this.entityId = entityId;
        this.keyframe = keyframe;
    }

    public static void encode(FirronKeyframePacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.entityId);
        buf.m_130070_(msg.keyframe);
    }

    public static FirronKeyframePacket decode(FriendlyByteBuf buf) {
        return new FirronKeyframePacket(buf.m_130259_(), buf.m_130277_());
    }

    public static void handle(FirronKeyframePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerLevel level = ((NetworkEvent.Context)ctx.get()).getSender().m_284548_();
            Entity entity = level.m_8791_(msg.entityId);
            if (entity instanceof Firron) {
                Firron firron = (Firron)entity;
                firron.handleKeyframe(msg.keyframe);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

