/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.core.capability.IMagmaLevel;
import com.idark.valoria.core.capability.MagmaLevelProvider;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class MagmaPacket {
    private final float max;
    private final float magmaLevel;

    public MagmaPacket(float max, float amount) {
        this.max = max;
        this.magmaLevel = amount;
    }

    public MagmaPacket(IMagmaLevel magma, @Nullable LivingEntity entity) {
        this.max = magma.getMaxAmount(entity);
        this.magmaLevel = magma.getAmount();
    }

    public static void encode(MagmaPacket object, FriendlyByteBuf buffer) {
        buffer.writeFloat(object.max);
        buffer.writeFloat(object.magmaLevel);
    }

    public static MagmaPacket decode(FriendlyByteBuf buffer) {
        return new MagmaPacket(buffer.readFloat(), buffer.readFloat());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            player.getCapability(MagmaLevelProvider.INSTANCE).ifPresent(m -> {
                m.setMaxAmount(this.max);
                m.setAmount(this.magmaLevel);
            });
        });
        ctx.get().setPacketHandled(true);
    }
}

