/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.capability.IUnlockable;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class UnlockableUpdatePacket {
    UUID uuid;
    CompoundTag tag;

    public UnlockableUpdatePacket(UUID uuid, CompoundTag tag) {
        this.uuid = uuid;
        this.tag = tag;
    }

    public UnlockableUpdatePacket(Player entity) {
        this.uuid = entity.m_20148_();
        entity.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
            if (k instanceof INBTSerializable) {
                this.tag = (CompoundTag)((INBTSerializable)k).serializeNBT();
            }
        });
    }

    public static void encode(UnlockableUpdatePacket object, FriendlyByteBuf buffer) {
        buffer.m_130077_(object.uuid);
        buffer.m_130079_(object.tag);
    }

    public static UnlockableUpdatePacket decode(FriendlyByteBuf buffer) {
        return new UnlockableUpdatePacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void handle(UnlockableUpdatePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            Level world = Valoria.proxy.getLevel();
            Player player = world.m_46003_(packet.uuid);
            if (player != null) {
                player.getCapability(IUnlockable.INSTANCE, null).ifPresent(k -> {
                    if (k instanceof INBTSerializable) {
                        ((INBTSerializable)k).deserializeNBT((Tag)packet.tag);
                    }
                });
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

