/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.SparkParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpriteParticleData;
import pro.komaru.tridot.client.gfx.particle.options.GenericParticleOptions;
import pro.komaru.tridot.client.gfx.particle.options.ItemParticleOptions;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class CrusherParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final ItemStack stack;

    public CrusherParticlePacket(double posX, double posY, double posZ, ItemStack stack) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.stack = stack;
    }

    public static CrusherParticlePacket decode(FriendlyByteBuf buf) {
        return new CrusherParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.m_130267_());
    }

    public static void handle(CrusherParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                ItemParticleOptions options = new ItemParticleOptions((ParticleType)TridotParticles.ITEM.get(), msg.stack);
                ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((GenericParticleOptions)options).setRenderType(TridotRenderTypes.TRANSLUCENT_BLOCK_PARTICLE).setSpinData(SpinParticleData.create().randomOffset().randomSpin(0.5f).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.02f, (float)0.0f).build()).setSpriteData(SpriteParticleData.CRUMBS_RANDOM).setLifetime(30).randomVelocity(0.25, 0.75, 0.25)).randomOffset(0.125, 0.125)).setGravity(0.75f).repeat(level, msg.posX, msg.posY, msg.posZ, 6);
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SQUARE).setBehavior(SparkParticleBehavior.create().build()).setScaleData(GenericParticleData.create((float)0.00125f, (float)0.02f, (float)0.0f).setEasing((Interp)Interp.bounce).build()).setLifetime(15).setColorData(ColorParticleData.create((Col)Col.white, (Col)Col.yellow).setEasing((Interp)Interp.bounce).build()).randomVelocity(0.125, 0.25, 0.125)).setHasPhysics(false).repeat(level, msg.posX, msg.posY, msg.posZ, 6);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.m_130055_(this.stack);
    }
}

