/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import com.idark.valoria.client.particle.ParticleEffects;
import com.idark.valoria.util.Pal;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.util.Col;

public class FireTrapParticlePacket {
    private final double posX;
    private final double posY;
    private final double posZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;
    private final int colorToR;
    private final int colorToG;
    private final int colorToB;

    public FireTrapParticlePacket(double posX, double posY, double posZ, int colorR, int colorG, int colorB, int colorToR, int colorToG, int colorToB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
        this.colorToR = colorToR;
        this.colorToG = colorToG;
        this.colorToB = colorToB;
    }

    public static FireTrapParticlePacket decode(FriendlyByteBuf buf) {
        return new FireTrapParticlePacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(FireTrapParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level level = Valoria.proxy.getLevel();
                for (int i = 0; i < 20; ++i) {
                    Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                    Col colorTo = new Col(msg.colorToR, msg.colorToG, msg.colorToB);
                    Vec3 pos = new Vec3(msg.posX, msg.posY + (double)1.2f, msg.posZ);
                    ParticleEffects.fireParticles(level, pos, ColorParticleData.create((Col)color, (Col)colorTo).build());
                    ParticleEffects.smokeParticles(level, pos, ColorParticleData.create((Col)Col.black, (Col)Pal.smoke).build());
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, msg.posX + 0.5, msg.posY + 1.5, msg.posZ + 0.5, 0.0, 0.0, 0.0);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeInt(this.colorR);
        buf.writeInt(this.colorG);
        buf.writeInt(this.colorB);
        buf.writeInt(this.colorToR);
        buf.writeInt(this.colorToG);
        buf.writeInt(this.colorToB);
    }
}

