/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.core.network.packets.particle;

import com.idark.valoria.Valoria;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Col;

public class ManipulatorEmptyParticlePacket {
    private final float posX;
    private final float posY;
    private final float posZ;
    private final float posToX;
    private final float posToY;
    private final float posToZ;
    private final int colorR;
    private final int colorG;
    private final int colorB;

    public ManipulatorEmptyParticlePacket(float posX, float posY, float posZ, float posToX, float posToY, float posToZ, int colorR, int colorG, int colorB) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.posToX = posToX;
        this.posToY = posToY;
        this.posToZ = posToZ;
        this.colorR = colorR;
        this.colorG = colorG;
        this.colorB = colorB;
    }

    public static ManipulatorEmptyParticlePacket decode(FriendlyByteBuf buf) {
        return new ManipulatorEmptyParticlePacket(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void handle(ManipulatorEmptyParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isClient()) {
            ctx.get().enqueueWork(() -> {
                Level pLevel = Valoria.proxy.getLevel();
                double pitch = 1.5707963267948966;
                float pRadius = 0.25f;
                for (int i = 0; i < 360; i += 10) {
                    double yaw = (double)(i + 90) * Math.PI / 180.0;
                    double X = Math.sin(pitch) * Math.cos(yaw) * (double)pRadius * 0.75;
                    double Y = Math.cos(pitch) * (double)pRadius * 0.75;
                    double Z = Math.sin(pitch) * Math.sin(yaw) * (double)pRadius * 0.75;
                    Vec3 particlePos = new Vec3((double)msg.posX + X, (double)msg.posY + Y + (Math.random() - 0.5) * (double)0.2f, (double)msg.posZ + Z);
                    Col color = new Col(msg.colorR, msg.colorG, msg.colorB);
                    ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setColorData(ColorParticleData.create((Col)color, (Col)Col.black).build()).setTransparencyData(GenericParticleData.create((float)1.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)0.0f).build()).setLifetime(4).setVelocity(0.0, (double)0.1f, 0.0)).spawn(pLevel, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            });
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
        buf.writeFloat(this.posToX);
        buf.writeFloat(this.posToY);
        buf.writeFloat(this.posToZ);
        buf.writeFloat((float)this.colorR);
        buf.writeFloat((float)this.colorG);
        buf.writeFloat((float)this.colorB);
    }
}

