/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries;

import com.idark.valoria.registries.item.recipe.AlchemyRecipe;
import com.idark.valoria.registries.item.recipe.AlchemyUpgradeRecipe;
import com.idark.valoria.registries.item.recipe.CrusherRecipe;
import com.idark.valoria.registries.item.recipe.JewelryRecipe;
import com.idark.valoria.registries.item.recipe.KegRecipe;
import com.idark.valoria.registries.item.recipe.KilnRecipe;
import com.idark.valoria.registries.item.recipe.ManipulatorRecipe;
import com.idark.valoria.registries.item.recipe.PoisonWeaponRecipe;
import com.idark.valoria.registries.item.recipe.PurifyingFoodRecipe;
import com.idark.valoria.registries.item.recipe.SoulInfuserRecipe;
import com.idark.valoria.registries.item.recipe.TinkeringRecipe;
import com.idark.valoria.registries.item.recipe.WorkbenchRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RecipesRegistry {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"valoria");
    public static final RegistryObject<RecipeSerializer<KegRecipe>> KEG_SERIALIZER = SERIALIZERS.register("keg_brewery", () -> KegRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<JewelryRecipe>> JEWELRY_SERIALIZER = SERIALIZERS.register("jewelry", () -> JewelryRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<CrusherRecipe>> CRUSHER_SERIALIZER = SERIALIZERS.register("crusher", () -> CrusherRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<ManipulatorRecipe>> MANIPULATOR_SERIALIZER = SERIALIZERS.register("manipulator", () -> ManipulatorRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<TinkeringRecipe>> TINKERING_SERIALIZER = SERIALIZERS.register("tinkering", () -> TinkeringRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<KilnRecipe>> KILN_SERIALIZER = SERIALIZERS.register("kiln", () -> KilnRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<SoulInfuserRecipe>> SOUL_INFUSER_SERIALIZER = SERIALIZERS.register("soul_infuser", () -> SoulInfuserRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<PoisonWeaponRecipe>> POISON_RECIPE = SERIALIZERS.register("weapon_poisoning", () -> new SimpleCraftingRecipeSerializer(PoisonWeaponRecipe::new));
    public static final RegistryObject<RecipeSerializer<PurifyingFoodRecipe>> PURIFY_RECIPE = SERIALIZERS.register("purifying_food", () -> new SimpleCraftingRecipeSerializer(PurifyingFoodRecipe::new));
    public static final RegistryObject<RecipeSerializer<WorkbenchRecipe>> HEAVY_WORKBENCH = SERIALIZERS.register("heavy_workbench", () -> WorkbenchRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<AlchemyRecipe>> ALCHEMY = SERIALIZERS.register("alchemy", () -> AlchemyRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<AlchemyUpgradeRecipe>> ALCHEMY_UPGRADE = SERIALIZERS.register("alchemy_upgrade", () -> AlchemyUpgradeRecipe.Serializer.INSTANCE);

    public static void register(IEventBus eventBus) {
        SERIALIZERS.register(eventBus);
    }
}

