/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.client.ui.menus.JewelryMenu;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.item.recipe.JewelryRecipe;
import com.idark.valoria.registries.item.skins.SkinTrimItem;
import com.idark.valoria.util.ValoriaUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import pro.komaru.tridot.common.registry.item.skins.ItemSkin;

public class JewelryBlockEntity
extends BlockEntity
implements MenuProvider,
TickableBlockEntity {
    public final ItemStackHandler itemHandler = this.createHandler(2);
    public final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    public final ItemStackHandler itemOutputHandler = this.createHandler(1);
    public final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> this.itemOutputHandler);
    public int progress = 0;
    public int progressMax = 0;

    public JewelryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntitiesRegistry.JEWELRY_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                JewelryBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                CombinedInvWrapper item = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.itemOutputHandler});
                return LazyOptional.of(() -> item).cast();
            }
            if (side == Direction.DOWN) {
                return this.outputHandler.cast();
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ValoriaUtils.SUpdateTileEntityPacket(this);
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"menu.valoria.jewelry");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new JewelryMenu(pContainerId, this.f_58857_, this.m_58899_(), pPlayerInventory, pPlayer);
    }

    public void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128365_("output", (Tag)this.itemOutputHandler.serializeNBT());
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("progressMax", this.progressMax);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inv"));
        this.itemOutputHandler.deserializeNBT(pTag.m_128469_("output"));
        this.progress = pTag.m_128451_("progress");
        this.progressMax = pTag.m_128451_("progressMax");
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            Optional<JewelryRecipe> recipe = this.getCurrentRecipe();
            ItemSkin skin = this.getSkin();
            if (recipe.isPresent()) {
                this.processCrafting();
            } else if (skin != null && !this.itemHandler.getStackInSlot(0).m_41619_() && !this.itemHandler.getStackInSlot(1).m_41619_()) {
                if (this.itemHandler.getStackInSlot(1).m_41720_() instanceof SkinTrimItem) {
                    this.increaseCraftingProgress(60);
                    JewelryBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
                    if (this.progress >= 60) {
                        this.craftItem();
                        this.resetProgress();
                    }
                    ValoriaUtils.SUpdateTileEntityPacket(this);
                }
            } else {
                this.resetProgress();
            }
        }
    }

    private void processCrafting() {
        this.increaseCraftingProgress();
        this.setMaxProgress();
        JewelryBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
        if (this.hasProgressFinished()) {
            this.craftItem();
            this.resetProgress();
        }
        ValoriaUtils.SUpdateTileEntityPacket(this);
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private boolean hasProgressFinished() {
        Optional<JewelryRecipe> recipe = this.getCurrentRecipe();
        return this.progress >= recipe.get().getTime();
    }

    private void increaseCraftingProgress(int time) {
        this.progressMax = time;
        if (this.itemOutputHandler.getStackInSlot(0).m_41619_() && this.progress < time) {
            ++this.progress;
        }
    }

    private void increaseCraftingProgress() {
        Optional<JewelryRecipe> recipe = this.getCurrentRecipe();
        if (this.itemOutputHandler.getStackInSlot(0).m_41619_() && this.progress < recipe.get().getTime()) {
            ++this.progress;
        }
    }

    private void setMaxProgress() {
        Optional<JewelryRecipe> recipe = this.getCurrentRecipe();
        if (this.progressMax <= 0) {
            this.progressMax = recipe.map(JewelryRecipe::getTime).orElse(200);
        }
    }

    private void craftItem() {
        Optional<JewelryRecipe> recipe = this.getCurrentRecipe();
        if (this.itemOutputHandler.getStackInSlot(0).m_41619_()) {
            ItemSkin skin = this.getSkin();
            if (skin != null) {
                ItemStack skinResult = skin.apply(this.itemHandler.getStackInSlot(0).m_41777_());
                this.itemOutputHandler.setStackInSlot(0, skinResult);
            } else {
                ItemStack result = recipe.get().m_8043_((RegistryAccess)RegistryAccess.f_243945_);
                this.itemOutputHandler.setStackInSlot(0, result);
            }
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.extractItem(1, 1, false);
        }
    }

    public ItemSkin getSkin() {
        SkinTrimItem trim;
        Item item;
        if (!this.itemHandler.getStackInSlot(0).m_41619_() && !this.itemHandler.getStackInSlot(1).m_41619_() && (item = this.itemHandler.getStackInSlot(1).m_41720_()) instanceof SkinTrimItem && (trim = (SkinTrimItem)item).canApply(this.itemHandler.getStackInSlot(0))) {
            ItemSkin skin = ItemSkin.itemSkin((ItemStack)this.itemHandler.getStackInSlot(0));
            if (skin != null && skin == trim.getSkin()) {
                return null;
            }
            return trim.getSkin();
        }
        return null;
    }

    private Optional<JewelryRecipe> getCurrentRecipe() {
        SimpleContainer inv = new SimpleContainer(3);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)JewelryRecipe.Type.INSTANCE, (Container)inv, this.f_58857_);
    }
}

