/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.entity;

import com.idark.valoria.ValoriaClient;
import com.idark.valoria.client.sounds.ElementalManipulatorSoundInstance;
import com.idark.valoria.client.ui.menus.ManipulatorMenu;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.CubeShapedParticlePacket;
import com.idark.valoria.core.network.packets.particle.ManipulatorCraftParticlePacket;
import com.idark.valoria.core.network.packets.particle.ManipulatorEmptyParticlePacket;
import com.idark.valoria.registries.BlockEntitiesRegistry;
import com.idark.valoria.registries.block.types.ManipulatorBlock;
import com.idark.valoria.registries.item.recipe.ManipulatorRecipe;
import com.idark.valoria.util.ValoriaUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;

public class ManipulatorBlockEntity
extends BlockEntity
implements MenuProvider,
TickableBlockEntity {
    public final ItemStackHandler itemHandler = this.createHandler(2);
    public final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    public final ItemStackHandler itemOutputHandler = this.createHandler(1);
    public final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> this.itemOutputHandler);
    public int progress = 0;
    public int progressMax = 0;
    public boolean startCraft = false;
    public int nature_core = 0;
    public int infernal_core = 0;
    public int aquarius_core = 0;
    public int void_core = 0;

    public ManipulatorBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public ManipulatorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntitiesRegistry.MANIPULATOR_BLOCK_ENTITY.get(), pos, state);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                ManipulatorBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                CombinedInvWrapper item = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.itemOutputHandler});
                return LazyOptional.of(() -> item).cast();
            }
            if (side == Direction.DOWN) {
                return this.outputHandler.cast();
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void tick() {
        Optional<ManipulatorRecipe> recipe = this.getCurrentRecipe();
        if (!this.f_58857_.f_46443_ && recipe.isPresent()) {
            if (this.getCharge(recipe.get().getCore()) >= recipe.get().getCoresNeeded() && this.itemOutputHandler.getStackInSlot(0).m_41613_() < this.itemOutputHandler.getStackInSlot(0).m_41741_()) {
                this.increaseCraftingProgress();
                this.setMaxProgress();
                ManipulatorBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
                PacketHandler.sendToTracking(this.f_58857_, this.m_58899_(), new ManipulatorCraftParticlePacket(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_(), -0.2f, 0.2f, -0.2f, 255, 255, 255));
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
                ValoriaUtils.SUpdateTileEntityPacket(this);
            } else if (recipe.get().getCore().equals("empty") && this.itemOutputHandler.getStackInSlot(0).m_41613_() < this.itemOutputHandler.getStackInSlot(0).m_41741_()) {
                this.increaseCraftingProgress();
                this.setMaxProgress();
                ManipulatorBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
                PacketHandler.sendToTracking(this.f_58857_, this.m_58899_(), new ManipulatorEmptyParticlePacket((float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 0.75f, (float)this.m_58899_().m_123343_() + 0.5f, (float)this.m_58899_().m_123341_() + 0.5f, (float)this.m_58899_().m_123342_() + 0.65f, (float)this.m_58899_().m_123343_() + 0.5f, 255, 255, 255));
                ValoriaUtils.SUpdateTileEntityPacket(this);
            }
        }
        if (recipe.isEmpty()) {
            this.resetProgress();
        }
        if (this.f_58857_.f_46443_) {
            this.playSound();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playSound() {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (this.getCurrentRecipe().isPresent() && ValoriaClient.MANIPULATOR_LOOP != null && soundManager.m_120403_((SoundInstance)ValoriaClient.MANIPULATOR_LOOP)) {
            return;
        }
        if (this.getCurrentRecipe().isPresent() && this.progress > 0) {
            ValoriaClient.MANIPULATOR_LOOP = ElementalManipulatorSoundInstance.getSound(this);
            soundManager.m_120367_((SoundInstance)ValoriaClient.MANIPULATOR_LOOP);
            if (!soundManager.m_120403_((SoundInstance)ValoriaClient.MANIPULATOR_LOOP)) {
                ValoriaClient.MANIPULATOR_LOOP = null;
            }
        } else {
            if (soundManager.m_120403_((SoundInstance)ValoriaClient.MANIPULATOR_LOOP) && ValoriaClient.MANIPULATOR_LOOP != null) {
                ValoriaClient.MANIPULATOR_LOOP.stopSound();
            }
            ValoriaClient.MANIPULATOR_LOOP = null;
        }
    }

    public Optional<ManipulatorRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        return this.f_58857_.m_7465_().m_44015_((RecipeType)ManipulatorRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
    }

    private void craftItem() {
        PacketHandler.sendToTracking(this.f_58857_, this.m_58899_(), new CubeShapedParticlePacket((float)this.m_58899_().m_252807_().f_82479_, (float)this.m_58899_().m_252807_().f_82480_ - 0.25f, (float)this.m_58899_().m_252807_().f_82481_, 0.62f, 0.15f, 255, 255, 255));
        Optional<ManipulatorRecipe> recipe = this.getCurrentRecipe();
        ItemStack result = recipe.get().assemble((IItemHandler)this.itemHandler);
        if (!recipe.get().getCore().equals("empty")) {
            this.decreaseCharge(recipe.get().getCore(), recipe.get().getCoresNeeded());
        }
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
        this.itemOutputHandler.insertItem(0, result, false);
    }

    private boolean hasProgressFinished() {
        Optional<ManipulatorRecipe> recipe = this.getCurrentRecipe();
        return this.progress >= recipe.get().getTime();
    }

    private void increaseCraftingProgress() {
        this.startCraft = true;
        Optional<ManipulatorRecipe> recipe = this.getCurrentRecipe();
        if (this.progress < recipe.get().getTime()) {
            ++this.progress;
        }
    }

    private void setMaxProgress() {
        Optional<ManipulatorRecipe> recipe = this.getCurrentRecipe();
        if (this.progressMax <= 0) {
            this.progressMax = recipe.map(ManipulatorRecipe::getTime).orElse(200);
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.progressMax = 0;
        this.startCraft = false;
    }

    public int getCharge(String name) {
        CompoundTag nbt = this.serializeNBT();
        if (nbt == null) {
            nbt = new CompoundTag();
            this.deserializeNBT(nbt);
        }
        return nbt.m_128451_(name);
    }

    public void addCharge(String name, int charge) {
        CompoundTag nbt = this.serializeNBT();
        if (nbt == null) {
            nbt = new CompoundTag();
            this.deserializeNBT(nbt);
        }
        int current = nbt.m_128451_(name);
        int added = Math.min(charge, ManipulatorBlock.maxCores - current);
        nbt.m_128405_(name, current + added);
        this.deserializeNBT(nbt);
        this.m_6596_();
    }

    public void setCharge(String name, int charge) {
        CompoundTag nbt = this.serializeNBT();
        if (nbt == null) {
            nbt = new CompoundTag();
            this.deserializeNBT(nbt);
        }
        nbt.m_128405_(name, charge);
        this.deserializeNBT(nbt);
        this.m_6596_();
    }

    public void decreaseCharge(String name, int charge) {
        CompoundTag nbt = this.serializeNBT();
        if (nbt == null) {
            nbt = new CompoundTag();
            this.deserializeNBT(nbt);
        }
        nbt.m_128405_(name, nbt.m_128451_(name) - charge);
        this.deserializeNBT(nbt);
        this.m_6596_();
    }

    public int getCoreNBT(String name) {
        CompoundTag nbt = this.serializeNBT();
        if (nbt != null) {
            this.deserializeNBT(nbt);
            return nbt.m_128451_(name);
        }
        throw new IllegalArgumentException("Unknown core");
    }

    public void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128365_("output", (Tag)this.itemOutputHandler.serializeNBT());
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("progressMax", this.progressMax);
        pTag.m_128405_("nature_core", this.nature_core);
        pTag.m_128405_("infernal_core", this.infernal_core);
        pTag.m_128405_("aquarius_core", this.aquarius_core);
        pTag.m_128405_("void_core", this.void_core);
        super.m_183515_(pTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inv"));
        this.itemOutputHandler.deserializeNBT(pTag.m_128469_("output"));
        this.progress = pTag.m_128451_("progress");
        this.progressMax = pTag.m_128451_("progressMax");
        this.nature_core = pTag.m_128451_("nature_core");
        this.infernal_core = pTag.m_128451_("infernal_core");
        this.aquarius_core = pTag.m_128451_("aquarius_core");
        this.void_core = pTag.m_128451_("void_core");
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ValoriaUtils.SUpdateTileEntityPacket(this);
        }
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"menu.valoria.manipulator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ManipulatorMenu(pContainerId, this.f_58857_, this.m_58899_(), pPlayerInventory, pPlayer);
    }
}

