/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.block.types;

import com.idark.valoria.registries.block.entity.ValoriaPortalBlockEntity;
import com.idark.valoria.registries.block.types.ValoriaPortalFrame;
import com.idark.valoria.registries.level.LevelGen;
import com.idark.valoria.registries.level.portal.ValoriaTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.SparkParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.postprocess.GlowPostProcess;
import pro.komaru.tridot.client.gfx.postprocess.GlowPostProcessInstance;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.math.Interp;

public class ValoriaPortalBlock
extends Block
implements EntityBlock {
    private static final VoxelShape shape = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)8.5, (double)16.0);

    public ValoriaPortalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity.m_6072_() && Shapes.m_83157_((VoxelShape)Shapes.m_83064_((AABB)pEntity.m_20191_().m_82386_((double)(-pPos.m_123341_()), (double)(-pPos.m_123342_()), (double)(-pPos.m_123343_()))), (VoxelShape)pState.m_60808_((BlockGetter)pLevel, pPos), (BooleanOp)BooleanOp.f_82689_)) {
            this.handlePortal(pEntity, pPos);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.m_188503_(100) == 0) {
            pLevel.m_7785_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, -pRandom.m_188501_() * 0.5f, false);
        }
        ArcRandom random = Tmp.rnd;
        ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SQUARE).setBehavior(SparkParticleBehavior.create().build()).setRenderType(TridotRenderTypes.TRANSLUCENT_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.01f, (float)0.06f, (float)0.0f).setEasing((Interp)Interp.bounce).build()).flatRandomOffset(0.25, 0.0, 0.25).setLifetime(24).setColorData(ColorParticleData.create((Col)Col.black).setEasing((Interp)Interp.bounce).build()).setVelocity(0.0, (random.nextDouble() + 0.2) / 6.0, 0.0)).spawn(pLevel, (double)pPos.m_123341_() + pRandom.m_188500_(), (double)pPos.m_123342_() + pRandom.m_188500_(), (double)pPos.m_123343_() + pRandom.m_188500_());
        ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SQUARE).setBehavior(SparkParticleBehavior.create().build()).setTransparencyData(GenericParticleData.create((float)0.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.01f, (float)0.06f, (float)0.0f).setEasing((Interp)Interp.bounce).build()).flatRandomOffset((double)0.45f, 0.0, (double)0.45f).setLifetime(24).setColorData(ColorParticleData.create((Col)(random.fiftyFifty() ? Col.fromHex((String)"1a101f") : Col.fromHex((String)"451f3f"))).setEasing((Interp)Interp.bounce).build()).setVelocity(0.0, (random.nextDouble() + 0.2) / 6.0, 0.0)).spawn(pLevel, (double)pPos.m_123341_() + pRandom.m_188500_(), (double)pPos.m_123342_() + pRandom.m_188500_(), (double)pPos.m_123343_() + pRandom.m_188500_());
    }

    private void handlePortal(Entity player, BlockPos pPos) {
        if (player.m_20092_()) {
            player.m_20091_();
        } else {
            ResourceKey<Level> resourcekey;
            ServerLevel serverlevel;
            MinecraftServer minecraftserver;
            ServerLevel portalDimension;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel && (portalDimension = (minecraftserver = (serverlevel = (ServerLevel)level).m_7654_()).m_129880_(resourcekey = player.m_9236_().m_46472_() == LevelGen.VALORIA_KEY ? Level.f_46428_ : LevelGen.VALORIA_KEY)) != null && !player.m_20159_()) {
                if (resourcekey == LevelGen.VALORIA_KEY) {
                    player.changeDimension(portalDimension, (ITeleporter)new ValoriaTeleporter(serverlevel, pPos, true));
                } else {
                    player.changeDimension(portalDimension, (ITeleporter)new ValoriaTeleporter(serverlevel, pPos, false));
                }
                player.m_20091_();
            }
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pLevel.m_5776_()) {
            GlowPostProcess.INSTANCE.addInstance(new GlowPostProcessInstance(pCurrentPos.m_252807_().m_252839_(), new Vector3f(0.27450982f, 0.12156863f, 0.54509807f)).setIntensity(0.25f).setFadeTime(45.0f).setRadius(4.0f));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos2, boolean unknown) {
        BlockPattern.BlockPatternMatch frame = ValoriaPortalFrame.getOrCreatePortalShape().m_61184_((LevelReader)world, pos);
        if (frame == null && world.m_46472_() != LevelGen.VALORIA_KEY) {
            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ValoriaPortalBlockEntity(pPos, pState);
    }
}

