/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.ai.attacks;

import com.idark.valoria.Valoria;
import com.idark.valoria.registries.entity.living.elemental.AbstractElementalGolem;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;

public class GolemStompAttack
extends AttackInstance {
    private final TargetingConditions targeting;

    public GolemStompAttack(AbstractElementalGolem mob, float strength, float range, int attackDelay, int attackDuration, int cooldown) {
        super((PathfinderMob)mob, strength, range, attackDelay, attackDuration, cooldown);
        this.targeting = TargetingConditions.m_148352_().m_26883_((double)range).m_148355_().m_26893_();
    }

    public ResourceLocation getId() {
        return Valoria.loc("stomp");
    }

    public int preference(Entity target) {
        return 0;
    }

    public void tick() {
        super.tick();
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
    }

    public void start(AttackSystemMob systemMob) {
        super.start(systemMob);
        this.mob.m_21561_(true);
        this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)60);
    }

    public boolean canUse(LivingEntity target) {
        return super.canUse(target) && this.mob.m_21223_() < this.mob.m_21233_() * 0.75f;
    }

    public void performAttack() {
        Vec3 vec3 = new Vec3(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        List entities = this.mob.m_9236_().m_45971_(LivingEntity.class, this.targeting, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_((double)this.range));
        for (LivingEntity entity : entities) {
            double dZ;
            double dY;
            double distance = Math.sqrt(entity.m_20238_(vec3)) / (double)this.range;
            double dX = entity.m_20185_() - vec3.f_82479_;
            double sqrt = Math.sqrt(dX * dX + (dY = entity.m_20188_() - vec3.f_82480_) * dY + (dZ = entity.m_20189_() - vec3.f_82481_) * dZ);
            if (sqrt == 0.0) continue;
            dX /= sqrt;
            dY /= sqrt;
            dZ /= sqrt;
            double seenPercent = Utils.Hit.seenPercent((Vec3)vec3, (Entity)entity, (float)this.damage);
            double power = (1.0 - distance) * seenPercent;
            double powerAfterDamp = ProtectionEnchantment.m_45135_((LivingEntity)entity, (double)power);
            Vec3 vec31 = new Vec3((dX *= powerAfterDamp) * 2.0, (dY *= powerAfterDamp) * 0.5, (dZ *= powerAfterDamp) * 2.0);
            entity.f_19864_ = true;
            entity.m_20256_(entity.m_20184_().m_82549_(vec31));
        }
    }
}

