/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.ItemsRegistry;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import pro.komaru.tridot.util.Tmp;

public class DraugrEntity
extends Monster
implements RangedAttackMob {
    public static List<Item> draugrCanSpawnWith = new ArrayList<Item>();
    private final RangedBowAttackGoal<AbstractSkeleton> bowGoal = new RangedBowAttackGoal((Monster)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public void m_8041_() {
            super.m_8041_();
            DraugrEntity.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            DraugrEntity.this.m_21561_(true);
        }
    };

    public DraugrEntity(EntityType<? extends DraugrEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.reassessWeaponGoal();
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_275832_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            this.f_20883_ = pathfindermob.f_20883_;
        }
    }

    public static void spawnable(Item ... T) {
        Collections.addAll(draugrCanSpawnWith, T);
    }

    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, draugrCanSpawnWith.get(pRandom.m_216339_(0, draugrCanSpawnWith.size())).m_7968_());
        if (Tmp.rnd.chance(0.15f)) {
            this.m_8061_(EquipmentSlot.OFFHAND, ((Item)ItemsRegistry.draugrShield.get()).m_7968_());
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        RandomSource randomsource = pLevel.m_213780_();
        this.m_213945_(randomsource, pDifficulty);
        this.m_213946_(randomsource, pDifficulty);
        this.reassessWeaponGoal();
        this.m_21553_(randomsource.m_188501_() < 0.55f * pDifficulty.m_19057_());
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.getDayOfMonth();
            int j = localdate.getMonth().getValue();
            if (j == 10 && i == 31 && randomsource.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(randomsource.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
                this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
            }
        }
        return pSpawnData;
    }

    public void reassessWeaponGoal() {
        this.m_9236_();
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                int i = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 40;
                }
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public boolean m_5886_(ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon == Items.f_42411_;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.reassessWeaponGoal();
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.m_9236_().f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 1.74f;
    }

    public double m_6049_() {
        return -0.6;
    }

    public boolean isShaking() {
        return this.m_146890_();
    }
}

