/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.entity.ai.goals.DashAttackGoal;
import com.idark.valoria.registries.entity.living.MaggotEntity;
import com.idark.valoria.registries.entity.living.SwampWandererEntity;
import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import pro.komaru.tridot.api.entity.ai.goals.DelayedMeleeAttackGoal;

public class ScourgeEntity
extends SwampWandererEntity {
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public final AnimationState attackAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    private int spawnTime = 0;
    public int deathTime = 0;
    private int attackAnimationTick;

    public ScourgeEntity(EntityType<? extends ScourgeEntity> type, Level pLevel) {
        super(type, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if (this.spawnTime < 60) {
            ++this.spawnTime;
            if (this.m_20096_() && this.m_20089_() != Pose.DIGGING) {
                this.m_20124_(Pose.DIGGING);
                this.m_5496_(SoundEvents.f_215780_, 5.0f, 1.0f);
            }
        }
        if (this.m_20089_() == Pose.DIGGING) {
            this.clientDiggingParticles(this.diggingAnimationState);
        }
    }

    protected boolean m_5884_() {
        return false;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.m_216977_(this.f_19797_);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7822_(pId);
    }

    @Override
    protected void m_6878_() {
        this.f_21345_.m_25352_(1, (Goal)new DashAttackGoal((Mob)this, 1.0f));
        this.f_21345_.m_25352_(1, (Goal)new DrownedAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new SwampWandererEntity.DrownedGoToBeachGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{ScourgeEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::okTarget));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11815_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11817_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11819_;
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11875_, 0.2f, 0.5f);
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= 60 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        return this.spawnTime < 60 && !pSource.m_269533_(DamageTypeTags.f_268738_) || super.m_6673_(pSource);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (f_19806_.equals(pKey) && this.m_20089_() == Pose.DIGGING) {
            this.diggingAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(pKey);
    }

    private void clientDiggingParticles(AnimationState pAnimationState) {
        if ((float)pAnimationState.m_216981_() < 4500.0f) {
            RandomSource randomsource = this.m_217043_();
            BlockState blockstate = this.m_20075_();
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 10; ++i) {
                    double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    double d1 = this.m_20186_();
                    double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)pDamageSource)) {
            return;
        }
        if (!this.m_213877_() && !this.f_20890_) {
            Entity entity = pDamageSource.m_7639_();
            LivingEntity livingentity = this.m_21232_();
            if (this.f_20897_ >= 0 && livingentity != null) {
                livingentity.m_5993_((Entity)this, this.f_20897_, pDamageSource);
            }
            if (this.m_5803_()) {
                this.m_5796_();
            }
            if (!this.m_9236_().f_46443_ && this.m_8077_()) {
                LogUtils.getLogger().info("Named entity {} died: {}", (Object)this, (Object)this.m_21231_().m_19293_().getString());
            }
            this.f_20890_ = true;
            this.m_21231_().m_19296_();
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.m_214076_(serverlevel, (LivingEntity)this)) {
                    this.m_146850_(GameEvent.f_223707_);
                    this.m_6668_(pDamageSource);
                }
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
        }
        this.deathAnimationState.m_216977_(this.f_19797_);
        int maggotCount = 6 + this.f_19796_.m_188503_(2);
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < maggotCount; ++i) {
                MaggotEntity maggot = new MaggotEntity(this.m_9236_());
                Vec3 mobPos = this.m_20182_();
                double offsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
                double offsetY = this.m_9236_().f_46441_.m_188500_() * 0.5 + 0.35;
                double offsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 2.0;
                maggot.m_7678_(mobPos.f_82479_, mobPos.f_82480_ + 0.5, mobPos.f_82481_, this.m_9236_().f_46441_.m_188501_() * 360.0f, 0.0f);
                maggot.m_20256_(new Vec3(offsetX, offsetY, offsetZ));
                this.m_9236_().m_7967_((Entity)maggot);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    static class DrownedAttackGoal
    extends DelayedMeleeAttackGoal {
        private final ScourgeEntity drowned;

        public DrownedAttackGoal(ScourgeEntity pDrowned, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pDrowned, pSpeedModifier, 60, pFollowingTargetEvenIfNotSeen);
            this.drowned = pDrowned;
        }

        public void m_8056_() {
            this.drowned.m_9236_().m_7605_((Entity)this.drowned, (byte)4);
            this.drowned.attackAnimationTick = 15;
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                double d0 = this.mob.m_262793_(livingentity);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = livingentity.m_20185_();
                    this.pathedTargetY = livingentity.m_20186_();
                    this.pathedTargetZ = livingentity.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
                if (this.drowned.attackAnimationTick < 3) {
                    this.ticksUntilNextAttack = Math.max(this.getTicksUntilNextAttack() - 1, 0);
                    this.checkAndPerformAttack(livingentity, d0);
                }
            }
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.drowned.okTarget(this.drowned.m_5448_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.drowned.okTarget(this.drowned.m_5448_());
        }
    }
}

