/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.boss.firron;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.FirronKeyframePacket;
import com.idark.valoria.core.network.packets.particle.CrushParticlePacket;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.living.boss.IBossPhase;
import com.idark.valoria.registries.entity.living.boss.dryador.phases.BossPhase;
import com.idark.valoria.registries.entity.living.boss.firron.PiercingDashAttack;
import com.idark.valoria.registries.entity.living.boss.firron.RushAttack;
import com.idark.valoria.registries.entity.living.boss.firron.SweepAttack;
import com.idark.valoria.registries.entity.living.boss.firron.TripleSweepAttack;
import com.idark.valoria.util.Pal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.api.interfaces.Allied;
import pro.komaru.tridot.api.interfaces.BossEntity;
import pro.komaru.tridot.api.render.bossbars.ServerBossBar;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpriteParticleData;
import pro.komaru.tridot.client.gfx.particle.options.BlockParticleOptions;
import pro.komaru.tridot.client.gfx.particle.options.GenericParticleOptions;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSelector;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;
import pro.komaru.tridot.common.registry.entity.system.ExecuteAttackGoal;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.Interp;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Firron
extends Monster
implements Enemy,
BossEntity,
Allied,
AttackSystemMob,
GeoEntity {
    public final ServerBossBar bossEvent = new ServerBossBar(this.m_5446_(), Valoria.loc("basic")).setTexture(Valoria.loc("textures/gui/bossbars/firron.png")).setDarkenScreen(true);
    public final List<UUID> nearbyPlayers = new ArrayList<UUID>();
    public final Map<UUID, Float> damageMap = new HashMap<UUID, Float>();
    private final AttackSelector selector = new AttackSelector();
    private AttackInstance currentAttack;
    public IBossPhase currentPhase = new BossPhase((LivingEntity)this, () -> this.m_21223_() <= this.m_21233_() / 2.0f).setSound(SoundEvents.f_11669_);
    public int stunTicks;
    public boolean isStunned;
    private Vec3 rushDirection;
    private int animationTicks = 0;
    private int rushPrepareTicks;
    private int rushTicks;
    private int prepareDuration = 80;
    private int rushDuration = 80;
    private boolean rushing;
    public static final float sweepAttackRange = 1.5f;
    public static final float tripleSweepAttackRange = 3.0f;
    public static final float pierceAttackRange = 4.0f;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("WALK");
    public static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("IDLE");
    public static final RawAnimation ATTACK_1 = RawAnimation.begin().thenPlay("ATTACK1");
    public static final RawAnimation ATTACK_2 = RawAnimation.begin().thenPlay("ATTACK2");
    public static final RawAnimation ATTACK_3 = RawAnimation.begin().thenPlay("ATTACK3");
    public static final RawAnimation RUSH_PREPARE = RawAnimation.begin().thenPlay("RUSH_PREPARE").thenLoop("RUSH_RAM");
    public static final RawAnimation RUSH_RAM = RawAnimation.begin().thenLoop("RUSH_RAM");
    public static final RawAnimation RUSH_BASH = RawAnimation.begin().thenPlay("RUSH_BASH");
    public static final RawAnimation RUSH_STUN_BEGIN = RawAnimation.begin().thenPlay("RUSH_STUN_BEGIN").thenLoop("STUN_LOOP");
    public static final RawAnimation STUN_LOOP = RawAnimation.begin().thenPlay("STUN_LOOP");
    public static final RawAnimation STUN_END = RawAnimation.begin().thenPlay("STUN_END");
    public static final RawAnimation SPAWN = RawAnimation.begin().thenPlay("SPAWN");
    public static final RawAnimation SUMMON_START = RawAnimation.begin().thenPlay("SUMMON_START");
    public static final RawAnimation SUMMON_HOLD = RawAnimation.begin().thenPlay("SUMMON_HOLD");
    public static final RawAnimation SUMMON_END = RawAnimation.begin().thenPlay("SUMMON_END");

    public Firron(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.initAttacks();
    }

    public void checkPhaseTransition() {
        if (this.currentPhase.shouldTransition() && !this.currentPhase.playedSound()) {
            this.animationTicks = 90;
            this.f_21344_.m_26573_();
            this.currentPhase.onEnter();
            this.amplifyStats();
        }
        if (this.animationTicks > 0) {
            --this.animationTicks;
        }
    }

    private void amplifyStats() {
        this.m_21051_(Attributes.f_22284_).m_22118_(new AttributeModifier("modifier", (double)((float)this.m_9236_().m_46791_().m_19028_() * 0.5f), AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.m_21051_(Attributes.f_22281_).m_22118_(new AttributeModifier("modifier", (double)((float)this.m_9236_().m_46791_().m_19028_() * 2.0f), AttributeModifier.Operation.ADDITION));
        this.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier("modifier", (double)0.025f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public void m_8119_() {
        super.m_8119_();
        this.checkPhaseTransition();
        if (this.rushing && this.rushPrepareTicks <= this.prepareDuration) {
            ++this.rushPrepareTicks;
        } else if (this.rushDirection != null && !this.m_9236_().f_46443_) {
            this.performRush();
        }
        if (this.rushing) {
            this.spawnRushParticles();
        }
    }

    private void performRush() {
        ++this.rushTicks;
        if (this.hitWall() || this.rushTicks > this.rushDuration || this.rushDirection == null) {
            this.endRush(!this.hitWall());
            return;
        }
        Vec3 dir = this.rushDirection;
        this.m_20256_(dir.m_82490_((double)0.7f));
        this.f_19864_ = true;
        this.f_19812_ = true;
        AABB hitBox = this.m_20191_().m_82400_(2.0);
        List hitEntities = this.m_9236_().m_6443_(LivingEntity.class, hitBox, e -> e != this);
        for (LivingEntity e2 : hitEntities) {
            if (!e2.m_6084_() || e2 instanceof Allied) continue;
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_7327_((Entity)e2);
            double d2 = e2.m_21133_(Attributes.f_22278_);
            double d1 = Math.max(0.0, 1.0 - d2);
            ItemStack useStack = e2.m_21211_();
            Item item = useStack.m_41720_();
            if (!(item instanceof ShieldItem)) {
                e2.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.STUN.get(), 160, 0));
                this.endRush(true);
            } else {
                ShieldItem shieldItem = (ShieldItem)item;
                useStack.m_41622_(15, e2, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
                if (e2 instanceof Player) {
                    Player plr = (Player)e2;
                    plr.m_36335_().m_41524_((Item)shieldItem, 300);
                }
                this.endRush(false);
            }
            e2.m_20256_(e2.m_20184_().m_82520_(dir.f_82479_, 0.5 * d1, dir.f_82481_));
            break;
        }
    }

    private void spawnRushParticles() {
        if (this.m_9236_().m_5776_()) {
            Player player = ClientUtils.getClientPlayer();
            ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((GenericParticleOptions)this.getBlockParticleOptions()).setRenderType(TridotRenderTypes.TRANSLUCENT_BLOCK_PARTICLE).setSpinData(SpinParticleData.create().randomOffset().randomSpin(0.5f).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.02f, (float)0.0f).build()).setSpriteData(SpriteParticleData.CRUMBS_RANDOM).setLifetime(30).randomVelocity(0.35, 0.35, 0.35)).randomOffset(0.125, 0.125)).setGravity(0.75f).repeat(player.m_9236_(), this.m_20183_().m_252807_(), 12);
        }
    }

    private void spawnCrushParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            PacketHandler.sendToTracking((Level)level2, this.m_20183_(), new CrushParticlePacket(this.m_20183_().m_7495_(), this.m_146903_(), this.m_146904_(), this.m_146907_()));
        }
    }

    private boolean hitWall() {
        if (this.rushDirection == null) {
            return false;
        }
        return this.f_19862_;
    }

    public void startRush(LivingEntity target) {
        this.rushDirection = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        this.rushing = true;
        this.rushTicks = 0;
        this.rushPrepareTicks = 0;
        this.m_9236_().m_7605_((Entity)this, (byte)92);
        this.m_21573_().m_26573_();
        this.m_21573_().m_5624_((Entity)target, 1.0);
        this.f_19864_ = true;
        this.f_19812_ = true;
    }

    public void stopRush() {
        this.m_9236_().m_7605_((Entity)this, (byte)93);
        this.rushing = false;
        this.rushDirection = null;
        this.rushTicks = 0;
        this.m_21561_(false);
    }

    private void endRush(boolean hitEntity) {
        this.rushing = false;
        this.rushPrepareTicks = 0;
        if (hitEntity) {
            this.triggerAnim("AttackController", "rush_bash");
        } else {
            this.setStunned(160);
            this.spawnCrushParticles();
            ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(25, Pos3.init((float)this.m_146903_(), (float)this.m_146904_(), (float)this.m_146907_()), 0.0f, 30.0f).intensity(1.25f).interp((Interp)Interp.bounce));
            this.m_5496_(SoundEvents.f_12601_, 0.5f, 0.75f);
            this.triggerAnim("AttackController", "rush_stun_begin");
        }
        this.stopRush();
    }

    public boolean m_21525_() {
        return super.m_21525_() || this.isStunned || this.f_19797_ < 140 || this.animationTicks > 0;
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.bossEvent.setAboutToDie(true);
        super.m_6667_(pDamageSource);
    }

    public int m_6056_() {
        return 12;
    }

    public double m_20968_(Entity entityIn) {
        return 1.0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "SpawnController", 0, state -> {
            if (this.f_19797_ < 140) {
                return state.setAndContinue(SPAWN);
            }
            return PlayState.STOP;
        }).setCustomInstructionKeyframeHandler(e -> {
            String data = e.getKeyframeData().getInstructions();
            if (data.equals("spawned;")) {
                Player player = ClientUtils.getClientPlayer();
                ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.WISP).setHasPhysics(false).randomVelocity(1.0, 0.0, 1.0)).setLifetime(30).setScaleData(GenericParticleData.create((float)1.55f, (float)0.0f).build()).setColorData(ColorParticleData.create((Col)Pal.lightishGray, (Col)Col.white).build()).repeat(player.m_9236_(), (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), 64);
                BlockParticleOptions options = this.getBlockParticleOptions();
                ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((GenericParticleOptions)options).setRenderType(TridotRenderTypes.TRANSLUCENT_BLOCK_PARTICLE).setSpinData(SpinParticleData.create().randomOffset().randomSpin(0.15f).build()).setScaleData(GenericParticleData.create((float)0.65f, (float)0.0f).build()).setSpriteData(SpriteParticleData.CRUMBS_RANDOM).setLifetime(50).randomVelocity(0.345, (double)0.85f, 0.345)).randomOffset(0.045, 0.045)).setGravity(0.75f).repeat(player.m_9236_(), (double)this.m_146903_(), (double)this.m_146904_(), (double)this.m_146907_(), 128);
                player.m_5496_(SoundEvents.f_12601_, 0.5f, 0.75f);
                ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(10, Pos3.init((float)this.m_146903_(), (float)this.m_146904_(), (float)this.m_146907_()), 0.0f, 15.0f).intensity(1.25f).interp((Interp)Interp.bounce));
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "AnimationController", 15, this::animationController)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "AttackController", 5, state -> PlayState.STOP).triggerableAnim("triple_sweep", ATTACK_1).triggerableAnim("sweep", ATTACK_2).triggerableAnim("pierce", ATTACK_3).triggerableAnim("rush_prepare", RUSH_PREPARE).triggerableAnim("rush_bash", RUSH_BASH).triggerableAnim("rush_ram", RUSH_RAM).triggerableAnim("rush_stun_begin", RUSH_STUN_BEGIN).setCustomInstructionKeyframeHandler(e -> {
            String data = e.getKeyframeData().getInstructions();
            Player player = ClientUtils.getClientPlayer();
            if (this.isStunned || this.rushing || this.animationTicks > 0 || this.f_19797_ < 140) {
                return;
            }
            if (data.equals("sweep1;")) {
                PacketHandler.sendToServer(new FirronKeyframePacket(((Firron)e.getAnimatable()).m_20148_(), "sweep1"));
                if (player != null) {
                    player.m_5496_((SoundEvent)SoundsRegistry.SWIFTSLICE.get(), 1.0f, 1.0f);
                }
            }
            if (data.equals("sweep2;")) {
                PacketHandler.sendToServer(new FirronKeyframePacket(((Firron)e.getAnimatable()).m_20148_(), "sweep2"));
                if (player != null) {
                    player.m_5496_((SoundEvent)SoundsRegistry.SWIFTSLICE.get(), 1.0f, 1.0f);
                }
            }
            if (data.equals("pierce;")) {
                PacketHandler.sendToServer(new FirronKeyframePacket(((Firron)e.getAnimatable()).m_20148_(), "pierce"));
                if (player != null) {
                    player.m_5496_((SoundEvent)SoundsRegistry.SWIFTSLICE_LEGACY.get(), 1.0f, 1.0f);
                }
            }
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "StatusController", state -> {
            if (this.isStunned) {
                return state.setAndContinue(STUN_LOOP);
            }
            return PlayState.STOP;
        }).triggerableAnim("stun_end", STUN_END).receiveTriggeredAnimations()});
    }

    @OnlyIn(value=Dist.CLIENT)
    private BlockParticleOptions getBlockParticleOptions() {
        return new BlockParticleOptions((ParticleType)TridotParticles.BLOCK.get(), this.m_9236_().m_8055_(this.m_20183_().m_7495_()));
    }

    public void setStunned(int duration) {
        this.stunTicks = duration;
        this.m_9236_().m_7605_((Entity)this, (byte)90);
        this.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.STUN.get(), duration, 0));
    }

    public boolean m_21515_() {
        return super.m_21515_() || this.f_19797_ < 140 || this.animationTicks > 0;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isStunned || this.f_19797_ < 140 || this.animationTicks > 0;
    }

    public void handleKeyframe(String keyframe) {
        if ("sweep1".equals(keyframe)) {
            this.performAttackPhase(1);
        } else if ("sweep2".equals(keyframe)) {
            this.performAttackPhase(2);
        } else if ("pierce".equals(keyframe)) {
            Vec3 mobPosition = this.m_20182_();
            float distance = 2.5f;
            Vec3 target = this.m_5448_() != null ? this.m_5448_().m_20182_() : this.m_20252_(0.0f).m_82490_((double)distance);
            Vec3 leapVector = target.m_82546_(mobPosition).m_82541_().m_82490_((double)distance);
            this.m_20256_(this.m_20184_().m_82549_(leapVector));
            this.f_19864_ = true;
            this.f_19812_ = true;
            this.performAttackPhase(3);
        }
    }

    private void performAttackPhase(int phase) {
        float range = phase == 1 || phase == 2 ? 1.5f : 3.0f;
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_6084_() && this.isWithinMeleeAttackRange(target, range)) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_7327_((Entity)target);
        }
    }

    public double getMeleeAttackRangeSqr(LivingEntity pEntity, float range) {
        return this.m_20205_() * range * this.m_20205_() * range + pEntity.m_20205_();
    }

    public boolean isWithinMeleeAttackRange(LivingEntity pEntity, float range) {
        double d0 = this.m_262793_(pEntity);
        return d0 <= this.getMeleeAttackRangeSqr(pEntity, range);
    }

    protected <E extends Firron> PlayState animationController(AnimationState<E> event) {
        if (this.isStunned) {
            return PlayState.STOP;
        }
        if (this.f_19797_ < 140) {
            return PlayState.STOP;
        }
        if (event.isMoving() && !event.isCurrentAnimation(RUSH_RAM)) {
            event.getController().setCustomInstructionKeyframeHandler(e -> {
                String data = e.getKeyframeData().getInstructions();
                if (data.equals("step;")) {
                    ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(5, Pos3.init((float)this.m_146903_(), (float)this.m_146904_(), (float)this.m_146907_()), 0.0f, 10.0f).intensity(0.5f).interp((Interp)Interp.bounce));
                }
            });
            return event.setAndContinue(WALK_ANIM);
        }
        if (!event.isMoving()) {
            return event.setAndContinue(IDLE_ANIM);
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void initAttacks() {
        this.selector.addAttack((AttackInstance)new RushAttack(this, 0, 60, 400));
        this.selector.addAttack((AttackInstance)new SweepAttack((PathfinderMob)this, 6.0f, 1.0f, 0, 60, 20));
        this.selector.addAttack((AttackInstance)new PiercingDashAttack((PathfinderMob)this, 8.0f, 1.0f, 0, 40, 60));
        this.selector.addAttack((AttackInstance)new TripleSweepAttack((PathfinderMob)this, 6.0f, 1.0f, 0, 60, 40));
    }

    public void m_7822_(byte pId) {
        switch (pId) {
            case 90: {
                this.isStunned = true;
                break;
            }
            case 91: {
                this.isStunned = false;
                this.triggerAnim("StatusController", "stun_end");
                break;
            }
            case 92: {
                this.rushing = true;
                this.triggerAnim("AttackController", "rush_prepare");
                break;
            }
            case 93: {
                this.rushing = false;
                break;
            }
            default: {
                super.m_7822_(pId);
            }
        }
    }

    public void m_8107_() {
        MobEffect effect;
        this.tickSystem();
        super.m_8107_();
        if (this.m_9236_().m_7654_() != null && this.f_19797_ < 140) {
            this.m_6140_();
        }
        if (this.m_21023_(effect = (MobEffect)EffectsRegistry.STUN.get()) && this.stunTicks == 0 && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)90);
            this.stunTicks = this.m_21124_(effect).m_19557_();
        }
        if (this.stunTicks > 0 && --this.stunTicks <= 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)91);
        }
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.55f;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.writeAttackInfo(pCompound);
        this.saveBossData(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readAttackInfo(pCompound);
        this.readBossData(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.setName(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.setName(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.setHealth(this.m_21223_(), this.m_21233_());
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    public boolean m_6090_() {
        return true;
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return 0.0f;
    }

    protected void m_7324_(@NotNull Entity pEntity) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || pEntity instanceof Allied;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return super.m_6779_(pTarget) && !this.m_7307_((Entity)pTarget);
    }

    public boolean m_6673_(DamageSource pSource) {
        return super.m_6673_(pSource) && this.animationTicks <= 0 && !(pSource.m_7639_() instanceof Allied) && this.f_19797_ >= 140;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            UUID playerUUID = player.m_20148_();
            this.getDamageMap().put(playerUUID, Float.valueOf(this.getDamageMap().getOrDefault(playerUUID, Float.valueOf(0.0f)).floatValue() + amount));
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ExecuteAttackGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 20.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public AttackSelector getAttackSelector() {
        return this.selector;
    }

    public AttackInstance getActiveAttack() {
        return this.currentAttack;
    }

    public void setActiveAttack(AttackInstance attackInstance) {
        this.currentAttack = attackInstance;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.getNearbyPlayers().clear();
        this.initializeNearbyPlayers(this.m_9236_(), (Entity)this);
        this.applyBonusHealth((Mob)this);
    }

    public List<UUID> getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    public boolean m_6094_() {
        return false;
    }

    public Map<UUID, Float> getDamageMap() {
        return this.damageMap;
    }

    @Nullable
    public ItemEntity m_5552_(ItemStack stack, float offsetY) {
        if (stack.m_41619_() || this.m_9236_().f_46443_) {
            return null;
        }
        this.initializeLoot(this.m_9236_(), stack, this.m_20097_().m_7494_(), offsetY);
        return null;
    }
}

