/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.boss.firron;

import com.idark.valoria.Valoria;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;
import software.bernie.geckolib.animatable.GeoEntity;

public class SweepAttack
extends AttackInstance {
    private final float speedModifier;
    public int ticksUntilNextPathRecalc;
    public double lastTargetX;
    public double lastTargetY;
    public double lastTargetZ;

    public SweepAttack(PathfinderMob mob, float range, float speedMod, int attackDelay, int attackDuration, int cooldown) {
        super(mob, 0.0f, range, attackDelay, attackDuration, cooldown);
        this.speedModifier = speedMod;
    }

    public ResourceLocation getId() {
        return Valoria.loc("firron_sweep");
    }

    public void tick() {
        double distSq;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (--this.ticksUntilNextPathRecalc <= 0 && (this.distanceToStoredTargetSqr(target) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.storeTargetPosition();
            this.ticksUntilNextPathRecalc += 5;
            this.mob.m_21573_().m_5624_((Entity)target, (double)this.speedModifier);
        }
        if ((distSq = this.mob.m_262793_(target)) > 1024.0) {
            this.ticksUntilNextPathRecalc += 10;
        } else if (distSq > 256.0) {
            this.ticksUntilNextPathRecalc += 5;
        }
    }

    private double distanceToStoredTargetSqr(LivingEntity target) {
        return target.m_20275_(this.lastTargetX, this.lastTargetY, this.lastTargetZ);
    }

    private void storeTargetPosition() {
        LivingEntity target = this.mob.m_5448_();
        this.lastTargetX = target.m_20185_();
        this.lastTargetY = target.m_20186_();
        this.lastTargetZ = target.m_20189_();
    }

    public void start(AttackSystemMob systemMob) {
        super.start(systemMob);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalc = 0;
        this.mob.m_21573_().m_5624_((Entity)this.mob.m_5448_(), (double)this.speedModifier);
        this.storeTargetPosition();
    }

    public void stop() {
        super.stop();
        this.mob.m_21561_(false);
    }

    private void faceTargetSmooth(LivingEntity target, float maxTurn) {
        double dx = target.m_20185_() - this.mob.m_20185_();
        double dz = target.m_20189_() - this.mob.m_20189_();
        float desiredYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float currentYaw = this.mob.m_146908_();
        float newYaw = Mth.m_14148_((float)currentYaw, (float)desiredYaw, (float)maxTurn);
        this.mob.m_146922_(newYaw);
        this.mob.f_20883_ = newYaw;
        this.mob.m_5616_(newYaw);
    }

    public int preference(Entity entity) {
        return 0;
    }

    public boolean canPerformAttack(LivingEntity target) {
        return this.isWithinAttackRange(target, 1.5);
    }

    public void performAttack() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_() && this.isWithinAttackRange(target, 1.5)) {
            PathfinderMob pathfinderMob = this.mob;
            if (pathfinderMob instanceof GeoEntity) {
                GeoEntity geo = (GeoEntity)pathfinderMob;
                geo.triggerAnim("AttackController", "sweep");
            }
            this.faceTargetSmooth(target, 10.0f);
        }
    }
}

