/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import java.util.UUID;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpriteParticleData;
import pro.komaru.tridot.client.gfx.particle.options.BlockParticleOptions;
import pro.komaru.tridot.client.gfx.particle.options.GenericParticleOptions;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.common.registry.entity.system.AttackInstance;
import pro.komaru.tridot.common.registry.entity.system.AttackSelector;
import pro.komaru.tridot.common.registry.entity.system.AttackSystemMob;
import pro.komaru.tridot.common.registry.entity.system.ExecuteAttackGoal;

public class AbstractElementalGolem
extends PathfinderMob
implements NeutralMob,
Enemy,
AttackSystemMob {
    public final AttackSelector selector = new AttackSelector();
    private AttackInstance currentAttack;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState attackSlapAnimationState = new AnimationState();
    public final AnimationState groundPunchAnimationState = new AnimationState();
    public final AnimationState stompAttackAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    @Nullable
    public UUID persistentAngerTarget;
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(AbstractElementalGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)60);

    public AbstractElementalGolem(EntityType<? extends PathfinderMob> type, Level pLevel) {
        super(type, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void m_8107_() {
        Level level;
        this.tickCooldowns();
        this.m_21203_();
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_21666_(serverLevel, true);
        }
        super.m_8107_();
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 60) {
            this.stompAttackAnimationState.m_216977_(this.f_19797_);
            BlockParticleOptions opt = new BlockParticleOptions((ParticleType)TridotParticles.BLOCK.get(), this.m_9236_().m_8055_(this.m_20183_().m_7495_()));
            ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((GenericParticleOptions)opt).setRenderType(TridotRenderTypes.TRANSLUCENT_BLOCK_PARTICLE).setSpinData(SpinParticleData.create().randomOffset().randomSpin(0.5f).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.02f, (float)0.0f).build()).setSpriteData(SpriteParticleData.CRUMBS_RANDOM).setLifetime(30).randomVelocity(0.45, 0.75, 0.45)).randomOffset(0.125, 0.125)).setGravity(0.75f).repeat(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 64);
        } else if (pId == 61) {
            this.attackSlapAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 62) {
            this.groundPunchAnimationState.m_216977_(this.f_19797_);
            BlockParticleOptions opt = new BlockParticleOptions((ParticleType)TridotParticles.BLOCK.get(), this.m_9236_().m_8055_(this.m_20183_().m_7495_()));
            ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create((GenericParticleOptions)opt).setRenderType(TridotRenderTypes.TRANSLUCENT_BLOCK_PARTICLE).setSpinData(SpinParticleData.create().randomOffset().randomSpin(0.5f).build()).setScaleData(GenericParticleData.create((float)0.15f, (float)0.02f, (float)0.0f).build()).setSpriteData(SpriteParticleData.CRUMBS_RANDOM).setLifetime(30).randomVelocity(0.35, 0.65, 0.35)).randomOffset(0.125, 0.125)).setGravity(0.75f).repeat(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 128);
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ExecuteAttackGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity pEntity) {
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            double d2;
            if (pEntity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)pEntity;
                d2 = livingentity.m_21133_(Attributes.f_22278_);
            } else {
                d2 = 0.0;
            }
            double d0 = d2;
            double d1 = Math.max(0.0, 1.0 - d0);
            pEntity.m_20256_(pEntity.m_20184_().m_82520_(0.0, (double)0.2f * d1, 0.0));
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
        this.writeAttackInfo(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
        this.readAttackInfo(pCompound);
    }

    public AttackSelector getAttackSelector() {
        return this.selector;
    }

    public AttackInstance getActiveAttack() {
        return this.currentAttack;
    }

    public void setActiveAttack(AttackInstance attackInstance) {
        this.currentAttack = attackInstance;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }
}

