/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.entity.living.ShadewoodSpider;
import com.idark.valoria.registries.entity.living.elemental.WickedScorpion;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.util.Tmp;

public class Scavenger
extends MultiAttackMob
implements NeutralMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState idleEatingAnimationState = new AnimationState();
    public final AnimationState idleDiggingAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState angryAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    @Nullable
    public UUID persistentAngerTarget;
    public static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)80);
    public static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(Scavenger.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Scavenger(EntityType<? extends Scavenger> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.f_21364_ = 5;
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || pEntity instanceof Scavenger;
    }

    public final boolean isLowHP() {
        return this.m_21223_() < this.m_21233_() * 0.35f;
    }

    public void m_8107_() {
        super.m_8107_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            Player plr;
            ServerLevel serverLevel = (ServerLevel)level;
            this.m_21666_(serverLevel, true);
            LivingEntity livingentity = this.m_5448_();
            UUID uuid = this.m_6120_();
            if (livingentity instanceof Player && ((plr = (Player)livingentity).m_7500_() || this.isLowHP()) && uuid != null && serverLevel.m_8791_(uuid) instanceof LivingEntity) {
                this.m_21662_();
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_267362_.m_267780_() || this.angryAnimationState.m_216984_()) {
            this.idleEatingAnimationState.m_216973_();
            this.idleDiggingAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
        }
        if (this.f_267362_.m_267780_() || this.hasTarget()) {
            this.idleEatingAnimationState.m_216973_();
            this.idleDiggingAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            this.angryAnimationState.m_216973_();
        } else {
            Player player = this.m_9236_().m_45930_((Entity)this, 12.0);
            if (player != null && !player.m_7500_() && !this.angryAnimationState.m_216984_()) {
                this.angryAnimationState.m_216977_(this.f_19797_);
                this.m_21391_((Entity)player, 180.0f, 360.0f);
                this.m_21573_().m_26573_();
            } else if ((player == null || player.m_7500_()) && this.angryAnimationState.m_216984_()) {
                this.angryAnimationState.m_216973_();
            }
        }
        if (this.attackAnimationTick > 0 && this.hasTarget()) {
            this.m_21391_((Entity)this.m_5448_(), 180.0f, 360.0f);
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_BABY_ID.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public float m_6134_() {
        return this.m_6162_() ? 1.0f : 1.45f;
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public void m_6863_(boolean Baby) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)Baby);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleEatingAnimationState.m_216973_();
            this.idleDiggingAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (Tmp.rnd.chance(0.25)) {
                this.idleAnimationTimeout = 180;
                this.idleEatingAnimationState.m_216977_(this.f_19797_);
            } else if (Tmp.rnd.chance(0.4)) {
                this.idleAnimationTimeout = 120;
                this.idleDiggingAnimationState.m_216977_(this.f_19797_);
            } else {
                this.idleAnimationTimeout = 60;
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.angryAnimationState.m_216973_();
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Scavenger> pAnimal, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return Scavenger.isBrightEnoughToSpawn((BlockAndTintGetter)pLevel, pPos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter pLevel, BlockPos pPos) {
        return pLevel.m_45524_(pPos, 0) > 8;
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)pEntity;
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectsRegistry.BLEEDING.get(), 60, 0));
        }
        return super.m_7327_(pEntity);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new AngryGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new ScavengerAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new ReasonablePanicGoal((PathfinderMob)this, 1.45f));
        this.f_21345_.m_25352_(0, new ReasonableAvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 1.25, 1.4, this.isLowHP()));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, WickedScorpion.class, 6.0f, 1.25, 1.4));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, ShadewoodSpider.class, 6.0f, 1.25, 1.4));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public double m_6048_() {
        return this.m_20206_() * 0.75f;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_271325_, 0.15f, 1.0f);
    }

    public class AngryGoal
    extends Goal {
        private final Scavenger scavenger;
        @Nullable
        private Player targetPlayer;

        public AngryGoal(Scavenger scavenger) {
            this.scavenger = scavenger;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            if (this.scavenger.hasTarget() || Scavenger.this.isLowHP()) {
                return false;
            }
            this.targetPlayer = this.scavenger.m_9236_().m_45930_((Entity)this.scavenger, 6.0);
            return this.targetPlayer != null && !this.targetPlayer.m_7500_();
        }

        public void m_8056_() {
            this.scavenger.m_6710_((LivingEntity)this.targetPlayer);
            this.scavenger.m_6925_(this.targetPlayer.m_20148_());
        }
    }

    public class ScavengerAttackGoal
    extends MultiAttackMob.TridotMeleeAttackGoal {
        public ScavengerAttackGoal(MultiAttackMob mob, double speedModifier) {
            super((MultiAttackMob)Scavenger.this, mob, speedModifier);
        }

        public int attackAnimationTick() {
            return 15;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !Scavenger.this.isLowHP();
        }

        public void beforeAttack() {
            super.beforeAttack();
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 20;
        }

        public SoundEvent getPrepareSound() {
            return null;
        }

        public SoundEvent getAttackSound() {
            return SoundEvents.f_12228_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MELEE;
        }
    }

    public class ReasonablePanicGoal
    extends PanicGoal {
        public ReasonablePanicGoal(PathfinderMob mob, double pSpeedModifier) {
            super(mob, pSpeedModifier);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_() || Scavenger.this.isLowHP();
        }
    }

    public class ReasonableAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public ReasonableAvoidEntityGoal(PathfinderMob pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier, boolean pReason) {
            super(pMob, pEntityClassToAvoid, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Scavenger.this.isLowHP();
        }
    }
}

