/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.elemental;

import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.entity.living.ShadewoodSpider;
import com.idark.valoria.registries.entity.projectile.AcidSpit;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;

public class WickedScorpion
extends MultiAttackMob
implements RangedAttackMob,
Enemy {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState tailAttackAnimationState = new AnimationState();
    public final AnimationState spitAttackAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public int tailAttackAnimationTime = 0;
    public int spitAttackAnimationTime = 0;

    public WickedScorpion(EntityType<? extends WickedScorpion> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
        this.f_21364_ = 20;
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || pEntity instanceof WickedScorpion;
    }

    public void m_8119_() {
        LivingEntity livingentity;
        super.m_8119_();
        if (this.attackAnimationTick > 0 && this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 180.0f, 360.0f);
        }
        if (this.spitAttackAnimationTime > 0) {
            --this.spitAttackAnimationTime;
            if (this.spitAttackAnimationTime == this.attackDelay() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.isWithinAttackRange(this.m_5448_(), 15.0) && (livingentity = this.m_5448_()) != null) {
                double d0 = this.m_20275_(this.m_5448_().m_20185_(), this.m_5448_().m_20186_(), this.m_5448_().m_20189_());
                float f = (float)Math.sqrt(d0) / 16.0f;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.m_6504_(this.m_5448_(), f1);
            }
        }
        if (this.tailAttackAnimationTime > 0) {
            --this.tailAttackAnimationTime;
            if (this.tailAttackAnimationTime == this.attackDelay() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.isWithinAttackRange(this.m_5448_(), 4.0) && (livingentity = this.m_5448_()) != null) {
                this.m_7327_((Entity)livingentity);
                livingentity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 120, 0));
            }
        }
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        AcidSpit spit = new AcidSpit((LivingEntity)this, this.m_9236_());
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - spit.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        spit.m_36781_(4.0);
        spit.addEffect(new MobEffectInstance(MobEffects.f_19614_, 50, 0));
        spit.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_(SoundEvents.f_12098_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)spit);
    }

    public double getAttackRangeSqr(LivingEntity pEntity, double range) {
        return (double)this.m_20205_() * range * (double)this.m_20205_() * range + (double)pEntity.m_20205_();
    }

    public double getPerceivedTargetDistanceSquareForAttack(LivingEntity pEntity) {
        return this.m_20238_(pEntity.m_20182_());
    }

    public boolean isWithinAttackRange(LivingEntity pEntity, double range) {
        double d0 = this.getPerceivedTargetDistanceSquareForAttack(pEntity);
        return d0 <= this.getAttackRangeSqr(pEntity, range);
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 3) {
            this.deathAnimationState.m_216977_(this.f_19797_);
            SoundEvent soundevent = this.m_5592_();
            if (soundevent != null) {
                this.m_5496_(soundevent, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
            this.m_21153_(0.0f);
            this.m_6667_(this.m_269291_().m_269264_());
        } else if (pId == 60) {
            this.tailAttackAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 61) {
            this.spitAttackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new ScorpionTailAttack());
        this.f_21345_.m_25352_(0, (Goal)new ScorpionSpitAttack());
        this.f_21345_.m_25352_(3, (Goal)new ScorpionAttack(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, Objects::nonNull));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, ShadewoodSpider.class, 10, true, false, Objects::nonNull));
    }

    public double m_6048_() {
        return this.m_20206_() * 0.75f;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends WickedScorpion> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.65f;
    }

    public class ScorpionTailAttack
    extends MultiAttackMob.AttackGoal {
        public ScorpionTailAttack() {
            super((MultiAttackMob)WickedScorpion.this);
        }

        public void onPrepare() {
            WickedScorpion.this.m_9236_().m_7605_((Entity)WickedScorpion.this, (byte)60);
            WickedScorpion.this.tailAttackAnimationTime = 20;
        }

        public boolean m_8036_() {
            return super.m_8036_() && WickedScorpion.this.m_20280_((Entity)WickedScorpion.this.m_5448_()) > 6.0 && WickedScorpion.this.isWithinAttackRange(WickedScorpion.this.m_5448_(), 3.0) && WickedScorpion.this.m_142582_((Entity)WickedScorpion.this.m_5448_());
        }

        protected void performAttack() {
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 120;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public SoundEvent getAttackSound() {
            return SoundEvents.f_11823_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MELEE;
        }
    }

    public class ScorpionSpitAttack
    extends MultiAttackMob.AttackGoal {
        public ScorpionSpitAttack() {
            super((MultiAttackMob)WickedScorpion.this);
        }

        public void onPrepare() {
            WickedScorpion.this.m_9236_().m_7605_((Entity)WickedScorpion.this, (byte)61);
            WickedScorpion.this.spitAttackAnimationTime = 10;
        }

        public boolean m_8036_() {
            return super.m_8036_() && WickedScorpion.this.m_20280_((Entity)WickedScorpion.this.m_5448_()) > 12.0 && WickedScorpion.this.isWithinAttackRange(WickedScorpion.this.m_5448_(), 12.0);
        }

        protected void performAttack() {
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 160;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return SoundEvents.f_11958_;
        }

        public SoundEvent getAttackSound() {
            return SoundEvents.f_12098_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.THROW;
        }
    }

    public class ScorpionAttack
    extends MultiAttackMob.TridotMeleeAttackGoal {
        public ScorpionAttack(MultiAttackMob mob, double speedModifier) {
            super((MultiAttackMob)WickedScorpion.this, mob, speedModifier);
        }

        public int attackAnimationTick() {
            return 15;
        }

        public void beforeAttack() {
            super.beforeAttack();
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)4);
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 20;
        }

        public SoundEvent getPrepareSound() {
            return null;
        }

        public SoundEvent getAttackSound() {
            return SoundEvents.f_12228_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MELEE;
        }
    }
}

