/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.TrailParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractProjectile;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.Interp;

public class PyratiteShard
extends AbstractProjectile {
    private boolean isExploded;

    public PyratiteShard(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.discardOnHit = true;
    }

    public PyratiteShard(Level pLevel, LivingEntity thrower, double damage) {
        super((EntityType)EntityTypeRegistry.PYRATITE_SHARD.get(), pLevel, thrower, damage);
        this.discardOnHit = true;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)SoundsRegistry.CRYSTAL_FALL.get();
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.isExploded) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.75f, Level.ExplosionInteraction.NONE);
                ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(3, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)this.m_20182_()), 0.0f, 30.0f).intensity(1.0f));
            }
            this.isExploded = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (!this.f_36703_) {
            Vec3 delta = this.m_20184_().m_82541_();
            Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 1.5E-4, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 1.5E-4);
            Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
            Consumer<GenericParticle> target = p -> {
                Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
                Vec3 vector = arrowPos.m_82546_(cachePos[0]);
                if (lenBetweenArrowAndParticle > 0.0f) {
                    cachePos[0] = cachePos[0].m_82549_(vector);
                    p.setPosition(cachePos[0]);
                }
            };
            ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(ColorParticleData.create((Col)Pal.pyratiteBright, (Col)Pal.pyratite).build()).setTransparencyData(GenericParticleData.create((float)1.0f, (float)0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.5f).setEasing((Interp)Interp.exp5In).build()).addTickActor(target).setGravity(0.0f).setLifetime(12).spawn(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }
}

