/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.component.client;

import com.idark.valoria.registries.item.recipe.RecipeData;
import com.mojang.datafixers.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.joml.Matrix4f;
import pro.komaru.tridot.api.TooltipTracker;

public class MaterialListClientComponent
implements ClientTooltipComponent {
    private final List<Pair<Ingredient, RecipeData>> items;
    private final int iconSize = 16;
    private final int padding = 2;
    private int textCurrentY = 0;

    public MaterialListClientComponent(List<Pair<Ingredient, RecipeData>> items) {
        this.items = items;
    }

    public static MaterialListClientComponent create(List<Pair<Ingredient, RecipeData>> items) {
        return new MaterialListClientComponent(items);
    }

    public int m_142103_() {
        return 18 * this.items.size() + 24;
    }

    public int m_142069_(Font font) {
        int maxWidth = 0;
        for (Pair<Ingredient, RecipeData> entry : this.items) {
            ItemStack stack = ((Ingredient)entry.getFirst()).m_43908_()[0];
            int currentWidth = 18 + font.m_92852_((FormattedText)stack.m_41786_());
            if (((RecipeData)entry.getSecond()).count > 1) {
                currentWidth += font.m_92852_((FormattedText)Component.m_237113_((String)(" " + ((RecipeData)entry.getSecond()).current + "/" + ((RecipeData)entry.getSecond()).count)).m_130940_(ChatFormatting.GRAY));
            }
            if (currentWidth <= maxWidth) continue;
            maxWidth = currentWidth + 60;
        }
        return maxWidth;
    }

    public void m_142440_(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        this.textCurrentY = y + 12;
        font.m_272077_((Component)Component.m_237115_((String)"tooltip.valoria.materials_needed").m_130940_(ChatFormatting.GRAY), (float)x, (float)this.textCurrentY, -1, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.textCurrentY += 12;
        for (Pair<Ingredient, RecipeData> entry : this.items) {
            ItemStack stack = ((Ingredient)entry.getFirst()).m_43908_()[0];
            MutableComponent itemName = stack.m_41786_().m_6881_().m_130940_(ChatFormatting.DARK_GRAY);
            int nameX = x + 16 + 16 + 2;
            Objects.requireNonNull(font);
            int nameY = this.textCurrentY + (16 - 9) / 2;
            font.m_272077_((Component)itemName, (float)nameX, (float)nameY, -1, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            if (((RecipeData)entry.getSecond()).count > 0) {
                MutableComponent quantityText = Component.m_237113_((String)(" " + ((RecipeData)entry.getSecond()).current)).m_130940_(((RecipeData)entry.getSecond()).isEnough ? ChatFormatting.GRAY : ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)(" / " + ((RecipeData)entry.getSecond()).count)).m_130940_(ChatFormatting.GRAY));
                font.m_271703_(((RecipeData)entry.getSecond()).isEnough ? "\u2714" : "\u274c", (float)(x + 4), (float)nameY, ((RecipeData)entry.getSecond()).isEnough ? Color.GREEN.getRGB() : Color.RED.getRGB(), false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                font.m_272077_((Component)quantityText, (float)(nameX + font.m_92852_((FormattedText)itemName)), (float)nameY, -1, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            this.textCurrentY += 18;
        }
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics graphics) {
        Objects.requireNonNull(font);
        int lineY = y + 9 / 2 - 1;
        graphics.m_280509_(x, lineY, x + TooltipTracker.getWidth(), lineY + 1, new Color(1.0f, 1.0f, 1.0f, 0.25f).getRGB());
        int currentY = y + 10;
        for (Pair<Ingredient, RecipeData> entry : this.items) {
            ItemStack stack = ((Ingredient)entry.getFirst()).m_43908_()[0];
            graphics.m_280480_(stack, x + 14, currentY + 12);
            currentY += 18;
        }
    }
}

