/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.recipe;

import com.google.gson.JsonObject;
import com.idark.valoria.registries.item.ISoulItem;
import com.idark.valoria.registries.item.types.SoulCollectorItem;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulInfuserRecipe
implements Recipe<Container> {
    private final Ingredient input;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int souls;
    private final int time;

    public SoulInfuserRecipe(ResourceLocation id, ItemStack output, int souls, int time, Ingredient input) {
        this.id = id;
        this.output = output;
        this.souls = souls;
        this.time = time;
        this.input = input;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.input.test(pContainer.m_8020_(0)) && pContainer.m_8020_(1).m_41720_() instanceof SoulCollectorItem;
    }

    public boolean m_5598_() {
        return true;
    }

    public int getTime() {
        return this.time;
    }

    public int getSouls(ItemStack itemstack) {
        int n;
        Item item = itemstack.m_41720_();
        if (item instanceof ISoulItem) {
            ISoulItem soulItem = (ISoulItem)item;
            n = soulItem.getMaxSouls() - soulItem.getCurrentSouls(itemstack);
        } else {
            n = this.souls;
        }
        return n;
    }

    public ItemStack assemble(IItemHandler itemHandler, RegistryAccess registryAccess) {
        ItemStack outputStack = this.output.m_41777_();
        ItemStack inputStack = itemHandler.getStackInSlot(0);
        Item inputItem = inputStack.m_41720_();
        CompoundTag compoundtag = inputStack.m_41783_();
        if (compoundtag != null) {
            outputStack.m_41751_(compoundtag.m_6426_());
        }
        if (inputItem instanceof ISoulItem) {
            ISoulItem soulItem = (ISoulItem)inputItem;
            CompoundTag outputTag = outputStack.m_41784_();
            outputTag.m_128405_("Souls", soulItem.getMaxSouls());
        }
        return outputStack;
    }

    @NotNull
    public ItemStack m_5874_(final @NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        IItemHandler handler = new IItemHandler(){

            public int getSlots() {
                return pContainer.m_6643_();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return pContainer.m_8020_(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
        return this.assemble(handler, pRegistryAccess);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)this.input, (Object[])new Ingredient[0]);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<SoulInfuserRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("valoria", "soul_infuser");

        @NotNull
        public SoulInfuserRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            int time = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"time");
            ItemStack input = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient"));
            int souls = 0;
            Item item = input.m_41720_();
            if (item instanceof ISoulItem) {
                ISoulItem soulItem = (ISoulItem)item;
                souls = soulItem.getMaxSouls() - soulItem.getCurrentSouls(input);
            }
            return new SoulInfuserRecipe(pRecipeId, output, souls, time, Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}));
        }

        @Nullable
        public SoulInfuserRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack output = pBuffer.m_130267_();
            int souls = pBuffer.readInt();
            int time = pBuffer.readInt();
            return new SoulInfuserRecipe(pRecipeId, output, souls, time, input);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, SoulInfuserRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.output);
            pBuffer.writeInt(pRecipe.souls);
            pBuffer.writeInt(pRecipe.getTime());
        }
    }

    public static class Type
    implements RecipeType<SoulInfuserRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "soul_infuser";
    }
}

