/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.idark.valoria.registries.item.recipe.RecipeData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class WorkbenchRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final ItemStack result;
    private final List<Pair<Ingredient, RecipeData>> inputs;

    public WorkbenchRecipe(ResourceLocation id, String group, ItemStack result, List<Pair<Ingredient, RecipeData>> inputs) {
        this.id = id;
        this.group = group;
        this.result = result;
        this.inputs = inputs;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String getCategory() {
        return this.group;
    }

    public String m_6076_() {
        return "";
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.result.m_41777_();
    }

    public List<Pair<Ingredient, RecipeData>> getInputs() {
        return this.inputs;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        for (Pair<Ingredient, RecipeData> entry : this.inputs) {
            for (int i = 0; i < ((RecipeData)entry.getSecond()).count; ++i) {
                list.add((Object)((Ingredient)entry.getFirst()));
            }
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public boolean m_5818_(Container container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        ArrayList<Pair<Ingredient, RecipeData>> required = new ArrayList<Pair<Ingredient, RecipeData>>(this.inputs);
        block0: for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            if (stack.m_41619_()) continue;
            for (Pair pair : required) {
                if (!((Ingredient)pair.getFirst()).test(stack)) continue;
                int needed = ((RecipeData)pair.getSecond()).count;
                if (stack.m_41613_() < needed) continue block0;
                required.remove(pair);
                continue block0;
            }
        }
        return required.isEmpty();
    }

    public ItemStack m_5874_(Container container, RegistryAccess access) {
        return this.result.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Type
    implements RecipeType<WorkbenchRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "heavy_workbench";
    }

    public static class Serializer
    implements RecipeSerializer<WorkbenchRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("valoria", "heavy_workbench");

        public WorkbenchRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)resultObj);
            ArrayList<Pair<Ingredient, RecipeData>> inputs = new ArrayList<Pair<Ingredient, RecipeData>>();
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (JsonElement elem : ingredients) {
                JsonObject obj = elem.getAsJsonObject();
                Ingredient ing = Ingredient.m_43917_((JsonElement)obj.get("ingredient"));
                int count = GsonHelper.m_13824_((JsonObject)obj, (String)"count", (int)1);
                inputs.add((Pair<Ingredient, RecipeData>)Pair.of((Object)ing, (Object)new RecipeData(count)));
            }
            return new WorkbenchRecipe(recipeId, group, result, inputs);
        }

        public WorkbenchRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            ItemStack result = buffer.m_130267_();
            int size = buffer.m_130242_();
            ArrayList<Pair<Ingredient, RecipeData>> inputs = new ArrayList<Pair<Ingredient, RecipeData>>();
            for (int i = 0; i < size; ++i) {
                Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int count = buffer.m_130242_();
                inputs.add((Pair<Ingredient, RecipeData>)Pair.of((Object)ing, (Object)new RecipeData(count)));
            }
            return new WorkbenchRecipe(recipeId, group, result, inputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, WorkbenchRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130055_(recipe.result);
            buffer.m_130130_(recipe.inputs.size());
            for (Pair<Ingredient, RecipeData> entry : recipe.inputs) {
                ((Ingredient)entry.getFirst()).m_43923_(buffer);
                buffer.m_130130_(((RecipeData)entry.getSecond()).count);
            }
        }
    }
}

