/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.DashParticlePacket;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.item.types.builders.AbstractKatanaBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.CooldownNotifyItem;
import pro.komaru.tridot.api.interfaces.CooldownReductionItem;
import pro.komaru.tridot.api.interfaces.DashItem;
import pro.komaru.tridot.client.render.gui.overlay.OverlayHandler;
import pro.komaru.tridot.client.render.gui.overlay.OverlayInstance;
import pro.komaru.tridot.client.render.gui.overlay.TimedOverlayInstance;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.struct.data.Seq;

public class KatanaItem
extends SwordItem
implements CooldownNotifyItem,
DashItem,
CooldownReductionItem,
TooltipComponentItem {
    public AbstractKatanaBuilder<? extends KatanaItem> builder;
    public Multimap<Attribute, AttributeModifier> defaultModifiers;
    public ArcRandom arcRandom = Tmp.rnd;

    public KatanaItem(AbstractKatanaBuilder<? extends KatanaItem> builderIn) {
        super(builderIn.tier, (int)builderIn.attackDamageIn, builderIn.attackSpeedIn, builderIn.itemProperties);
        this.builder = builderIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(builderIn.attackDamageIn + builderIn.tier.m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)builderIn.attackSpeedIn, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)AttributeReg.DASH_DISTANCE.get()), (Object)new AttributeModifier(Valoria.BASE_DASH_DISTANCE_UUID, "Tool modifier", (double)builderIn.dashDist, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public KatanaItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        this(new Builder(attackDamageIn, attackSpeedIn, builderIn).setTier(tier));
    }

    public KatanaItem(Tier tier, float attackDamageIn, float attackSpeedIn, float dashDistance, Item.Properties builderIn) {
        this(new Builder(attackDamageIn, attackSpeedIn, builderIn).setTier(tier).setDashDistance(dashDistance));
    }

    public void m_5929_(@NotNull Level worldIn, @NotNull LivingEntity livingEntityIn, @NotNull ItemStack stack, int count) {
        Player player = (Player)livingEntityIn;
        if (player.m_21252_() == this.builder.chargeTime && this.builder.chargedSound != null) {
            player.m_6330_(this.builder.chargedSound, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!slotChanged) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, true);
    }

    public SoundEvent getSoundEvent() {
        return this.builder.cooldownSound;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public static double distance(double distance, Level level, Player player) {
        double pitch = (double)(player.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(player.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
        double X = Math.sin(pitch) * Math.cos(yaw) * distance;
        double Y = Math.cos(pitch) * distance;
        double Z = Math.sin(pitch) * Math.sin(yaw) * distance;
        Vec3 pos = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        Vec3 EndPos = player.m_20252_(0.0f).m_82490_(2.0);
        HitResult hitresult = Utils.Hit.hitResult((Vec3)player.m_146892_(), (Entity)player, e -> true, (Vec3)EndPos, (Level)level);
        if (hitresult != null) {
            switch (hitresult.m_6662_()) {
                case BLOCK: 
                case MISS: {
                    X = hitresult.m_82450_().m_7096_();
                    Y = hitresult.m_82450_().m_7098_();
                    Z = hitresult.m_82450_().m_7094_();
                    break;
                }
                case ENTITY: {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    X = entity.m_20185_();
                    Y = entity.m_20186_();
                    Z = entity.m_20189_();
                }
            }
        }
        return Math.sqrt((X - pos.f_82479_) * (X - pos.f_82479_) + (Y - pos.f_82480_) * (Y - pos.f_82480_) + (Z - pos.f_82481_) * (Z - pos.f_82481_));
    }

    public boolean m_6813_(@NotNull ItemStack stack, @NotNull Level worldIn, BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.m_41622_(5, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public void applyCooldown(Player playerIn) {
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof KatanaItem)) continue;
            playerIn.m_36335_().m_41524_(item, this.getCooldownReduction(this.builder.cooldownTime, playerIn.m_21211_()));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level worldIn, Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (!playerIn.m_6144_() && handIn != InteractionHand.OFF_HAND) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    public double getDashDistance(Player player) {
        return player.m_21133_((Attribute)AttributeReg.DASH_DISTANCE.get());
    }

    public int getHurtAmount(List<LivingEntity> detectedEntities) {
        return detectedEntities.size();
    }

    public void performEffects(LivingEntity targets, Player player) {
        targets.m_147240_((double)0.4f, player.m_20185_() - targets.m_20185_(), player.m_20189_() - targets.m_20189_());
        if (EnchantmentHelper.m_44914_((LivingEntity)player) > 0) {
            int i = EnchantmentHelper.m_44914_((LivingEntity)player);
            targets.m_20254_(i * 4);
        }
    }

    public void performDash(@NotNull ItemStack stack, @NotNull Level level, @NotNull Player player, Vector3d pos, RandomSource rand) {
        double pitch = (double)(player.m_20155_().f_82470_ + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(player.m_20155_().f_82471_ + 90.0f) * Math.PI / 180.0;
        double dashDistance = this.getDashDistance(player);
        this.performDash(player, stack, dashDistance);
        if (level instanceof ServerLevel) {
            ServerLevel srv = (ServerLevel)level;
            if (!this.builder.usePacket) {
                for (int i = 0; i < 10; ++i) {
                    double locDistance = (double)i * 0.5;
                    double X = Math.sin(pitch) * Math.cos(yaw) * locDistance;
                    double Y = Math.cos(pitch) * 2.0;
                    double Z = Math.sin(pitch) * Math.sin(yaw) * locDistance;
                    srv.m_8767_(this.builder.particleOptions, pos.x + X + (rand.m_188500_() - 0.5), pos.y + Y, pos.z + Z + (rand.m_188500_() - 0.5), 1, 0.0, 0.5, 0.0, 0.0);
                    List detectedEntities = level.m_45976_(LivingEntity.class, new AABB(pos.x + X - 0.5, pos.y + Y - 0.5, pos.z + Z - 0.5, pos.x + X + 0.5, pos.y + Y + 0.5, pos.z + Z + 0.5));
                    for (LivingEntity entity : detectedEntities) {
                        if (entity.equals((Object)player)) continue;
                        entity.m_6469_(level.m_269111_().m_269075_(player), (float)(player.m_21133_(Attributes.f_22281_) / 2.0 + (double)this.getHurtAmount(detectedEntities) + (double)EnchantmentHelper.m_44821_((LivingEntity)player) + (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
                        this.performEffects(entity, player);
                        Utils.Entities.applyWithChance((LivingEntity)entity, this.builder.effects, (float)this.builder.chance, (ArcRandom)this.arcRandom);
                        if (player.m_7500_()) continue;
                        stack.m_41622_(5 + this.getHurtAmount(detectedEntities), (LivingEntity)player, plr -> plr.m_21166_(EquipmentSlot.MAINHAND));
                    }
                    if (!(locDistance >= KatanaItem.distance(dashDistance, level, player))) {
                        continue;
                    }
                    break;
                }
            } else {
                PacketHandler.sendToTracking((Level)srv, player.m_20097_(), new DashParticlePacket(player.m_20148_(), 1, 0.0f, 0.0f, 0.0f, this.builder.dashColor));
            }
        }
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entityLiving, int timeLeft) {
        RandomSource rand = level.m_213780_();
        Player player = (Player)entityLiving;
        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        if (!player.m_21255_() && player.m_21252_() >= this.builder.chargeTime) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            this.applyCooldown(player);
            this.performDash(stack, level, player, pos, rand);
            level.m_5594_(null, player.m_20097_(), this.builder.dashSound, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level.f_46443_) {
                OverlayHandler.addInstance((OverlayInstance)new TimedOverlayInstance().setTexture(this.builder.texture).setShowTime(this.builder.overlayTime).setFadeIn(0.0f));
            }
        }
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.katana").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/dash.png")), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
    }

    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (this.builder.chargeTime > 0 && flags.m_7050_()) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.katana_charge", (Object[])new Object[]{this.builder.chargeTime}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static class Builder
    extends AbstractKatanaBuilder<KatanaItem> {
        public Builder(float attackDamageIn, float attackSpeedIn, Item.Properties itemProperties) {
            super(attackDamageIn, attackSpeedIn, itemProperties);
        }

        @Override
        public KatanaItem build() {
            return new KatanaItem(this);
        }
    }
}

