/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.consumables;

import com.google.common.collect.ImmutableList;
import com.idark.valoria.client.particle.ParticleRegistry;
import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.util.ValoriaUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.Utils;

public class BandageItem
extends Item {
    public boolean removeAllEffects;
    public ImmutableList<MobEffectInstance> effects;

    public BandageItem(boolean pCure, MobEffectInstance ... pEffects) {
        super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(0).m_38758_(0.0f).m_38767_()));
        this.removeAllEffects = pCure;
        this.effects = ImmutableList.copyOf((Object[])pEffects);
    }

    public BandageItem(boolean pCure, int time, int power) {
        super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38765_().m_38760_(0).m_38758_(0.0f).m_38767_()));
        this.removeAllEffects = pCure;
        this.effects = ImmutableList.of((Object)new MobEffectInstance((MobEffect)EffectsRegistry.ALOEREGEN.get(), time, power));
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11718_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11718_;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (!world.f_46443_) {
            CriteriaTriggers.f_10592_.m_23682_((ServerPlayer)player, stack);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            for (MobEffectInstance effect : this.effects) {
                entity.m_147207_(effect, (Entity)entity);
            }
            this.cureEffects(stack, entity);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        if (world instanceof ServerLevel) {
            ServerLevel serv = (ServerLevel)world;
            double y = entity.m_20186_() + 0.7;
            serv.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.HEAL.get()), entity.m_20185_(), y, entity.m_20189_(), 12, 0.0, 0.0, 0.0, (double)0.025f);
        }
        return stack;
    }

    private void cureEffects(ItemStack stack, LivingEntity entity) {
        if (this.removeAllEffects) {
            entity.m_21220_().stream().filter(ValoriaUtils::isCurable).forEach(e -> e.getCurativeItems().add(stack));
            entity.curePotionEffects(stack);
            return;
        }
        entity.m_21195_((MobEffect)EffectsRegistry.BLEEDING.get());
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        Utils.Items.effectTooltip(this.effects, pTooltipComponents, (float)1.0f, (float)1.0f);
        if (this.removeAllEffects) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.valoria.effect_cure").m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.valoria.bleeding_cure").m_130940_(ChatFormatting.GRAY));
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }
}

