/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.registries.AttributeReg;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import pro.komaru.tridot.util.Tmp;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class RespiratorItem
extends Item
implements ICurioItem,
Vanishable {
    public RespiratorItem(Item.Properties properties) {
        super(properties);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity wearer = slotContext.entity();
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            if (player.m_7500_()) {
                return;
            }
            player.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> {
                if (nihilityLevel.getAmount() > 0.0f && slotContext.entity().f_19797_ % 160 == 0 && Tmp.rnd.chance(0.75f)) {
                    stack.m_41622_(Tmp.rnd.nextInt(1, 4), slotContext.entity(), plr -> plr.m_21166_(EquipmentSlot.HEAD));
                }
            });
        }
    }

    public boolean canEquipFromUse(SlotContext slot, ItemStack stack) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap atts = LinkedHashMultimap.create();
        atts.put((Object)((Attribute)AttributeReg.NIHILITY_RESISTANCE.get()), (Object)new AttributeModifier(uuid, "bonus", 25.0, AttributeModifier.Operation.ADDITION));
        atts.put((Object)((Attribute)AttributeReg.NIHILITY_RESILIENCE.get()), (Object)new AttributeModifier(uuid, "bonus", 0.05, AttributeModifier.Operation.MULTIPLY_TOTAL));
        return atts;
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11679_, 1.0f, 1.0f);
    }
}

