/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio;

import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.Styles;
import com.idark.valoria.util.ValoriaUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class ValoriaCurioItem
extends Item
implements ICurioItem {
    public ArcRandom arcRandom = Tmp.rnd;
    public boolean rmbEquip = true;

    public ValoriaCurioItem(Item.Properties properties) {
        super(properties);
    }

    public int immunityTime() {
        return 0;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        ServerLevel server;
        super.curioTick(slotContext, stack);
        Level level = slotContext.getWearer().m_9236_();
        if (level instanceof ServerLevel && (server = (ServerLevel)level).m_7654_().m_129921_() % 20 != 0) {
            return;
        }
        if (stack.m_204117_(TagsRegistry.FIRE_IMMUNE)) {
            slotContext.getWearer().m_252836_();
        }
        if (stack.m_204117_(TagsRegistry.POISON_IMMUNE) && slotContext.getWearer().m_21023_(MobEffects.f_19614_)) {
            slotContext.getWearer().m_21195_(MobEffects.f_19614_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (stack.m_204117_(TagsRegistry.GRANTS_IMMUNITIES)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.immunity", (Object[])new Object[]{MobEffects.f_19614_.m_19482_()}).m_130940_(ChatFormatting.GRAY));
            if (stack.m_204117_(TagsRegistry.POISON_IMMUNE)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{MobEffects.f_19614_.m_19482_()}).m_130948_((Style)Styles.nature)));
            }
            if (stack.m_204117_(TagsRegistry.BLEEDING_IMMUNE)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{((MobEffect)EffectsRegistry.BLEEDING.get()).m_19482_()}).m_130948_((Style)Styles.create(Pal.strongRed))));
            }
            if (stack.m_204117_(TagsRegistry.FIRE_IMMUNE_TIMED)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{Blocks.f_50083_.m_49954_()}).m_130948_((Style)Styles.create(Pal.infernalBright)).m_7220_((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"tooltip.valoria.timed", (Object[])new Object[]{ValoriaUtils.formatDuration(this.immunityTime() * 20, 1.0f)})).m_130948_((Style)Styles.create(Pal.lightishGray)))));
            } else if (stack.m_204117_(TagsRegistry.FIRE_IMMUNE_TIMED)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{Blocks.f_50083_.m_49954_()}).m_130948_((Style)Styles.create(Pal.infernalBright))));
            }
        }
        if (stack.m_204117_(TagsRegistry.INFLICTS_FIRE)) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.inflicts_fire").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return ValoriaUtils.onePerTypeEquip(slotContext, stack);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11676_, 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(SlotContext slot, ItemStack stack) {
        return this.rmbEquip;
    }
}

