/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio.charm;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.types.curio.ValoriaCurioItem;
import com.idark.valoria.registries.level.events.NihilityEvent;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.struct.data.Seq;
import top.theillusivec4.curios.api.SlotContext;

public class NihilityMonitorItem
extends ValoriaCurioItem
implements TooltipComponentItem {
    public NihilityMonitorItem(Item.Properties properties) {
        super(properties);
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        return Seq.with((Object[])new TooltipComponent[]{new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.nihility_monitor.level").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/nihility.png"), 0, 12), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.nihility_monitor").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/sound.png"), 6), new TextComponent(Component.m_237110_((String)"tooltip.valoria.toggle", (Object[])new Object[]{this.getToggleComponent(pStack)}).m_130940_(this.getState(pStack) ? ChatFormatting.GREEN : ChatFormatting.RED)), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130948_((Style)DotStyle.of().font(Valoria.FONT)))});
    }

    public Component getToggleComponent(ItemStack pStack) {
        return Component.m_237115_((String)("tooltip.valoria.toggle." + (this.getState(pStack) ? "on" : "off")));
    }

    public boolean getState(ItemStack pStack) {
        return pStack.m_41784_().m_128471_("ToggleState");
    }

    public void toggle(ItemStack pStack, boolean state) {
        pStack.m_41784_().m_128379_("ToggleState", !state);
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY) {
            this.toggle(pStack, this.getState(pStack));
            pPlayer.m_216990_(SoundEvents.f_271171_);
            return true;
        }
        return super.m_142305_(pStack, pOther, pSlot, pAction, pPlayer, pAccess);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap atts = LinkedHashMultimap.create();
        atts.put((Object)((Attribute)AttributeReg.NIHILITY_RESILIENCE.get()), (Object)new AttributeModifier(uuid, "bonus", 1.0, AttributeModifier.Operation.ADDITION));
        return atts;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity wearer = slotContext.entity();
        if (wearer instanceof Player) {
            Player player = (Player)wearer;
            if (!this.getState(stack)) {
                return;
            }
            player.getCapability(INihilityLevel.INSTANCE).ifPresent(nihilityLevel -> {
                float max = nihilityLevel.getMaxAmount((LivingEntity)player);
                float amount = nihilityLevel.getAmount();
                float ratio = amount / max;
                if (ratio >= NihilityEvent.damagingLevel && player.f_19797_ % (ratio >= NihilityEvent.criticalLevel ? 15 : 30) == 0) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)SoundsRegistry.NIHILITY_ALERT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            });
        }
    }
}

