/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.elemental;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.types.ValoriaSword;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;
import pro.komaru.tridot.api.interfaces.RadiusItem;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.struct.data.Seq;

public class MagmaSwordItem
extends ValoriaSword
implements RadiusItem,
OverlayRenderItem,
TooltipComponentItem {
    private static final ResourceLocation BAR = new ResourceLocation("valoria", "textures/gui/overlay/magma_charge.png");
    public ArcRandom arcRandom = Tmp.rnd;
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public MagmaSwordItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeReg.INFERNAL_DAMAGE.get()), (Object)new AttributeModifier(Valoria.BASE_INFERNAL_DAMAGE_UUID, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.attackDamage - 2.0f), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public static void addCharge(ItemStack stack, int charge) {
        CompoundTag nbt = stack.m_41784_();
        int charges = nbt.m_128451_("charge");
        nbt.m_128405_("charge", charges + charge);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return super.canApplyAtEnchantingTable(stack, enchant) && enchant != Enchantments.f_44981_;
    }

    @Override
    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (!(pAttacker instanceof Player)) {
            return true;
        }
        Player player = (Player)pAttacker;
        pStack.m_41622_(1, pAttacker, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        CompoundTag nbt = pStack.m_41784_();
        if (nbt.m_128451_("charge") < 2 && Utils.Items.getAttackStrengthScale((Player)player, (float)0.9f) && this.arcRandom.chance(0.1f)) {
            MagmaSwordItem.addCharge(pStack, 1);
        }
        if (EnchantmentHelper.m_44914_((LivingEntity)pAttacker) > 0) {
            pAttacker.m_9236_().m_5594_(null, pTarget.m_20097_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, 1.0f);
        } else if (this.arcRandom.chance(0.07f)) {
            pTarget.m_20254_(4);
            pAttacker.m_9236_().m_5594_(null, pTarget.m_20097_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        boolean flag;
        ItemStack itemstack = playerIn.m_21120_(handIn);
        ItemStack offhandStack = playerIn.m_21120_(InteractionHand.OFF_HAND);
        CompoundTag nbt = itemstack.m_41784_();
        boolean bl = flag = offhandStack.m_41720_() instanceof ShieldItem && nbt.m_128451_("charge") < 2;
        if (!playerIn.m_6144_() && !flag) {
            playerIn.m_6672_(handIn);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        RandomSource rand = worldIn.m_213780_();
        CompoundTag nbt = stack.m_41784_();
        Player player = (Player)entityLiving;
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        float damage = (float)(player.m_21133_(Attributes.f_22281_) + 5.0) + EnchantmentHelper.m_44821_((LivingEntity)player);
        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)0.3f, player.m_20189_());
        if (nbt.m_128441_("charge") && nbt.m_128451_("charge") == 2) {
            if (player.m_20070_()) {
                MagmaSwordItem.addCharge(stack, 1);
                player.m_36335_().m_41524_((Item)this, 150);
                player.m_5661_((Component)Component.m_237115_((String)"tooltip.valoria.wet").m_130940_(ChatFormatting.GRAY), true);
                worldIn.m_5594_(player, player.m_20183_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41622_(5, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
                }
                if (!worldIn.m_5776_() && worldIn instanceof ServerLevel) {
                    ServerLevel pServer = (ServerLevel)worldIn;
                    for (int i = 0; i < 16; ++i) {
                        pServer.m_8767_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_() + (rand.m_188500_() - 0.5) * 3.0, player.m_20186_() + (rand.m_188500_() - 0.5) * 3.0, player.m_20189_() + (rand.m_188500_() - 0.5) * 3.0, 1, 0.05 * ((rand.m_188500_() - 0.5) * 2.0), 0.05 * ((rand.m_188500_() - 0.5) * 2.0), 0.05 * ((rand.m_188500_() - 0.5) * 2.0), 0.0);
                        pServer.m_8767_((ParticleOptions)ParticleTypes.f_123755_, player.m_20185_() + (rand.m_188500_() - 0.5) * 3.0, player.m_20186_() + (rand.m_188500_() - 0.5) * 3.0, player.m_20189_() + (rand.m_188500_() - 0.5) * 3.0, 1, 0.05 * ((rand.m_188500_() - 0.5) * 2.0), 0.05 * ((rand.m_188500_() - 0.5) * 2.0), 0.05 * ((rand.m_188500_() - 0.5) * 2.0), 0.0);
                    }
                }
            } else {
                ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
                nbt.m_128405_("charge", 0);
                player.m_36335_().m_41524_((Item)this, 300);
                Utils.Particles.inRadius((Level)worldIn, (ItemStack)stack, (ParticleOptions)ParticleTypes.f_123755_, (Vector3d)pos, (float)0.0f, (float)player.m_20155_().f_82471_, (float)1.0f);
                Utils.Particles.inRadius((Level)worldIn, (ItemStack)stack, (ParticleOptions)ParticleTypes.f_123755_, (Vector3d)pos, (float)0.0f, (float)player.m_20155_().f_82471_, (float)4.0f);
                ValoriaUtils.radiusHit(worldIn, stack, player, (ParticleOptions)ParticleTypes.f_123744_, hitEntities, pos, 0.0f, player.m_20155_().f_82471_, 4.0f);
                for (LivingEntity damagedEntity : hitEntities) {
                    if (!player.m_6779_(damagedEntity)) continue;
                    damagedEntity.m_6469_(worldIn.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)damagedEntity.m_6336_())) * 1.35f);
                    damagedEntity.m_147240_((double)0.4f, player.m_20185_() - entityLiving.m_20185_(), player.m_20189_() - entityLiving.m_20189_());
                    damagedEntity.m_20254_(12);
                }
                worldIn.m_5594_(null, player.m_20183_(), (SoundEvent)SoundsRegistry.ERUPTION.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                if (!player.m_7500_()) {
                    stack.m_41622_(hitEntities.size(), (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
                }
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"tooltip.valoria.charges").m_130940_(ChatFormatting.GRAY), true);
        }
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.infernal_sword").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/infernal_strike.png")), new TextComponent(Component.m_237110_((String)"tooltip.valoria.magma_charges", (Object[])new Object[]{pStack.m_41784_().m_128451_("charge") + "/2"}).m_130940_(ChatFormatting.YELLOW).m_130938_(style -> style.m_131150_(Valoria.FONT))), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
    }

    public ResourceLocation getTexture() {
        return BAR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(CompoundTag tag, GuiGraphics gui, int offsetX, int offsetY) {
        int barType = (Integer)ClientConfig.MAGMA_CHARGE_BAR_TYPE.get();
        int xCord = (Integer)ClientConfig.MAGMA_CHARGE_BAR_X.get() + offsetX;
        int yCord = (Integer)ClientConfig.MAGMA_CHARGE_BAR_Y.get() + offsetY;
        if (barType == 1) {
            gui.m_280163_(BAR, xCord, yCord, 0.0f, 0.0f, 16, 34, 64, 64);
            if (tag.m_128451_("charge") == 1) {
                gui.m_280163_(BAR, xCord + 8, yCord + 18, 0.0f, 34.0f, 4, 25, 64, 64);
            } else if (tag.m_128451_("charge") == 2) {
                gui.m_280163_(BAR, xCord + 8, yCord + 18, 0.0f, 34.0f, 4, 25, 64, 64);
                gui.m_280163_(BAR, xCord + 8, yCord + 6, 0.0f, 34.0f, 4, 25, 64, 64);
                gui.m_280163_(BAR, xCord - 2, yCord - 2, 16.0f, 0.0f, 20, 38, 64, 64);
            }
        } else if (barType == 2) {
            gui.m_280163_(BAR, xCord, yCord, 20.0f, 42.0f, 22, 22, 64, 64);
            if (tag.m_128451_("charge") > 0) {
                gui.m_280163_(BAR, xCord, yCord, 42.0f, tag.m_128451_("charge") == 1 ? 20.0f : 42.0f, 22, 22, 64, 64);
            }
        }
    }
}

