/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.level.feature;

import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BloodVinesFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public BloodVinesFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        BlockPos blockpos = pContext.m_159777_();
        RandomSource randomsource = pContext.m_225041_();
        if (!worldgenlevel.m_46859_(blockpos)) {
            return false;
        }
        BlockState blockstate = worldgenlevel.m_8055_(blockpos.m_7494_());
        if (!blockstate.m_204336_(TagsRegistry.MEAT)) {
            return false;
        }
        this.placeRoof((LevelAccessor)worldgenlevel, randomsource, blockpos);
        this.placeRoofVines((LevelAccessor)worldgenlevel, randomsource, blockpos);
        return true;
    }

    private void placeRoof(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos) {
        pLevel.m_7731_(pPos, ((Block)BlockRegistry.meatBlock.get()).m_49966_(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 200; ++i) {
            blockpos$mutableblockpos.m_122154_((Vec3i)pPos, pRandom.m_188503_(6) - pRandom.m_188503_(6), pRandom.m_188503_(2) - pRandom.m_188503_(5), pRandom.m_188503_(6) - pRandom.m_188503_(6));
            if (!pLevel.m_46859_((BlockPos)blockpos$mutableblockpos)) continue;
            int j = 0;
            for (Direction direction : DIRECTIONS) {
                BlockState blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos1.m_122159_((Vec3i)blockpos$mutableblockpos, direction));
                if (blockstate.m_204336_(TagsRegistry.MEAT)) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            pLevel.m_7731_((BlockPos)blockpos$mutableblockpos, ((Block)BlockRegistry.meatBlock.get()).m_49966_(), 2);
        }
    }

    private void placeRoofVines(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            blockpos$mutableblockpos.m_122154_((Vec3i)pPos, pRandom.m_188503_(8) - pRandom.m_188503_(8), pRandom.m_188503_(2) - pRandom.m_188503_(7), pRandom.m_188503_(8) - pRandom.m_188503_(8));
            if (!pLevel.m_46859_((BlockPos)blockpos$mutableblockpos) || !(blockstate = pLevel.m_8055_(blockpos$mutableblockpos.m_7494_())).m_204336_(TagsRegistry.MEAT)) continue;
            int j = Mth.m_216271_((RandomSource)pRandom, (int)1, (int)8);
            if (pRandom.m_188503_(6) == 0) {
                j *= 2;
            }
            if (pRandom.m_188503_(5) == 0) {
                j = 1;
            }
            BloodVinesFeature.placeVinesColumn(pLevel, pRandom, blockpos$mutableblockpos, j, 17, 25);
        }
    }

    public static void placeVinesColumn(LevelAccessor pLevel, RandomSource pRandom, BlockPos.MutableBlockPos pPos, int pHeight, int pMinAge, int pMaxAge) {
        for (int i = 0; i <= pHeight; ++i) {
            if (pLevel.m_46859_((BlockPos)pPos)) {
                if (i == pHeight || !pLevel.m_46859_(pPos.m_7495_())) {
                    pLevel.m_7731_((BlockPos)pPos, (BlockState)((Block)BlockRegistry.bloodVine.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)pRandom, (int)pMinAge, (int)pMaxAge))), 2);
                    break;
                }
                pLevel.m_7731_((BlockPos)pPos, ((Block)BlockRegistry.bloodVinePlant.get()).m_49966_(), 2);
            }
            pPos.m_122173_(Direction.DOWN);
        }
    }
}

