/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.lightningBolt;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.SplittableRandom;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.client.gfx.lightningBolt.LightningEffect;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.Mathf;
import pro.komaru.tridot.util.phys.Vec3;

@OnlyIn(value=Dist.CLIENT)
public class LightningInstance {
    public int age;
    public final Vec3 start;
    public final Vec3 end;
    public final LightningBuilder builder;
    public final float[] segXOffset;
    public final float[] segZOffset;
    public final float xOffSum;
    public final float zOffSum;
    public final float segHeight;
    public final float relScale;
    public final float rotY;
    public final float rotX;

    private LightningInstance(LightningBuilder builder, Vec3 start, Vec3 end) {
        this.builder = builder;
        this.start = start;
        this.end = end;
        this.age = 0;
        float length = Mathf.distance(start, end);
        Vec3 virtualEndPos = start.cpy().add(0.0f, length, 0.0f);
        Vec3 dirVec = end.cpy().sub(start).nor();
        double dirVecXZDist = Math.sqrt(dirVec.x * dirVec.x + dirVec.z * dirVec.z);
        this.rotY = (float)(Mth.m_14136_((double)dirVec.x, (double)dirVec.z) * 57.29577951308232);
        this.rotX = (float)(Mth.m_14136_((double)dirVec.y, (double)dirVecXZDist) * 57.29577951308232);
        int segCount = builder.segCount;
        this.segXOffset = new float[segCount + 1];
        this.segZOffset = new float[segCount + 1];
        double height = virtualEndPos.y - start.y;
        this.relScale = builder.autoScale ? (float)height / 128.0f : 1.0f;
        this.segHeight = (float)height / (float)segCount;
        float xOffSum = 0.0f;
        float zOffSum = 0.0f;
        SplittableRandom rnd = new SplittableRandom(Tmp.rnd.nextLong());
        for (int segment = 0; segment < segCount + 1; ++segment) {
            this.segXOffset[segment] = xOffSum + start.x;
            this.segZOffset[segment] = zOffSum + start.z;
            if (segment >= segCount) continue;
            float maxDeflect = this.segHeight * 0.85f;
            xOffSum += Mth.m_14036_((float)((5.0f - rnd.nextFloat() * 10.0f) * builder.deflectModifier), (float)(-maxDeflect), (float)maxDeflect);
            zOffSum += Mth.m_14036_((float)((5.0f - rnd.nextFloat() * 10.0f) * builder.deflectModifier), (float)(-maxDeflect), (float)maxDeflect);
        }
        this.xOffSum = xOffSum - (virtualEndPos.x - start.x);
        this.zOffSum = zOffSum - (virtualEndPos.z - start.z);
    }

    public void renderTick(PoseStack poseStack, MultiBufferSource buffer) {
        LightningEffect.renderLightningP2PRotate(poseStack, buffer, this.start, this.end, this);
    }

    public void tick() {
        ++this.age;
        this.builder.color.a = (float)this.age / (float)this.builder.lifetime;
    }

    public Col getColor() {
        return this.builder.color;
    }

    public int getLifetime() {
        return this.builder.lifetime;
    }

    public static class LightningBuilder {
        public Col color;
        public int lifetime;
        public int segCount = 8;
        public float scaleModifier = 1.0f;
        public float deflectModifier = 1.0f;
        public float segTaper = 0.0f;
        public boolean autoScale = false;

        public LightningBuilder setColor(Col color) {
            this.color = color;
            return this;
        }

        public LightningBuilder setLifetime(int lifetime) {
            this.lifetime = lifetime;
            return this;
        }

        public LightningBuilder setSegCount(int count) {
            this.segCount = count;
            return this;
        }

        public LightningBuilder setScaleModifier(float mod) {
            this.scaleModifier = mod;
            return this;
        }

        public LightningBuilder setDeflectModifier(float mod) {
            this.deflectModifier = mod;
            return this;
        }

        public LightningBuilder setSegTaper(float tap) {
            this.segTaper = tap;
            return this;
        }

        public LightningBuilder setAutoScale(boolean value) {
            this.autoScale = value;
            return this;
        }

        public LightningInstance build(Vec3 start, Vec3 end) {
            return new LightningInstance(this, start, end);
        }
    }
}

