/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import com.mojang.blaze3d.font.GlyphInfo;
import java.awt.Color;
import java.lang.reflect.Type;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.render.text.DotStyleEffects;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Log;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.func.Prov;

public class DotStyle
extends Style {
    public Seq<StyleEffect> effects = Seq.with();

    public DotStyle(@Nullable TextColor pColor, @Nullable Boolean pBold, @Nullable Boolean pItalic, @Nullable Boolean pUnderlined, @Nullable Boolean pStrikethrough, @Nullable Boolean pObfuscated, @Nullable ClickEvent pClickEvent, @Nullable HoverEvent pHoverEvent, @Nullable String pInsertion, @Nullable ResourceLocation pFont) {
        super(pColor, pBold, pItalic, pUnderlined, pStrikethrough, pObfuscated, pClickEvent, pHoverEvent, pInsertion, pFont);
    }

    public DotStyle() {
        super(null, null, null, null, null, null, null, null, null, null);
    }

    public DotStyle from(Style style) {
        this.f_131101_ = style.f_131101_;
        this.f_131102_ = style.f_131102_;
        this.f_131103_ = style.f_131103_;
        this.f_131104_ = style.f_131104_;
        this.f_131105_ = style.f_131105_;
        this.f_131106_ = style.f_131106_;
        this.f_131107_ = style.f_131107_;
        this.f_131108_ = style.f_131108_;
        this.f_131109_ = style.f_131109_;
        this.f_131110_ = style.f_131110_;
        return this;
    }

    public static DotStyle of() {
        return new DotStyle();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (!(pOther instanceof DotStyle)) {
            return false;
        }
        DotStyle dot = (DotStyle)((Object)pOther);
        if (!dot.effects.equals(this.effects)) {
            return false;
        }
        return super.equals(pOther);
    }

    public DotStyle color(Color color) {
        return this.color(new Col(color.getRGB()));
    }

    public DotStyle color(Col color) {
        return this.color(color.toTextColor());
    }

    public DotStyle color(TextColor color) {
        this.f_131101_ = color;
        return this;
    }

    public DotStyle bold(boolean value) {
        this.f_131102_ = value;
        return this;
    }

    public DotStyle italic(boolean value) {
        this.f_131103_ = value;
        return this;
    }

    public DotStyle underlined(boolean value) {
        this.f_131104_ = value;
        return this;
    }

    public DotStyle strikethrough(boolean value) {
        this.f_131105_ = value;
        return this;
    }

    public DotStyle obfuscated(boolean value) {
        this.f_131106_ = value;
        return this;
    }

    public DotStyle insertion(String value) {
        this.f_131109_ = value;
        return this;
    }

    public DotStyle click(ClickEvent event) {
        this.f_131107_ = event;
        return this;
    }

    public DotStyle hover(HoverEvent event) {
        this.f_131108_ = event;
        return this;
    }

    public DotStyle font(ResourceLocation font) {
        this.f_131110_ = font;
        return this;
    }

    public DotStyle effects() {
        this.effects.clear();
        return this;
    }

    public DotStyle effects(StyleEffect ... effects) {
        this.effects.addAll((StyleEffect[])effects);
        return this;
    }

    public DotStyle effects(ResourceLocation ... effects) {
        Seq<StyleEffect> fx = Seq.with();
        for (ResourceLocation effect : effects) {
            fx.add(DotStyleEffects.EFFECTS.get(effect.toString()).get());
        }
        return this.effects((StyleEffect[])fx.toArray());
    }

    public DotStyle effect(StyleEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public DotStyle effect(ResourceLocation location) {
        return this.effect(DotStyleEffects.EFFECTS.get(location.toString()).get());
    }

    public DotStyle effect(String modId, String id) {
        return this.effect(new ResourceLocation(modId, id));
    }

    public Col color() {
        if (this.f_131101_ == null) {
            return Col.white;
        }
        return Col.fromARGB(this.f_131101_.m_131265_());
    }

    static {
        Component.Serializer.f_130685_ = (Gson)Util.m_137537_(() -> {
            GsonBuilder gsonbuilder = new GsonBuilder();
            gsonbuilder.disableHtmlEscaping();
            gsonbuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Component.Serializer());
            gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new DefaultSerializer());
            gsonbuilder.registerTypeHierarchyAdapter(DotStyle.class, (Object)new Serializer());
            gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
            return gsonbuilder.create();
        });
    }

    public static class EffectEntry
    implements Prov<StyleEffect> {
        public Prov<StyleEffect> initializer;
        public ResourceLocation identifier;

        public EffectEntry(Prov<StyleEffect> initializer, ResourceLocation location) {
            this.initializer = initializer;
            this.identifier = location;
        }

        @Override
        public StyleEffect get() {
            return this.initializer.get();
        }
    }

    public static abstract class StyleEffect {
        public float advance(float advance) {
            return advance;
        }

        public float alpha(float alpha) {
            return alpha;
        }

        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
        }

        public void beforeGlyphEffects(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
        }

        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
        }

        public abstract ResourceLocation id();

        public abstract void write(CompoundTag var1);

        public abstract void read(CompoundTag var1);
    }

    public static class DefaultSerializer
    implements JsonDeserializer<Style>,
    JsonSerializer<Style> {
        @javax.annotation.Nullable
        public Style deserialize(JsonElement el, Type p_131201_, JsonDeserializationContext ctx) throws JsonParseException {
            if (el.isJsonObject()) {
                JsonObject obj = el.getAsJsonObject();
                if (obj == null) {
                    return null;
                }
                if (obj.has("tridot")) {
                    return (Style)ctx.deserialize(el, DotStyle.class);
                }
                Boolean $$4 = DefaultSerializer.getOptionalFlag(obj, "bold");
                Boolean $$5 = DefaultSerializer.getOptionalFlag(obj, "italic");
                Boolean $$6 = DefaultSerializer.getOptionalFlag(obj, "underlined");
                Boolean $$7 = DefaultSerializer.getOptionalFlag(obj, "strikethrough");
                Boolean $$8 = DefaultSerializer.getOptionalFlag(obj, "obfuscated");
                TextColor $$9 = DefaultSerializer.getTextColor(obj);
                String $$10 = DefaultSerializer.getInsertion(obj);
                ClickEvent $$11 = DefaultSerializer.getClickEvent(obj);
                HoverEvent $$12 = DefaultSerializer.getHoverEvent(obj);
                ResourceLocation $$13 = DefaultSerializer.getFont(obj);
                return new Style($$9, $$4, $$5, $$6, $$7, $$8, $$11, $$12, $$10, $$13);
            }
            return null;
        }

        @javax.annotation.Nullable
        private static ResourceLocation getFont(JsonObject pJson) {
            if (pJson.has("font")) {
                String $$1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"font");
                try {
                    return new ResourceLocation($$1);
                }
                catch (ResourceLocationException var3) {
                    throw new JsonSyntaxException("Invalid font name: " + $$1);
                }
            }
            return null;
        }

        @javax.annotation.Nullable
        private static HoverEvent getHoverEvent(JsonObject pJson) {
            JsonObject $$1;
            HoverEvent $$2;
            if (pJson.has("hoverEvent") && ($$2 = HoverEvent.m_130821_((JsonObject)($$1 = GsonHelper.m_13930_((JsonObject)pJson, (String)"hoverEvent")))) != null && $$2.m_130820_().m_130847_()) {
                return $$2;
            }
            return null;
        }

        @javax.annotation.Nullable
        private static ClickEvent getClickEvent(JsonObject pJson) {
            if (pJson.has("clickEvent")) {
                JsonObject $$1 = GsonHelper.m_13930_((JsonObject)pJson, (String)"clickEvent");
                String $$2 = GsonHelper.m_13851_((JsonObject)$$1, (String)"action", (String)null);
                ClickEvent.Action $$3 = $$2 == null ? null : ClickEvent.Action.m_130645_((String)$$2);
                String $$4 = GsonHelper.m_13851_((JsonObject)$$1, (String)"value", (String)null);
                if ($$3 != null && $$4 != null && $$3.m_130644_()) {
                    return new ClickEvent($$3, $$4);
                }
            }
            return null;
        }

        @javax.annotation.Nullable
        private static String getInsertion(JsonObject pJson) {
            return GsonHelper.m_13851_((JsonObject)pJson, (String)"insertion", (String)null);
        }

        @javax.annotation.Nullable
        private static TextColor getTextColor(JsonObject pJson) {
            if (pJson.has("color")) {
                String $$1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"color");
                return TextColor.m_131268_((String)$$1);
            }
            return null;
        }

        @javax.annotation.Nullable
        private static Boolean getOptionalFlag(JsonObject pJson, String pMemberName) {
            return pJson.has(pMemberName) ? Boolean.valueOf(pJson.get(pMemberName).getAsBoolean()) : null;
        }

        @javax.annotation.Nullable
        public JsonElement serialize(Style style, Type p_131210_, JsonSerializationContext ctx) {
            if (style.m_131179_()) {
                return null;
            }
            if (style instanceof DotStyle) {
                DotStyle ds = (DotStyle)style;
                return ctx.serialize((Object)ds);
            }
            JsonObject $$3 = new JsonObject();
            if (style.f_131102_ != null) {
                $$3.addProperty("bold", style.f_131102_);
            }
            if (style.f_131103_ != null) {
                $$3.addProperty("italic", style.f_131103_);
            }
            if (style.f_131104_ != null) {
                $$3.addProperty("underlined", style.f_131104_);
            }
            if (style.f_131105_ != null) {
                $$3.addProperty("strikethrough", style.f_131105_);
            }
            if (style.f_131106_ != null) {
                $$3.addProperty("obfuscated", style.f_131106_);
            }
            if (style.f_131101_ != null) {
                $$3.addProperty("color", style.f_131101_.m_131274_());
            }
            if (style.f_131109_ != null) {
                $$3.add("insertion", ctx.serialize((Object)style.f_131109_));
            }
            if (style.f_131107_ != null) {
                JsonObject $$4 = new JsonObject();
                $$4.addProperty("action", style.f_131107_.m_130622_().m_130649_());
                $$4.addProperty("value", style.f_131107_.m_130623_());
                $$3.add("clickEvent", (JsonElement)$$4);
            }
            if (style.f_131108_ != null) {
                $$3.add("hoverEvent", (JsonElement)style.f_131108_.m_130825_());
            }
            if (style.f_131110_ != null) {
                $$3.addProperty("font", style.f_131110_.toString());
            }
            return $$3;
        }
    }

    public static class Serializer
    implements JsonDeserializer<DotStyle>,
    JsonSerializer<DotStyle> {
        public DotStyle deserialize(JsonElement obj, Type type, JsonDeserializationContext ctx) throws JsonParseException {
            if (!obj.isJsonObject()) {
                return null;
            }
            JsonObject json = obj.getAsJsonObject();
            if (json == null) {
                return null;
            }
            Boolean obool = Serializer.getOptionalFlag(json, "bold");
            Boolean obool1 = Serializer.getOptionalFlag(json, "italic");
            Boolean obool2 = Serializer.getOptionalFlag(json, "underlined");
            Boolean obool3 = Serializer.getOptionalFlag(json, "strikethrough");
            Boolean obool4 = Serializer.getOptionalFlag(json, "obfuscated");
            TextColor textcolor = Serializer.getTextColor(json);
            String s = Serializer.getInsertion(json);
            ClickEvent clickevent = Serializer.getClickEvent(json);
            HoverEvent hoverevent = Serializer.getHoverEvent(json);
            ResourceLocation resourcelocation = Serializer.getFont(json);
            DotStyle dot = new DotStyle(textcolor, obool, obool1, obool2, obool3, obool4, clickevent, hoverevent, s, resourcelocation);
            if (json.has("tridot_effects")) {
                String[] effects;
                for (String effect : effects = (String[])ctx.deserialize(json.get("tridot_effects"), String[].class)) {
                    try {
                        CompoundTag tag = TagParser.m_129359_((String)effect);
                        StyleEffect styleEffect = DotStyleEffects.read(tag);
                        if (styleEffect == null || styleEffect.id() == null) continue;
                        dot.effects.add(styleEffect);
                    }
                    catch (Exception e) {
                        Log.error("Failed to read effect: " + effect, new Object[0]);
                    }
                }
            }
            return dot;
        }

        public JsonElement serialize(DotStyle style, Type type, JsonSerializationContext ctx) {
            if (style.m_131179_()) {
                return null;
            }
            JsonObject json = new JsonObject();
            if (style.f_131102_ != null) {
                json.addProperty("bold", style.f_131102_);
            }
            if (style.f_131103_ != null) {
                json.addProperty("italic", style.f_131103_);
            }
            if (style.f_131104_ != null) {
                json.addProperty("underlined", style.f_131104_);
            }
            if (style.f_131105_ != null) {
                json.addProperty("strikethrough", style.f_131105_);
            }
            if (style.f_131106_ != null) {
                json.addProperty("obfuscated", style.f_131106_);
            }
            if (style.f_131101_ != null) {
                json.addProperty("color", style.f_131101_.m_131274_());
            }
            if (style.f_131109_ != null) {
                json.add("insertion", ctx.serialize((Object)style.f_131109_));
            }
            if (style.f_131107_ != null) {
                JsonObject jsonobject1 = new JsonObject();
                jsonobject1.addProperty("action", style.f_131107_.m_130622_().m_130649_());
                jsonobject1.addProperty("value", style.f_131107_.m_130623_());
                json.add("clickEvent", (JsonElement)jsonobject1);
            }
            if (style.f_131108_ != null) {
                json.add("hoverEvent", (JsonElement)style.f_131108_.m_130825_());
            }
            if (style.f_131110_ != null) {
                json.addProperty("font", style.f_131110_.toString());
            }
            String[] effects = new String[style.effects.size];
            for (int i = 0; i < style.effects.size; ++i) {
                StyleEffect effect = style.effects.get(i);
                CompoundTag tag = new CompoundTag();
                DotStyleEffects.write(effect, tag);
                effects[i] = tag.toString();
            }
            json.addProperty("tridot", Boolean.valueOf(true));
            json.add("tridot_effects", ctx.serialize((Object)effects));
            return json;
        }

        @javax.annotation.Nullable
        private static Boolean getOptionalFlag(JsonObject pJson, String pMemberName) {
            return pJson.has(pMemberName) ? Boolean.valueOf(pJson.get(pMemberName).getAsBoolean()) : null;
        }

        @javax.annotation.Nullable
        private static ResourceLocation getFont(JsonObject pJson) {
            if (pJson.has("font")) {
                String s = GsonHelper.m_13906_((JsonObject)pJson, (String)"font");
                try {
                    return new ResourceLocation(s);
                }
                catch (ResourceLocationException resourcelocationexception) {
                    throw new JsonSyntaxException("Invalid font name: " + s);
                }
            }
            return null;
        }

        @javax.annotation.Nullable
        private static HoverEvent getHoverEvent(JsonObject pJson) {
            JsonObject jsonobject;
            HoverEvent hoverevent;
            if (pJson.has("hoverEvent") && (hoverevent = HoverEvent.m_130821_((JsonObject)(jsonobject = GsonHelper.m_13930_((JsonObject)pJson, (String)"hoverEvent")))) != null && hoverevent.m_130820_().m_130847_()) {
                return hoverevent;
            }
            return null;
        }

        @javax.annotation.Nullable
        private static ClickEvent getClickEvent(JsonObject pJson) {
            if (pJson.has("clickEvent")) {
                JsonObject jsonobject = GsonHelper.m_13930_((JsonObject)pJson, (String)"clickEvent");
                String s = GsonHelper.m_13851_((JsonObject)jsonobject, (String)"action", (String)null);
                ClickEvent.Action clickevent$action = s == null ? null : ClickEvent.Action.m_130645_((String)s);
                String s1 = GsonHelper.m_13851_((JsonObject)jsonobject, (String)"value", (String)null);
                if (clickevent$action != null && s1 != null && clickevent$action.m_130644_()) {
                    return new ClickEvent(clickevent$action, s1);
                }
            }
            return null;
        }

        @javax.annotation.Nullable
        private static String getInsertion(JsonObject pJson) {
            return GsonHelper.m_13851_((JsonObject)pJson, (String)"insertion", (String)null);
        }

        @javax.annotation.Nullable
        private static TextColor getTextColor(JsonObject pJson) {
            if (pJson.has("color")) {
                String s = GsonHelper.m_13906_((JsonObject)pJson, (String)"color");
                return TextColor.m_131268_((String)s);
            }
            return null;
        }
    }
}

