/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import pro.komaru.tridot.client.compatibility.ShadersIntegration;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ICustomParticleRender;
import pro.komaru.tridot.client.gfx.particle.behavior.ICustomBehaviorParticleRender;
import pro.komaru.tridot.client.render.TridotRenderTypes;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LevelRenderHandler {
    public static Matrix4f MATRIX4F = null;
    static MultiBufferSource.BufferSource DELAYED_RENDER = null;
    public static RenderTarget DEPTH_CACHE;
    public static float FOG_START;
    public static List<ICustomParticleRender> particleList;
    public static Map<GenericParticle, ICustomBehaviorParticleRender> behaviorParticleList;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLevelRender(RenderLevelStageEvent event) {
        PoseStack stack = event.getPoseStack();
        float partialTicks = event.getPartialTick();
        MultiBufferSource.BufferSource bufferSource = LevelRenderHandler.getDelayedRender();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Vec3 pos = event.getCamera().m_90583_();
            stack.m_85836_();
            stack.m_85837_(-pos.f_82479_, -pos.f_82480_, -pos.f_82481_);
            for (ICustomParticleRender iCustomParticleRender : particleList) {
                iCustomParticleRender.render(stack, (MultiBufferSource)bufferSource, partialTicks);
            }
            for (GenericParticle genericParticle : behaviorParticleList.keySet()) {
                behaviorParticleList.get((Object)genericParticle).render(genericParticle, stack, (MultiBufferSource)bufferSource, partialTicks);
            }
            stack.m_85849_();
            particleList.clear();
            behaviorParticleList.clear();
            if (!ShadersIntegration.shouldApply()) {
                MATRIX4F = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            }
            FOG_START = RenderSystem.getShaderFogStart();
        }
        if (!ShadersIntegration.shouldApply()) {
            LevelRenderHandler.standardDelayedRender(event);
        } else {
            LevelRenderHandler.shadersDelayedRender(event);
        }
    }

    public static void standardDelayedRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            Matrix4f last = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            if (MATRIX4F != null) {
                RenderSystem.getModelViewMatrix().set((Matrix4fc)MATRIX4F);
            }
            for (RenderType renderType : TridotRenderTypes.translucentRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            RenderSystem.getModelViewMatrix().set((Matrix4fc)last);
            for (RenderType renderType : TridotRenderTypes.translucentParticleRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            if (MATRIX4F != null) {
                RenderSystem.getModelViewMatrix().set((Matrix4fc)MATRIX4F);
            }
            for (RenderType renderType : TridotRenderTypes.additiveRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            RenderSystem.getModelViewMatrix().set((Matrix4fc)last);
            for (RenderType renderType : TridotRenderTypes.additiveParticleRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
        }
    }

    public static void shadersDelayedRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            RenderSystem.setShaderFogStart((float)FOG_START);
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_166856_();
            if (MATRIX4F != null) {
                RenderSystem.getModelViewStack().m_252931_(MATRIX4F);
            }
            RenderSystem.applyModelViewMatrix();
            for (RenderType renderType : TridotRenderTypes.translucentParticleRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            for (RenderType renderType : TridotRenderTypes.translucentRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_166856_();
            if (MATRIX4F != null) {
                RenderSystem.getModelViewStack().m_252931_(MATRIX4F);
            }
            RenderSystem.applyModelViewMatrix();
            for (RenderType renderType : TridotRenderTypes.additiveParticleRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            for (RenderType renderType : TridotRenderTypes.additiveRenderTypes) {
                LevelRenderHandler.getDelayedRender().m_109912_(renderType);
            }
            FogRenderer.m_109017_();
        }
    }

    public static void copyDepthBuffer(RenderTarget tempRenderTarget) {
        LevelRenderHandler.setupDepthBuffer();
        LevelRenderHandler.enableStencil();
        if (tempRenderTarget == null) {
            return;
        }
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        tempRenderTarget.m_83945_(mainRenderTarget);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainRenderTarget.f_83920_);
    }

    public static void setupDepthBuffer() {
        if (DEPTH_CACHE == null) {
            DEPTH_CACHE = new TextureTarget(Minecraft.m_91087_().m_91385_().f_83915_, Minecraft.m_91087_().m_91385_().f_83916_, true, Minecraft.f_91002_);
        }
    }

    public static void enableStencil() {
        if (Minecraft.m_91087_().m_91385_().isStencilEnabled()) {
            DEPTH_CACHE.enableStencil();
        }
    }

    public static void resize(int width, int height) {
        if (DEPTH_CACHE != null) {
            DEPTH_CACHE.m_83941_(width, height, Minecraft.f_91002_);
        }
    }

    public static MultiBufferSource.BufferSource getDelayedRender() {
        if (DELAYED_RENDER == null) {
            HashMap<RenderType, BufferBuilder> buffers = new HashMap<RenderType, BufferBuilder>();
            for (RenderType type : TridotRenderTypes.renderTypes) {
                buffers.put(type, new BufferBuilder(ModList.get().isLoaded("embeddium") || ModList.get().isLoaded("rubidium") ? 0x200000 : type.m_110507_()));
            }
            DELAYED_RENDER = MultiBufferSource.m_109900_(buffers, (BufferBuilder)new BufferBuilder(256));
        }
        return DELAYED_RENDER;
    }

    static {
        FOG_START = 0.0f;
        particleList = new ArrayList<ICustomParticleRender>();
        behaviorParticleList = new HashMap<GenericParticle, ICustomBehaviorParticleRender>();
    }
}

