/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.compatibility.snakeyaml.nodes;

import java.util.List;
import pro.komaru.tridot.common.compatibility.snakeyaml.DumperOptions;
import pro.komaru.tridot.common.compatibility.snakeyaml.error.Mark;
import pro.komaru.tridot.common.compatibility.snakeyaml.nodes.CollectionNode;
import pro.komaru.tridot.common.compatibility.snakeyaml.nodes.Node;
import pro.komaru.tridot.common.compatibility.snakeyaml.nodes.NodeId;
import pro.komaru.tridot.common.compatibility.snakeyaml.nodes.Tag;

public class SequenceNode
extends CollectionNode<Node> {
    private final List<Node> value;

    public SequenceNode(Tag tag, boolean resolved, List<Node> value, Mark startMark, Mark endMark, DumperOptions.FlowStyle flowStyle) {
        super(tag, startMark, endMark, flowStyle);
        if (value == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = value;
        this.resolved = resolved;
    }

    public SequenceNode(Tag tag, List<Node> value, DumperOptions.FlowStyle flowStyle) {
        this(tag, true, value, null, null, flowStyle);
    }

    @Override
    public NodeId getNodeId() {
        return NodeId.sequence;
    }

    @Override
    public List<Node> getValue() {
        return this.value;
    }

    public void setListType(Class<?> listType) {
        for (Node node : this.value) {
            node.setType(listType);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Node node : this.getValue()) {
            if (node instanceof CollectionNode) {
                buf.append(System.identityHashCode(node));
            } else {
                buf.append(node.toString());
            }
            buf.append(",");
        }
        if (!buf.isEmpty()) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return "<" + this.getClass().getName() + " (tag=" + String.valueOf(this.getTag()) + ", value=[" + String.valueOf(buf) + "])>";
    }
}

