/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.projectiles;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractTridotArrow;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;

public abstract class AbstractProjectile
extends AbstractTridotArrow {
    public boolean velocityBased = true;
    public boolean discardOnHit = true;

    public AbstractProjectile(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AbstractProjectile(EntityType<? extends AbstractArrow> pEntityType, Level worldIn, LivingEntity thrower, double baseDamage) {
        super(pEntityType, worldIn, thrower, baseDamage);
    }

    public AbstractProjectile(EntityType<? extends AbstractArrow> pEntityType, Level worldIn, LivingEntity thrower, ItemStack thrownStackIn, double baseDamage) {
        super(pEntityType, worldIn, thrower, thrownStackIn, baseDamage);
    }

    public void setVelocityBasedDamage(boolean value) {
        this.velocityBased = value;
    }

    public void setDiscardOnHit(boolean value) {
        this.discardOnHit = value;
    }

    public boolean isDiscardOnHit() {
        return this.discardOnHit;
    }

    public boolean isVelocityBased() {
        return this.velocityBased;
    }

    public void processVelocityDamage(LivingEntity thrower, Entity entity, DamageSource damagesource) {
        double velocity = this.m_20184_().m_82553_();
        int damage = Mth.m_14165_((double)Mth.m_14008_((double)(velocity * this.f_36698_), (double)0.0, (double)2.147483647E9));
        if (this.m_36792_()) {
            long j = this.f_19796_.m_188503_(damage / 2 + 2);
            damage = (int)Math.min(j + (long)damage, Integer.MAX_VALUE);
        }
        this.hurt(thrower, entity, damagesource, damage);
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity = result.m_82443_();
        Entity shooter = this.m_19749_();
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity.m_19879_());
        }
        if (shooter == null) {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).m_21335_(entity);
            }
        }
        if (shooter instanceof LivingEntity) {
            LivingEntity thrower = (LivingEntity)shooter;
            if (this.isVelocityBased()) {
                this.processVelocityDamage(thrower, entity, damagesource);
            } else if (thrower instanceof Player) {
                Player plr = (Player)thrower;
                float f = (float)plr.m_21204_().m_22181_((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get());
                this.hurt(thrower, entity, damagesource, f);
            } else {
                this.processVelocityDamage(thrower, entity, damagesource);
            }
        }
    }

    public void hurt(LivingEntity thrower, Entity entity, DamageSource source, float damage) {
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(source, damage)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)thrower);
                EnchantmentHelper.m_44896_((LivingEntity)thrower, (Entity)livingentity);
                if (this.f_36699_ > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.f_36699_ * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                this.m_7761_(livingentity);
                if (livingentity != thrower && livingentity instanceof Player && thrower instanceof ServerPlayer) {
                    ServerPlayer serv = (ServerPlayer)thrower;
                    if (!this.m_20067_()) {
                        serv.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                    }
                }
                if (!entity.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(livingentity);
                }
                if (!this.m_9236_().f_46443_ && thrower instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)thrower;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, (Collection)this.f_36702_);
                    } else if (!entity.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayer, List.of(entity));
                    }
                }
                this.m_5496_(this.f_36700_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                if (this.discardOnHit && this.m_36796_() <= 0) {
                    this.m_146870_();
                }
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                if (this.discardOnHit) {
                    this.m_146870_();
                }
            }
        }
    }
}

