/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.entity.projectiles;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.entity.projectiles.AbstractProjectile;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;

public abstract class AbstractSupplierProjectile
extends AbstractProjectile
implements ItemSupplier {
    public static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(AbstractSupplierProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(AbstractSupplierProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public final Set<MobEffectInstance> effects = Sets.newHashSet();
    public int returningTicks;
    public boolean returnToPlayer;
    public boolean wasInGround;

    public AbstractSupplierProjectile(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public AbstractSupplierProjectile(EntityType<? extends AbstractArrow> pEntityType, Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super(pEntityType, worldIn, thrower, thrownStackIn, 0.0);
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)thrownStackIn)));
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    @Override
    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compound.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
        compound.m_128379_("DealtDamage", this.returnToPlayer);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.m_41619_()) {
            compound.m_128365_("Item", (Tag)itemstack.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)pCompound)) {
            this.addEffect(mobeffectinstance);
        }
        this.returnToPlayer = pCompound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.m_7846_())));
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item"));
        this.setItem(itemstack);
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    public boolean shouldReturnToThrower() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @Nullable
    public EntityHitResult m_6351_(@NotNull Vec3 startVec, @NotNull Vec3 endVec) {
        return this.returnToPlayer ? null : super.m_6351_(startVec, endVec);
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    @Override
    public ItemStack m_7941_() {
        return this.m_7846_().m_41777_();
    }

    public SoundEvent getReturnSound() {
        return null;
    }

    @Override
    public void spawnParticlesTrail() {
        if (this.m_6000_(this.m_20185_(), this.m_20186_(), this.m_20189_()) && !this.f_36703_ && !this.wasInGround) {
            Vec3 vector3d = this.m_20184_();
            double a3 = vector3d.f_82479_;
            double a4 = vector3d.f_82480_;
            double a0 = vector3d.f_82481_;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + a3 / 4.0, this.m_20186_() + a4 / 4.0, this.m_20189_() + a0 / 4.0, -a3, 0.1, -a0);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_36704_ > 4) {
            this.returnToPlayer = true;
        }
        Entity owner = this.m_19749_();
        if ((this.returnToPlayer || this.m_36797_()) && owner != null) {
            byte i = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
            if (i > 0 && !this.shouldReturnToThrower()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else if (i > 0) {
                this.m_36790_(true);
                Vec3 vector3d = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20188_() - this.m_20186_(), owner.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
                if (this.returningTicks == 0) {
                    this.m_5496_(this.getReturnSound(), 10.0f, 0.6f);
                }
                ++this.returningTicks;
            }
        }
    }

    protected void m_6088_() {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                player.m_19983_(this.m_7846_());
            }
        }
        super.m_6088_();
    }

    @Override
    protected void m_7761_(LivingEntity pLiving) {
        super.m_7761_(pLiving);
        Entity entity = this.m_150173_();
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effect : this.effects) {
                pLiving.m_147207_(effect, entity);
            }
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        this.wasInGround = true;
    }

    @Override
    public void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity = result.m_82443_();
        Entity shooter = this.m_19749_();
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(entity.m_19879_());
        }
        if (shooter == null) {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = this.m_269291_().m_269418_((AbstractArrow)this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).m_21335_(entity);
            }
        }
        if (shooter instanceof LivingEntity) {
            LivingEntity thrower = (LivingEntity)shooter;
            if (!this.returnToPlayer) {
                boolean flag;
                boolean bl = flag = entity.m_6095_() == EntityType.f_20566_;
                if (this.m_6060_() && !flag) {
                    entity.m_20254_(5);
                }
                if (this.isVelocityBased()) {
                    this.processVelocityDamage(thrower, entity, damagesource);
                } else {
                    int e = (int)EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)MobType.f_21640_);
                    float f = 0.0f;
                    if (thrower instanceof Player) {
                        Player plr = (Player)thrower;
                        f += (float)(plr.m_21204_().m_22181_((Attribute)AttributeRegistry.PROJECTILE_DAMAGE.get()) + (double)Math.max(0, e - 2));
                    } else {
                        this.processVelocityDamage(thrower, entity, damagesource);
                    }
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingentity = (LivingEntity)entity;
                        f += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)livingentity.m_6336_());
                    }
                    this.hurt(thrower, entity, damagesource, f);
                }
            }
        }
    }

    @Override
    public void hurt(LivingEntity thrower, Entity entity, DamageSource source, float damage) {
        super.hurt(thrower, entity, source, damage);
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44961_, (ItemStack)this.m_7846_()) == 0) {
            this.returnToPlayer = true;
        }
    }

    @Override
    public void setEffectsFromList(ImmutableList<MobEffectInstance> effects) {
        this.effects.addAll((Collection<MobEffectInstance>)effects);
    }

    protected abstract Item getDefaultItem();

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    @NotNull
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setItem(ItemStack pStack) {
        if (!pStack.m_150930_(this.getDefaultItem()) || pStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)pStack.m_255036_(1));
        }
    }
}

