/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.item.armor;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.common.registry.item.armor.SkinableArmorItem;

public class SuitArmorItem
extends SkinableArmorItem {
    public SuitArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        super.m_7373_(stack, world, list, flags);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (Screen.m_96638_()) {
                list.add((Component)Component.m_237115_((String)"tooltip.tridot.equipped").m_130940_(ChatFormatting.GRAY));
                list.add((Component)this.getArmorSetItemComponent((Player)player, stack, EquipmentSlot.HEAD));
                list.add((Component)this.getArmorSetItemComponent((Player)player, stack, EquipmentSlot.CHEST));
                list.add((Component)this.getArmorSetItemComponent((Player)player, stack, EquipmentSlot.LEGS));
                list.add((Component)this.getArmorSetItemComponent((Player)player, stack, EquipmentSlot.FEET));
            } else {
                list.add((Component)Component.m_237110_((String)"tooltip.tridot.shift_for_details", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.shift").getString()}).m_130940_(ChatFormatting.GRAY));
            }
            list.add((Component)Component.m_237119_());
        }
    }

    public static Map<EquipmentSlot, ItemStack> getFullArmorSet(ArmorMaterial material) {
        EnumMap<EquipmentSlot, ItemStack> armorSet = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        for (Item item : ForgeRegistries.ITEMS) {
            ArmorItem armorItem;
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != material) continue;
            EquipmentSlot slot = armorItem.m_40402_();
            armorSet.put(slot, new ItemStack((ItemLike)armorItem));
        }
        armorSet.putIfAbsent(EquipmentSlot.HEAD, ItemStack.f_41583_);
        armorSet.putIfAbsent(EquipmentSlot.CHEST, ItemStack.f_41583_);
        armorSet.putIfAbsent(EquipmentSlot.LEGS, ItemStack.f_41583_);
        armorSet.putIfAbsent(EquipmentSlot.FEET, ItemStack.f_41583_);
        return armorSet;
    }

    public boolean hasFullSuitOfArmorOn(Player player) {
        ItemStack boots = player.m_150109_().m_36052_(0);
        ItemStack leggings = player.m_150109_().m_36052_(1);
        ItemStack chestplate = player.m_150109_().m_36052_(2);
        ItemStack helmet = player.m_150109_().m_36052_(3);
        return !helmet.m_41619_() && !chestplate.m_41619_() && !leggings.m_41619_() && !boots.m_41619_();
    }

    public static boolean hasCorrectArmorOn(ArmorMaterial material, Player player) {
        ItemStack bootsStack = player.m_150109_().m_36052_(0);
        ItemStack leggingsStack = player.m_150109_().m_36052_(1);
        ItemStack chestplateStack = player.m_150109_().m_36052_(2);
        ItemStack helmetStack = player.m_150109_().m_36052_(3);
        Item item = bootsStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem boots = (ArmorItem)item;
            item = leggingsStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem leggings = (ArmorItem)item;
                item = chestplateStack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem chestplate = (ArmorItem)item;
                    item = helmetStack.m_41720_();
                    if (item instanceof ArmorItem) {
                        ArmorItem helmet = (ArmorItem)item;
                        return helmet.m_40401_() == material && chestplate.m_40401_() == material && leggings.m_40401_() == material && boots.m_40401_() == material;
                    }
                }
            }
        }
        return false;
    }

    public static ItemStack getArmorSetItem(ItemStack stack, EquipmentSlot slot) {
        Item item = stack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            Map<EquipmentSlot, ItemStack> armorSet = SuitArmorItem.getFullArmorSet(armorItem.m_40401_());
            return armorSet.get(slot);
        }
        return ItemStack.f_41583_;
    }

    public boolean hasArmorItem(Player player, ItemStack stack, EquipmentSlot slot) {
        return player != null && player.m_6844_(slot).m_41720_() == SuitArmorItem.getArmorSetItem(stack, slot).m_41720_();
    }

    public ChatFormatting getDisplayColor() {
        return ChatFormatting.GREEN;
    }

    public MutableComponent getArmorSetItemComponent(Player player, ItemStack stack, EquipmentSlot slot) {
        return Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)SuitArmorItem.getArmorSetItem(stack, slot).m_41778_()).m_130948_(Style.f_131099_.m_131140_(this.hasArmorItem(player, stack, slot) ? this.getDisplayColor() : ChatFormatting.RED)));
    }
}

