/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.mixin.client;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pro.komaru.tridot.common.Events;
import pro.komaru.tridot.common.config.CommonConfig;
import pro.komaru.tridot.common.registry.item.AttributeRegistry;

@Mixin(value={ForgeGui.class})
public class ForgeGuiMixin {
    @Unique
    private float tridot$lastArmorValue = -1.0f;
    @Unique
    private String tridot$cachedArmorText = "";

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    protected void renderArmor(GuiGraphics guiGraphics, int width, int height, CallbackInfo ci) {
        float currentArmor = (float)this.tridot$self().getMinecraft().f_91074_.m_21133_((Attribute)AttributeRegistry.PERCENT_ARMOR.get());
        if (currentArmor > 0.0f && ((Boolean)CommonConfig.PERCENT_ARMOR.get()).booleanValue()) {
            int left = width / 2 - 91;
            int top = height - this.tridot$self().leftHeight;
            guiGraphics.m_280218_(Events.GUI_ICONS_LOCATION, left, top - 1, 34, 9, 9, 9);
            if (Math.abs(currentArmor - this.tridot$lastArmorValue) > 0.01f) {
                String formattedValue = String.format("%.1f%%", Float.valueOf(currentArmor));
                this.tridot$cachedArmorText = I18n.m_118938_((String)"tooltip.tridot.value", (Object[])new Object[]{formattedValue});
                this.tridot$lastArmorValue = currentArmor;
            }
            guiGraphics.m_280488_(this.tridot$self().getMinecraft().f_91062_, this.tridot$cachedArmorText, left + 10, top, 0xFFFFFF);
            this.tridot$self().leftHeight += 10;
            ci.cancel();
        }
    }

    @Unique
    ForgeGui tridot$self() {
        return (ForgeGui)this;
    }
}

