/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.forge;

import com.vicmatskiv.pointblank.event.CustomEvent;
import com.vicmatskiv.pointblank.event.EventBus;
import com.vicmatskiv.pointblank.event.EventListener;
import com.vicmatskiv.pointblank.event.EventRegistrationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;

public class ForgeEventBus
implements EventBus {
    private final IEventBus forgeEventBus;
    private final Map<Class<?>, List<EventListener>> listeners = new HashMap();
    private final EventRegistrationUtil eventRegistrationUtil = new EventRegistrationUtil(this);
    private final Map<Class<? extends CustomEvent>, Class<? extends Event>> eventTypeMap;
    private final Function<Event, CustomEvent> eventMapper;

    public ForgeEventBus(IEventBus forgeEventBus, Map<Class<? extends CustomEvent>, Class<? extends Event>> eventTypeMap, Function<Event, CustomEvent> eventMapper) {
        this.forgeEventBus = forgeEventBus;
        this.eventTypeMap = eventTypeMap;
        this.eventMapper = eventMapper;
    }

    @Override
    public <T extends CustomEvent> void addListener(Class<T> eventType, EventListener listener) {
        List eventTypeListeners = this.listeners.computeIfAbsent(eventType, et -> new ArrayList());
        eventTypeListeners.add(listener);
        Class forgeEventType = this.toForgeEventType(eventType);
        if (forgeEventType != null) {
            Consumer<Event> consumer = forgeEvent -> listener.handleEvent(this.eventMapper.apply((Event)forgeEvent));
            this.forgeEventBus.addListener(EventPriority.NORMAL, false, forgeEventType, consumer);
        }
    }

    @Override
    public <T extends CustomEvent> void removeListener(Class<T> eventType, EventListener listener) {
        List eventTypeListeners = this.listeners.computeIfAbsent(eventType, et -> new ArrayList());
        eventTypeListeners.remove(listener);
    }

    private <FE extends Event> Class<FE> toForgeEventType(Class<? extends CustomEvent> eventType) {
        return this.eventTypeMap.get(eventType);
    }

    @Override
    public void postEvent(CustomEvent event) {
        List<EventListener> eventTypeListeners = this.listeners.get(event.getClass());
        if (eventTypeListeners == null) {
            return;
        }
        for (EventListener listener : eventTypeListeners) {
            listener.handleEvent(event);
        }
    }

    @Override
    public void register(Object instance) {
        this.eventRegistrationUtil.register(instance);
    }

    @Override
    public void unregister(Object instance) {
        throw new UnsupportedOperationException();
    }
}

