/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.forge;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.network.ClientBoundAddSpawnEntityDataPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.ForgePayload;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class ForgeNetworkService
implements NetworkService {
    private static SimpleChannel networkChannel = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pointblank", (String)"pointblank")).simpleChannel();

    public static void handleClientBoundAddSpawnEntityDataPacket(ClientBoundAddSpawnEntityDataPacket msg, CustomPayloadEvent.Context ctx) {
        ClientBoundAddSpawnEntityDataPacket.handle(msg, new ForgeMessageContext(ctx));
    }

    @Override
    public <M, B extends FriendlyByteBuf> void registerPacket(Class<M> packetClass, NetworkService.Direction direction, BiConsumer<M, RegistryFriendlyByteBuf> encoder, Function<RegistryFriendlyByteBuf, M> decoder, BiConsumer<M, NetworkService.MessageContext> handler) {
        networkChannel.messageBuilder(packetClass, direction == NetworkService.Direction.SERVER_TO_CLIENT ? NetworkDirection.PLAY_TO_CLIENT : NetworkDirection.PLAY_TO_SERVER).encoder(encoder).decoder(decoder).consumerMainThread((m, ctx) -> handler.accept(m, this.toContext((CustomPayloadEvent.Context)ctx))).add();
    }

    private NetworkService.MessageContext toContext(CustomPayloadEvent.Context ctx) {
        return new ForgeMessageContext(ctx);
    }

    @Override
    public void sendToClient(Object message, Player toPlayer) {
        networkChannel.send(message, PacketDistributor.PLAYER.with((Object)((ServerPlayer)toPlayer)));
    }

    @Override
    public void sendToServer(Object msg) {
        networkChannel.send(msg, Minecraft.getInstance().getConnection().getConnection());
    }

    @Override
    public CustomPacketPayload createCustomPayload(Object packet) {
        return ForgePayload.create((ResourceLocation)networkChannel.getName(), buf -> networkChannel.encode(buf, packet));
    }

    private static class ForgeMessageContext
    implements NetworkService.MessageContext {
        private CustomPayloadEvent.Context delegate;

        ForgeMessageContext(CustomPayloadEvent.Context delegate) {
            this.delegate = delegate;
        }

        @Override
        public void enqueueWork(Runnable runnable) {
            this.delegate.enqueueWork(runnable);
        }

        @Override
        public void setPacketHandled(boolean isPacketHandled) {
            this.delegate.setPacketHandled(isPacketHandled);
        }

        @Override
        public Player getSender() {
            return this.delegate.getSender();
        }

        @Override
        public boolean isClientSide() {
            return this.delegate.isClientSide();
        }
    }
}

