/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.forge;

import com.vicmatskiv.pointblank.NetworkService;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.RegistryService;
import com.vicmatskiv.pointblank.event.ClientSetupEvent;
import com.vicmatskiv.pointblank.event.CommonSetupEvent;
import com.vicmatskiv.pointblank.event.CustomEvent;
import com.vicmatskiv.pointblank.event.EntityRenderersEvent;
import com.vicmatskiv.pointblank.event.EventBus;
import com.vicmatskiv.pointblank.event.GatherDataEvent;
import com.vicmatskiv.pointblank.event.InputEvent;
import com.vicmatskiv.pointblank.event.LivingDeathEvent;
import com.vicmatskiv.pointblank.event.LivingDropsEvent;
import com.vicmatskiv.pointblank.event.LivingEvent;
import com.vicmatskiv.pointblank.event.LivingSwapItemsEvent;
import com.vicmatskiv.pointblank.event.LoadCompleteEvent;
import com.vicmatskiv.pointblank.event.PlayerEvent;
import com.vicmatskiv.pointblank.event.RegisterParticleProvidersEvent;
import com.vicmatskiv.pointblank.event.RenderHandEvent;
import com.vicmatskiv.pointblank.event.RenderLivingEvent;
import com.vicmatskiv.pointblank.event.RenderTooltipEvent;
import com.vicmatskiv.pointblank.event.TickEvent;
import com.vicmatskiv.pointblank.event.ViewportEvent;
import com.vicmatskiv.pointblank.platform.forge.ForgeConfig;
import com.vicmatskiv.pointblank.platform.forge.ForgeEventBus;
import com.vicmatskiv.pointblank.platform.forge.ForgeNetworkService;
import com.vicmatskiv.pointblank.platform.forge.ForgeRegistryService;
import com.vicmatskiv.pointblank.platform.forge.mixin.BakedModelMixin;
import com.vicmatskiv.pointblank.util.JarFileSystem;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.ModInfo;
import cpw.mods.jarhandling.SecureJar;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.model.SeparateTransformsModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.resource.DelegatingPackResources;

public class ForgePlatform
implements Platform {
    private static final Map<Class<? extends CustomEvent>, Class<? extends Event>> EVENT_TYPE_MAP = new HashMap<Class<? extends CustomEvent>, Class<? extends Event>>();
    private static final Map<Class<? extends CustomEvent>, Class<? extends Event>> BOOTSTRAP_EVENT_TYPE_MAP;
    private ForgeRegistryService<BlockEntityType<?>> forgeBlockEntityTypeRegistryservice = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"pointblank"));
    private ForgeRegistryService<Block> blockRegsitryService = new ForgeRegistryService(DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"pointblank"));
    private ForgeRegistryService<RecipeType<?>> recipeTypeRegistryService = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"pointblank"));
    private ForgeRegistryService<RecipeSerializer<?>> recipeSerializerService = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"pointblank"));
    private ForgeRegistryService<EntityType<?>> entityTypeRegistryService = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"pointblank"));
    private ForgeRegistryService<DataComponentType<?>> dataComponentTypeRegistry = new ForgeRegistryService(DeferredRegister.create((ResourceKey)BuiltInRegistries.DATA_COMPONENT_TYPE.key(), (String)"pointblank"));
    private ForgeRegistryService<MenuType<?>> menuTypeRegistry = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"pointblank"));
    private ForgeRegistryService<SoundEvent> soundRegistry = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"pointblank"));
    private ForgeRegistryService<ParticleType<?>> particleTypeRegistry = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"pointblank"));
    private ForgeRegistryService<Item> itemRegistry = new ForgeRegistryService(DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pointblank"));
    private ForgeRegistryService<CreativeModeTab> creativeModeTabRegistry = new ForgeRegistryService(DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"pointblank"));
    private ForgeRegistryService<VillagerProfession> villagerProfessionRegistry = new ForgeRegistryService(DeferredRegister.create((ResourceKey)Registries.VILLAGER_PROFESSION, (String)"pointblank"));
    private ForgeRegistryService<PoiType> poiTypeRegistry = new ForgeRegistryService(DeferredRegister.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (String)"pointblank"));
    private NetworkService networkService = new ForgeNetworkService();
    private ForgeEventBus eventBus = new ForgeEventBus(MinecraftForge.EVENT_BUS, EVENT_TYPE_MAP, this::toCommonEvent);
    private ForgeEventBus bootstrapEventBus = new ForgeEventBus(FMLJavaModLoadingContext.get().getModEventBus(), BOOTSTRAP_EVENT_TYPE_MAP, this::toCommonBootstrapEvent);

    @Override
    public void registerConfig() {
        ForgeConfig config = new ForgeConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.SPEC);
        this.getBootstrapEventBus().addListener(com.vicmatskiv.pointblank.event.ModConfigEvent.class, e -> config.onLoad((com.vicmatskiv.pointblank.event.ModConfigEvent)e));
    }

    @Override
    public boolean isClientSide() {
        return FMLLoader.getDist().isClient();
    }

    @Override
    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public EventBus getBootstrapEventBus() {
        return this.bootstrapEventBus;
    }

    private CustomEvent toCommonBootstrapEvent(Event event) {
        Event event2 = event;
        Objects.requireNonNull(event2);
        Event event3 = event2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FMLCommonSetupEvent.class, FMLClientSetupEvent.class, RegisterKeyMappingsEvent.class, net.minecraftforge.data.event.GatherDataEvent.class, FMLLoadCompleteEvent.class, ModConfigEvent.class, AddPackFindersEvent.class, EntityRenderersEvent.RegisterRenderers.class, net.minecraftforge.client.event.RegisterParticleProvidersEvent.class}, (Object)event3, n)) {
            case 0 -> {
                FMLCommonSetupEvent e = (FMLCommonSetupEvent)event3;
                yield new CommonSetupEvent();
            }
            case 1 -> {
                FMLClientSetupEvent e = (FMLClientSetupEvent)event3;
                yield new ClientSetupEvent();
            }
            case 2 -> {
                RegisterKeyMappingsEvent e = (RegisterKeyMappingsEvent)event3;
                yield new com.vicmatskiv.pointblank.event.RegisterKeyMappingsEvent(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
            }
            case 3 -> {
                net.minecraftforge.data.event.GatherDataEvent e = (net.minecraftforge.data.event.GatherDataEvent)event3;
                yield new GatherDataEvent(e.getGenerator(), e.getLookupProvider(), e.includeServer());
            }
            case 4 -> {
                FMLLoadCompleteEvent e = (FMLLoadCompleteEvent)event3;
                yield new LoadCompleteEvent();
            }
            case 5 -> {
                ModConfigEvent e = (ModConfigEvent)event3;
                yield new com.vicmatskiv.pointblank.event.ModConfigEvent();
            }
            case 6 -> {
                final AddPackFindersEvent e = (AddPackFindersEvent)event3;
                yield new com.vicmatskiv.pointblank.event.AddPackFindersEvent(this, e.getPackType()){

                    @Override
                    public void addRepositorySource(RepositorySource source) {
                        e.addRepositorySource(source);
                    }
                };
            }
            case 7 -> {
                EntityRenderersEvent.RegisterRenderers e = (EntityRenderersEvent.RegisterRenderers)event3;
                yield new EntityRenderersEvent.RegisterRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)e).registerEntityRenderer(arg_0, arg_1), (arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)e).registerBlockEntityRenderer(arg_0, arg_1));
            }
            case 8 -> {
                final net.minecraftforge.client.event.RegisterParticleProvidersEvent e = (net.minecraftforge.client.event.RegisterParticleProvidersEvent)event3;
                yield new RegisterParticleProvidersEvent(this){

                    @Override
                    public <T extends ParticleOptions> void registerSpriteSet(ParticleType<T> particleType, ParticleEngine.SpriteParticleRegistration<T> registration) {
                        e.registerSpriteSet(particleType, registration);
                    }
                };
            }
            default -> null;
        };
    }

    private CustomEvent toCommonEvent(Event event) {
        Event event2 = event;
        Objects.requireNonNull(event2);
        Event event3 = event2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TickEvent.RenderTickEvent.Pre.class, TickEvent.RenderTickEvent.Post.class, TickEvent.ClientTickEvent.Pre.class, TickEvent.ClientTickEvent.Post.class, RenderLivingEvent.Pre.class, RenderLivingEvent.Post.class, ViewportEvent.ComputeFov.class, ViewportEvent.ComputeCameraAngles.class, LivingEvent.LivingJumpEvent.class, RenderTooltipEvent.Pre.class, RenderTooltipEvent.GatherComponents.class, net.minecraftforge.client.event.RenderHandEvent.class, InputEvent.InteractionKeyMappingTriggered.class, net.minecraftforge.event.entity.living.LivingDropsEvent.class, net.minecraftforge.event.entity.living.LivingDeathEvent.class, PlayerEvent.HarvestCheck.class, TickEvent.PlayerTickEvent.class, PlayerEvent.PlayerLoggedInEvent.class, PlayerEvent.PlayerChangedDimensionEvent.class, PlayerEvent.PlayerRespawnEvent.class, LivingEquipmentChangeEvent.class, ServerStartedEvent.class, ServerAboutToStartEvent.class, VillagerTradesEvent.class, LivingSwapItemsEvent.Hands.class}, (Object)event3, n)) {
            case 0 -> {
                TickEvent.RenderTickEvent.Pre e = (TickEvent.RenderTickEvent.Pre)event3;
                yield new TickEvent.RenderTickEvent(e.getTimer(), TickEvent.Phase.START);
            }
            case 1 -> {
                TickEvent.RenderTickEvent.Post e = (TickEvent.RenderTickEvent.Post)event3;
                yield new TickEvent.RenderTickEvent(e.getTimer(), TickEvent.Phase.END);
            }
            case 2 -> {
                TickEvent.ClientTickEvent.Pre e = (TickEvent.ClientTickEvent.Pre)event3;
                yield new TickEvent.ClientTickEvent(TickEvent.Phase.START);
            }
            case 3 -> {
                TickEvent.ClientTickEvent.Post e = (TickEvent.ClientTickEvent.Post)event3;
                yield new TickEvent.ClientTickEvent(TickEvent.Phase.END);
            }
            case 4 -> {
                RenderLivingEvent.Pre e = (RenderLivingEvent.Pre)event3;
                yield new RenderLivingEvent.Pre(e.getEntity(), e.getRenderer());
            }
            case 5 -> {
                RenderLivingEvent.Post e = (RenderLivingEvent.Post)event3;
                yield new RenderLivingEvent.Post(e.getEntity(), e.getRenderer());
            }
            case 6 -> {
                final ViewportEvent.ComputeFov e = (ViewportEvent.ComputeFov)event3;
                yield new ViewportEvent.ComputeFov(this){

                    @Override
                    public void setFOV(double fov) {
                        e.setFOV(fov);
                    }

                    @Override
                    public double getFOV() {
                        return e.getFOV();
                    }
                };
            }
            case 7 -> {
                final ViewportEvent.ComputeCameraAngles e = (ViewportEvent.ComputeCameraAngles)event3;
                yield new ViewportEvent.ComputeCameraAngles(this, e.getYaw(), e.getPitch(), e.getRoll()){

                    @Override
                    public void setYaw(float yaw) {
                        super.setYaw(yaw);
                        e.setYaw(yaw);
                    }

                    @Override
                    public void setPitch(float pitch) {
                        super.setPitch(pitch);
                        e.setPitch(pitch);
                    }

                    @Override
                    public void setRoll(float roll) {
                        super.setRoll(roll);
                        e.setRoll(roll);
                    }
                };
            }
            case 8 -> {
                LivingEvent.LivingJumpEvent e = (LivingEvent.LivingJumpEvent)event3;
                yield new LivingEvent.LivingJumpEvent(e.getEntity());
            }
            case 9 -> {
                final RenderTooltipEvent.Pre e = (RenderTooltipEvent.Pre)event3;
                yield new RenderTooltipEvent.Pre(this, e.getGraphics(), e.getItemStack(), e.getComponents(), e.getX(), e.getY(), e.getFont(), e.getTooltipPositioner()){

                    @Override
                    public void setCanceled(boolean isCancelled) {
                        super.setCanceled(isCancelled);
                        e.setCanceled(isCancelled);
                    }
                };
            }
            case 10 -> {
                RenderTooltipEvent.GatherComponents e = (RenderTooltipEvent.GatherComponents)event3;
                yield new RenderTooltipEvent.GatherComponents(e.getItemStack(), e.getTooltipElements());
            }
            case 11 -> {
                net.minecraftforge.client.event.RenderHandEvent e = (net.minecraftforge.client.event.RenderHandEvent)event3;
                yield new RenderHandEvent(e.getHand(), e.getItemStack(), e.getPoseStack(), e.getPartialTick());
            }
            case 12 -> {
                final InputEvent.InteractionKeyMappingTriggered e = (InputEvent.InteractionKeyMappingTriggered)event3;
                yield new InputEvent.InteractionKeyMappingTriggered(this, null){

                    @Override
                    public void setCanceled(boolean isCancelled) {
                        super.setCanceled(isCancelled);
                        e.setCanceled(isCancelled);
                    }
                };
            }
            case 13 -> {
                net.minecraftforge.event.entity.living.LivingDropsEvent e = (net.minecraftforge.event.entity.living.LivingDropsEvent)event3;
                yield new LivingDropsEvent(e.getEntity(), e.getDrops());
            }
            case 14 -> {
                net.minecraftforge.event.entity.living.LivingDeathEvent e = (net.minecraftforge.event.entity.living.LivingDeathEvent)event3;
                yield new LivingDeathEvent(e.getEntity(), e.getSource());
            }
            case 15 -> {
                final PlayerEvent.HarvestCheck e = (PlayerEvent.HarvestCheck)event3;
                yield new PlayerEvent.HarvestCheck(this, e.getEntity(), e.getTargetBlock(), e.canHarvest()){

                    @Override
                    public void setCanHarvest(boolean success) {
                        super.setCanHarvest(success);
                        e.setCanHarvest(success);
                    }
                };
            }
            case 16 -> {
                TickEvent.PlayerTickEvent e = (TickEvent.PlayerTickEvent)event3;
                yield new TickEvent.PlayerTickEvent(e.player, e.phase == TickEvent.Phase.START ? TickEvent.Phase.START : TickEvent.Phase.END);
            }
            case 17 -> {
                PlayerEvent.PlayerLoggedInEvent e = (PlayerEvent.PlayerLoggedInEvent)event3;
                yield new PlayerEvent.PlayerLoggedInEvent(e.getEntity());
            }
            case 18 -> {
                PlayerEvent.PlayerChangedDimensionEvent e = (PlayerEvent.PlayerChangedDimensionEvent)event3;
                yield new PlayerEvent.PlayerChangedDimensionEvent(e.getEntity());
            }
            case 19 -> {
                PlayerEvent.PlayerRespawnEvent e = (PlayerEvent.PlayerRespawnEvent)event3;
                yield new PlayerEvent.PlayerRespawnEvent(e.getEntity());
            }
            case 20 -> {
                LivingEquipmentChangeEvent e = (LivingEquipmentChangeEvent)event3;
                yield new com.vicmatskiv.pointblank.event.LivingEquipmentChangeEvent(e.getEntity(), e.getSlot(), e.getFrom(), e.getTo());
            }
            case 21 -> {
                ServerStartedEvent e = (ServerStartedEvent)event3;
                yield new com.vicmatskiv.pointblank.event.ServerStartedEvent(e.getServer());
            }
            case 22 -> {
                ServerAboutToStartEvent e = (ServerAboutToStartEvent)event3;
                yield new com.vicmatskiv.pointblank.event.ServerAboutToStartEvent(e.getServer());
            }
            case 23 -> {
                VillagerTradesEvent e = (VillagerTradesEvent)event3;
                yield new com.vicmatskiv.pointblank.event.VillagerTradesEvent((Int2ObjectMap<List<VillagerTrades.ItemListing>>)e.getTrades(), e.getType());
            }
            case 24 -> {
                final LivingSwapItemsEvent.Hands e = (LivingSwapItemsEvent.Hands)event3;
                yield new LivingSwapItemsEvent.Hands(this, e.getEntity()){

                    @Override
                    public void setCanceled(boolean isCancelled) {
                        super.setCanceled(isCancelled);
                        e.setCanceled(isCancelled);
                    }
                };
            }
            default -> null;
        };
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public PackResources createDelegatingPackResources(PackLocationInfo info, PackMetadataSection packMeta, List<? extends PackResources> packs) {
        return new DelegatingPackResources(info, packMeta, packs);
    }

    @Override
    public Pack.ResourcesSupplier createPackResourceSupplier(PackResources packResources) {
        return ((DelegatingPackResources)packResources).supplier();
    }

    @Override
    public NetworkService getNetworkService() {
        return this.networkService;
    }

    @Override
    public void onRegistrationCompleted() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.forgeBlockEntityTypeRegistryservice.registerWithModEventBus(modEventBus);
        this.blockRegsitryService.registerWithModEventBus(modEventBus);
        this.recipeTypeRegistryService.registerWithModEventBus(modEventBus);
        this.recipeSerializerService.registerWithModEventBus(modEventBus);
        this.entityTypeRegistryService.registerWithModEventBus(modEventBus);
        this.dataComponentTypeRegistry.registerWithModEventBus(modEventBus);
        this.menuTypeRegistry.registerWithModEventBus(modEventBus);
        this.soundRegistry.registerWithModEventBus(modEventBus);
        this.particleTypeRegistry.registerWithModEventBus(modEventBus);
        this.itemRegistry.registerWithModEventBus(modEventBus);
        this.creativeModeTabRegistry.registerWithModEventBus(modEventBus);
        this.villagerProfessionRegistry.registerWithModEventBus(modEventBus);
        this.poiTypeRegistry.registerWithModEventBus(modEventBus);
    }

    @Override
    public RegistryService<BlockEntityType<?>> getBlockEntityTypeRegistry() {
        return this.forgeBlockEntityTypeRegistryservice;
    }

    @Override
    public RegistryService<Block> getBlockRegistryService() {
        return this.blockRegsitryService;
    }

    @Override
    public RegistryService<RecipeType<?>> getRecipeTypeRegistryService() {
        return this.recipeTypeRegistryService;
    }

    @Override
    public RegistryService<RecipeSerializer<?>> getRecipeSerializerService() {
        return this.recipeSerializerService;
    }

    @Override
    public RegistryService<EntityType<?>> getEntityTypeRegistryService() {
        return this.entityTypeRegistryService;
    }

    @Override
    public RegistryService<DataComponentType<?>> getDataComponentTypeRegistry() {
        return this.dataComponentTypeRegistry;
    }

    @Override
    public RegistryService<MenuType<?>> getMenuTypeRegistry() {
        return this.menuTypeRegistry;
    }

    @Override
    public RegistryService<SoundEvent> getSoundRegistry() {
        return this.soundRegistry;
    }

    @Override
    public RegistryService<ParticleType<?>> getParticleTypeRegistry() {
        return this.particleTypeRegistry;
    }

    @Override
    public RegistryService<Item> getItemRegistry() {
        return this.itemRegistry;
    }

    @Override
    public RegistryService<CreativeModeTab> getCreativeModeTabRegistry() {
        return this.creativeModeTabRegistry;
    }

    @Override
    public RegistryService<VillagerProfession> getVillagerProfessionRegistry() {
        return this.villagerProfessionRegistry;
    }

    @Override
    public RegistryService<PoiType> getPoiTypeRegistry() {
        return this.poiTypeRegistry;
    }

    @Override
    public boolean isClientThread() {
        return EffectiveSide.get() == LogicalSide.CLIENT;
    }

    @Override
    public ModInfo getModInfo(String modId) {
        ModFileInfo forgeModInfo = LoadingModList.get().getModFileById(modId);
        return forgeModInfo != null ? new ModInfo(modId, forgeModInfo.versionString()) : null;
    }

    @Override
    public JarFileSystem getJarFileSystem(final Path ... segments) {
        return new JarFileSystem(){
            SecureJar secureJar;
            {
                this.secureJar = SecureJar.from((Path[])segments);
            }

            @Override
            public Path getPath(String first, String ... rest) {
                return this.secureJar.getPath(first, rest);
            }
        };
    }

    @Override
    public CompoundTag getPersistentData(Player player) {
        return player.getPersistentData();
    }

    @Override
    public ResourceLocation parseRecipeResourceLocation(String location) {
        return ResourceLocation.parse((String)location);
    }

    @Override
    public Function<ItemDisplayContext, ItemTransforms> getItemTransforms(Player player, ItemStack itemStack) {
        return itemDisplayContext -> {
            Minecraft minecraft = Minecraft.getInstance();
            BakedModel bakedModel = minecraft.getItemRenderer().getModel(itemStack, MiscUtil.getLevel((Entity)player), (LivingEntity)player, player.getId() + itemDisplayContext.ordinal());
            if (bakedModel instanceof SeparateTransformsModel.Baked) {
                BakedModel baseModel = ((BakedModelMixin)bakedModel).getBaseModel();
                return baseModel.getTransforms();
            }
            return bakedModel.getTransforms();
        };
    }

    @Override
    public Entity getParentEntity(Entity entity) {
        if (entity instanceof PartEntity) {
            PartEntity entityPart = (PartEntity)entity;
            return entityPart.getParent();
        }
        return null;
    }

    static {
        EVENT_TYPE_MAP.put(TickEvent.RenderTickEvent.class, TickEvent.RenderTickEvent.class);
        EVENT_TYPE_MAP.put(TickEvent.ClientTickEvent.class, TickEvent.ClientTickEvent.class);
        EVENT_TYPE_MAP.put(RenderLivingEvent.Pre.class, RenderLivingEvent.Pre.class);
        EVENT_TYPE_MAP.put(RenderLivingEvent.Post.class, RenderLivingEvent.Post.class);
        EVENT_TYPE_MAP.put(ViewportEvent.ComputeFov.class, ViewportEvent.ComputeFov.class);
        EVENT_TYPE_MAP.put(ViewportEvent.ComputeCameraAngles.class, ViewportEvent.ComputeCameraAngles.class);
        EVENT_TYPE_MAP.put(LivingEvent.LivingJumpEvent.class, LivingEvent.LivingJumpEvent.class);
        EVENT_TYPE_MAP.put(RenderTooltipEvent.Pre.class, RenderTooltipEvent.Pre.class);
        EVENT_TYPE_MAP.put(RenderTooltipEvent.GatherComponents.class, RenderTooltipEvent.GatherComponents.class);
        EVENT_TYPE_MAP.put(RenderHandEvent.class, net.minecraftforge.client.event.RenderHandEvent.class);
        EVENT_TYPE_MAP.put(InputEvent.InteractionKeyMappingTriggered.class, InputEvent.InteractionKeyMappingTriggered.class);
        EVENT_TYPE_MAP.put(LivingDropsEvent.class, net.minecraftforge.event.entity.living.LivingDropsEvent.class);
        EVENT_TYPE_MAP.put(LivingDeathEvent.class, net.minecraftforge.event.entity.living.LivingDeathEvent.class);
        EVENT_TYPE_MAP.put(PlayerEvent.HarvestCheck.class, PlayerEvent.HarvestCheck.class);
        EVENT_TYPE_MAP.put(TickEvent.PlayerTickEvent.class, TickEvent.PlayerTickEvent.class);
        EVENT_TYPE_MAP.put(PlayerEvent.PlayerLoggedInEvent.class, PlayerEvent.PlayerLoggedInEvent.class);
        EVENT_TYPE_MAP.put(PlayerEvent.PlayerChangedDimensionEvent.class, PlayerEvent.PlayerChangedDimensionEvent.class);
        EVENT_TYPE_MAP.put(PlayerEvent.PlayerRespawnEvent.class, PlayerEvent.PlayerRespawnEvent.class);
        EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.LivingEquipmentChangeEvent.class, LivingEquipmentChangeEvent.class);
        EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.ServerStartedEvent.class, ServerStartedEvent.class);
        EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.ServerAboutToStartEvent.class, ServerAboutToStartEvent.class);
        EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.VillagerTradesEvent.class, VillagerTradesEvent.class);
        EVENT_TYPE_MAP.put(LivingSwapItemsEvent.Hands.class, LivingSwapItemsEvent.Hands.class);
        BOOTSTRAP_EVENT_TYPE_MAP = new HashMap<Class<? extends CustomEvent>, Class<? extends Event>>();
        BOOTSTRAP_EVENT_TYPE_MAP.put(CommonSetupEvent.class, FMLCommonSetupEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(ClientSetupEvent.class, FMLClientSetupEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(LoadCompleteEvent.class, FMLLoadCompleteEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.AddPackFindersEvent.class, AddPackFindersEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.RegisterKeyMappingsEvent.class, RegisterKeyMappingsEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(GatherDataEvent.class, net.minecraftforge.data.event.GatherDataEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(EntityRenderersEvent.RegisterRenderers.class, EntityRenderersEvent.RegisterRenderers.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(RegisterParticleProvidersEvent.class, net.minecraftforge.client.event.RegisterParticleProvidersEvent.class);
        BOOTSTRAP_EVENT_TYPE_MAP.put(com.vicmatskiv.pointblank.event.ModConfigEvent.class, ModConfigEvent.class);
    }
}

