/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank;

import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.client.effect.EffectLauncher;
import com.vicmatskiv.pointblank.event.AttachmentRemovedEvent;
import com.vicmatskiv.pointblank.event.LivingDeathEvent;
import com.vicmatskiv.pointblank.event.LivingDropsEvent;
import com.vicmatskiv.pointblank.event.LivingEquipmentChangeEvent;
import com.vicmatskiv.pointblank.event.LivingSwapItemsEvent;
import com.vicmatskiv.pointblank.event.PlayerEvent;
import com.vicmatskiv.pointblank.event.ServerAboutToStartEvent;
import com.vicmatskiv.pointblank.event.ServerStartedEvent;
import com.vicmatskiv.pointblank.event.SubscribeEvent2;
import com.vicmatskiv.pointblank.event.TickEvent;
import com.vicmatskiv.pointblank.event.VillagerTradesEvent;
import com.vicmatskiv.pointblank.item.AmmoItem;
import com.vicmatskiv.pointblank.item.FireModeInstance;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import com.vicmatskiv.pointblank.network.ClientBoundPlayerDataSyncPacket;
import com.vicmatskiv.pointblank.registry.AmmoRegistry;
import com.vicmatskiv.pointblank.registry.BlockRegistry;
import com.vicmatskiv.pointblank.registry.EffectRegistry;
import com.vicmatskiv.pointblank.registry.ItemRegistry;
import com.vicmatskiv.pointblank.registry.MiscItemRegistry;
import com.vicmatskiv.pointblank.registry.VillagerRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.InventoryUtils;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.ServerTaskScheduler;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import com.vicmatskiv.pointblank.util.Tradeable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1264;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3853;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class CommonEventHandler {
    private final ServerTaskScheduler scheduler;
    private final Random random = new Random();

    public CommonEventHandler(ServerTaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @SubscribeEvent2
    public void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        VillagerRegistry.registerStructures(event.getServer());
    }

    @SubscribeEvent2
    public void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        server.method_3742((Runnable)this.scheduler);
    }

    @SubscribeEvent2
    public void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerRegistry.ARMS_DEALER_PROFESSION.get()) {
            for (Map.Entry<String, Supplier<? extends class_1792>> e : ItemRegistry.ITEMS.getItemsByName().entrySet()) {
                int emeraldCount;
                List levelTrades;
                class_1792 item = e.getValue().get();
                if (!(item instanceof Tradeable)) continue;
                Tradeable tradeableItem = (Tradeable)item;
                float price = tradeableItem.getPrice();
                int tradeLevel = tradeableItem.getTradeLevel();
                if (Float.isNaN(price) || tradeLevel < 1 || tradeLevel > 5 || (levelTrades = (List)event.getTrades().get(tradeLevel)) == null || (emeraldCount = (int)Math.round((double)price / Config.emeraldExchangeRate)) <= 0) continue;
                class_3853.class_4165 ife = new class_3853.class_4165(new class_1799((class_1935)item), emeraldCount, tradeableItem.getBundleQuantity(), 16, 1);
                levelTrades.add(ife);
            }
        }
    }

    @SubscribeEvent2
    public void onSwapHands(LivingSwapItemsEvent.Hands event) {
        class_1799 toOffhand = event.getItemSwappedToOffHand();
        if (toOffhand != null && (toOffhand.method_7909() instanceof GunItem || toOffhand.method_7909() instanceof ThrowableItem)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent2
    public void onLivingDrops(LivingDropsEvent event) {
        float dropChance = (float)Config.itemDropChance;
        if (MiscUtil.isNearlyZero(dropChance)) {
            return;
        }
        float randomNumber = this.random.nextFloat();
        if (event.getEntity() instanceof class_1588 && randomNumber < dropChance) {
            class_1799 itemStackToDrop = new class_1799((class_1935)MiscItemRegistry.GUNMETAL_NUGGET.get(), this.random.nextInt(1, Config.maxItemDropCount));
            class_1542 drop = new class_1542(event.getEntity().method_37908(), event.getEntity().method_23317(), event.getEntity().method_23318(), event.getEntity().method_23321(), itemStackToDrop);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent2
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        class_1799 itemStack;
        class_1657 mainPlayer;
        if (MiscUtil.isClientSide((class_1297)event.player) && event.player != (mainPlayer = ClientUtil.getClientPlayer())) {
            class_1799 itemStack2 = event.player.method_6047();
            GunClientState state = GunClientState.getMainHeldState(event.player);
            if (state != null) {
                state.stateTick((class_1309)event.player, itemStack2, false);
            }
        }
        if ((itemStack = event.player.method_6047()) != null && itemStack.method_7909() instanceof GunItem) {
            GunClientState state;
            if (GunItem.isAiming(itemStack)) {
                event.player.method_5728(false);
            }
            if (MiscUtil.isClientSide((class_1297)event.player) && (state = GunClientState.getMainHeldState(event.player)) != null && !state.isIdle() && !state.isDrawing()) {
                event.player.method_5728(false);
            }
        }
    }

    @SubscribeEvent2
    public void onHarvestCheck(PlayerEvent.HarvestCheck check) {
        class_1657 player;
        class_1799 heldItem;
        if (check.getTargetBlock().method_27852(BlockRegistry.PRINTER.get()) && (heldItem = (player = check.getEntity()).method_6047()) != null && heldItem.method_7909() instanceof class_1810) {
            check.setCanHarvest(true);
        }
    }

    @SubscribeEvent2
    public void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        class_1309 class_13092;
        if (event.getTo() != null && (event.getTo().method_7909() instanceof GunItem || event.getTo().method_7909() instanceof ThrowableItem) && (class_13092 = event.getEntity()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (event.getSlot() == class_1304.field_6171) {
                class_1799 copy = event.getTo().method_7972();
                player.method_31548().field_7544.clear();
                class_243 playerPos = event.getEntity().method_30950(0.0f);
                class_1264.method_5449((class_1937)MiscUtil.getLevel((class_1297)event.getEntity()), (double)playerPos.field_1352, (double)playerPos.field_1351, (double)playerPos.field_1350, (class_1799)copy);
            }
        }
    }

    @SubscribeEvent2
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        class_1657 player = event.getEntity();
        class_1937 level = MiscUtil.getLevel((class_1297)player);
        if (!level.field_9236) {
            Platform.getInstance().getNetworkService().sendToClient(new ClientBoundPlayerDataSyncPacket(MiscUtil.getPersistentData(player), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> class_7923.field_41178.method_10206((Object)((class_1792)v.get()))).collect(Collectors.toList())), player);
        }
    }

    @SubscribeEvent2
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        class_1657 player = event.getEntity();
        class_1937 level = MiscUtil.getLevel((class_1297)player);
        if (!level.field_9236) {
            Platform.getInstance().getNetworkService().sendToClient(new ClientBoundPlayerDataSyncPacket(MiscUtil.getPersistentData(player), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> class_7923.field_41178.method_10206((Object)((class_1792)v.get()))).collect(Collectors.toList())), player);
        }
    }

    @SubscribeEvent2
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        class_1657 player = event.getEntity();
        class_1937 level = MiscUtil.getLevel((class_1297)player);
        if (!level.field_9236) {
            Platform.getInstance().getNetworkService().sendToClient(new ClientBoundPlayerDataSyncPacket(MiscUtil.getPersistentData(player), ItemRegistry.ITEMS.getItemsByName().values().stream().filter(v -> v != null).map(v -> class_7923.field_41178.method_10206((Object)((class_1792)v.get()))).collect(Collectors.toList())), player);
        }
    }

    @SubscribeEvent2
    public void onAttachmentRemoved(AttachmentRemovedEvent event) {
        class_1799 rootStack = event.getRootStack();
        class_1792 class_17922 = rootStack.method_7909();
        if (!(class_17922 instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)class_17922;
        class_1657 player = event.getPlayer();
        if (player == null || MiscUtil.isClientSide((class_1297)player)) {
            return;
        }
        List<FireModeInstance> fireModeInstances = gunItem.getMainFireModes();
        for (FireModeInstance fireModeInstance : fireModeInstances) {
            int dropCount;
            int maxAmmoCapacity;
            int currentFireModeAmmo = GunItem.getAmmo(rootStack, fireModeInstance);
            int delta = Math.min(currentFireModeAmmo - (maxAmmoCapacity = gunItem.getMaxAmmoCapacity(rootStack, fireModeInstance)), 1728);
            if (delta <= 0) continue;
            List<AmmoItem> actualAmmo = fireModeInstance.getActualAmmo();
            AmmoItem ammoToRemove = null;
            if (actualAmmo.size() == 1) {
                ammoToRemove = actualAmmo.get(0);
            } else if (actualAmmo.size() > 1) {
                AmmoItem creativeAmmo = AmmoRegistry.AMMOCREATIVE.get();
                ammoToRemove = actualAmmo.contains(creativeAmmo) && player.method_7337() ? creativeAmmo : (AmmoItem)actualAmmo.stream().filter(a -> a != creativeAmmo).findAny().orElse(null);
            }
            if (ammoToRemove == null) continue;
            GunItem.setAmmo(rootStack, fireModeInstance, maxAmmoCapacity);
            for (int remainingCount = InventoryUtils.addItem(player, ammoToRemove, delta); remainingCount > 0; remainingCount -= dropCount) {
                dropCount = Math.min(ammoToRemove.method_7882(), remainingCount);
                class_1264.method_5449((class_1937)MiscUtil.getLevel((class_1297)event.getPlayer()), (double)(player.method_23317() + 1.25), (double)(player.method_23318() + 1.25), (double)player.method_23321(), (class_1799)new class_1799((class_1935)ammoToRemove, dropCount));
            }
        }
    }

    @SubscribeEvent2
    public void onLivingDeath(LivingDeathEvent event) {
        class_1297 class_12972;
        class_1282 damageSource = event.getSource();
        if (damageSource != null && (class_12972 = damageSource.method_5529()) instanceof class_1657) {
            GunClientState state;
            class_1657 player = (class_1657)class_12972;
            if (!MiscUtil.getLevel((class_1297)player).field_9236 && (state = GunClientState.getMainHeldState(player)) != null) {
                class_1309 targetEntity = event.getEntity();
                List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> effects = EffectRegistry.getEntityDeathEffects(targetEntity);
                for (Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>> supplier : effects) {
                    class_243 targetPos = targetEntity.method_5829().method_1005();
                    EffectLauncher.broadcast(supplier, player, state, targetEntity, new SimpleHitResult(targetPos, class_239.class_240.field_1331, class_2350.field_11033, targetEntity.method_5628()));
                }
            }
        }
    }
}

