/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.controller;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.controller.AbstractProceduralAnimationController;
import com.vicmatskiv.pointblank.client.effect.AbstractEffect;
import com.vicmatskiv.pointblank.client.render.GunItemRenderer;
import com.vicmatskiv.pointblank.client.uv.LoopingSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.PlayOnceSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.RandomSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.SpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.StaticSpriteUVProvider;
import com.vicmatskiv.pointblank.item.GunItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import software.bernie.geckolib.cache.object.GeoBone;

public class GlowAnimationController
extends AbstractProceduralAnimationController {
    private boolean isGlowing;
    private final boolean hasCustomTexture;
    private Set<String> glowingPartNames;
    private Set<GunItem.FirePhase> firePhases;
    private Set<class_2350> directions;
    private Supplier<SpriteUVProvider> spriteUVProviderSupplier;

    protected GlowAnimationController(long duration, Set<GunItem.FirePhase> firePhases, Set<String> glowingPartNames, Set<class_2350> directions, boolean hasCustomTexture, Supplier<SpriteUVProvider> spriteUVProviderSupplier) {
        super(duration);
        this.firePhases = Collections.unmodifiableSet(firePhases);
        this.glowingPartNames = Collections.unmodifiableSet(glowingPartNames);
        this.directions = directions;
        this.hasCustomTexture = hasCustomTexture;
        this.spriteUVProviderSupplier = spriteUVProviderSupplier;
        this.reset();
    }

    public Set<String> getGlowingPartNames() {
        return this.glowingPartNames;
    }

    @Override
    public void onStartFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
        this.reset();
        this.isGlowing = this.firePhases.contains((Object)GunItem.FirePhase.FIRING) || this.firePhases.contains((Object)GunItem.FirePhase.ANY);
    }

    @Override
    public void onPrepareFiring(class_1309 player, GunClientState state, class_1799 itemStack) {
        this.reset();
        this.isGlowing = this.firePhases.contains((Object)GunItem.FirePhase.PREPARING) || this.firePhases.contains((Object)GunItem.FirePhase.ANY);
    }

    @Override
    public void onCompleteFiring(class_1309 player, GunClientState gunClientState, class_1799 itemStack) {
        this.isGlowing = this.firePhases.contains((Object)GunItem.FirePhase.COMPLETETING) || this.firePhases.contains((Object)GunItem.FirePhase.ANY);
    }

    @Override
    public void onPrepareIdle(class_1309 player, GunClientState gunClientState, class_1799 itemStack) {
        this.isGlowing = this.firePhases.contains((Object)GunItem.FirePhase.ANY);
    }

    @Override
    public void onIdle(class_1309 player, GunClientState gunClientState, class_1799 itemStack) {
        this.isGlowing = this.firePhases.contains((Object)GunItem.FirePhase.ANY);
    }

    public void renderCubesOfBone(GunItemRenderer gunItemRenderer, class_4587 poseStack, GeoBone bone, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        if (this.isGlowing || this.firePhases.contains((Object)GunItem.FirePhase.ANY)) {
            packedLight = 240;
            float progress = (float)this.getProgress(null, 0.0f);
            gunItemRenderer.renderCubesOfBoneParent(poseStack, bone, buffer, packedLight, packedOverlay, color, this.hasCustomTexture, this.directions, this.spriteUVProviderSupplier, progress);
        }
    }

    public static class Builder {
        private static int effectIdCounter = 0;
        protected int effectId;
        protected class_2960 texture;
        protected Set<String> glowingPartNames = new HashSet<String>();
        protected Set<GunItem.FirePhase> firePhases = new HashSet<GunItem.FirePhase>();
        protected AbstractEffect.SpriteInfo spriteInfo;
        protected Set<class_2350> directions;

        public Builder() {
            this.effectId = effectIdCounter++;
        }

        public int getEffectId() {
            return this.effectId;
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public Builder withTexture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public Builder withGlowingPartNames(Collection<String> glowingPartNames) {
            this.glowingPartNames.addAll(glowingPartNames);
            return this;
        }

        public Builder withFirePhases(Collection<GunItem.FirePhase> firePhases) {
            this.firePhases.addAll(firePhases);
            return this;
        }

        public Builder withSprites(int rows, int columns, int spritesPerSecond, AbstractEffect.SpriteAnimationType type) {
            this.spriteInfo = new AbstractEffect.SpriteInfo(rows, columns, spritesPerSecond, type);
            return this;
        }

        public Builder withDirections(class_2350 ... directions) {
            if (directions != null && directions.length > 0) {
                this.directions = Set.of(directions);
            }
            return this;
        }

        public GlowAnimationController build() {
            Supplier<SpriteUVProvider> spriteUVProviderSupplier = null;
            if (this.spriteInfo != null) {
                switch (this.spriteInfo.type()) {
                    case STATIC: {
                        spriteUVProviderSupplier = () -> StaticSpriteUVProvider.INSTANCE;
                        break;
                    }
                    case LOOP: {
                        LoopingSpriteUVProvider spriteUVProvider = new LoopingSpriteUVProvider(this.spriteInfo.rows(), this.spriteInfo.columns(), this.spriteInfo.spritesPerSecond(), Integer.MAX_VALUE);
                        spriteUVProviderSupplier = () -> spriteUVProvider;
                        break;
                    }
                    case RANDOM: {
                        spriteUVProviderSupplier = () -> new RandomSpriteUVProvider(this.spriteInfo.rows(), this.spriteInfo.columns(), this.spriteInfo.spritesPerSecond(), Integer.MAX_VALUE);
                        break;
                    }
                    case PLAY_ONCE: {
                        PlayOnceSpriteUVProvider spriteUVProvider = new PlayOnceSpriteUVProvider(this.spriteInfo.rows(), this.spriteInfo.columns(), this.spriteInfo.spritesPerSecond(), Integer.MAX_VALUE);
                        spriteUVProviderSupplier = () -> spriteUVProvider;
                        break;
                    }
                }
            }
            return new GlowAnimationController(Integer.MAX_VALUE, this.firePhases, this.glowingPartNames, this.directions, this.texture != null, spriteUVProviderSupplier);
        }
    }
}

