/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.controller;

import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateListener;
import com.vicmatskiv.pointblank.client.RealtimeLinearEaser;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_811;

public class InertiaController
implements GunStateListener {
    private double previousYaw;
    private double targetYawTiltAngle;
    private double previousPitch;
    private double targetPitchTiltAngle;
    private double maxTiltAngle;
    private double tiltFactor;
    private double smoothingFactor;
    private double dampingFactor = 0.01;
    private float threshold = 0.01f;
    private long lastUpdateTime;
    private double roll;
    private double pitch;
    private double yaw;
    private float dynamicModifier;
    private RealtimeLinearEaser dynamicModifierEaser = new RealtimeLinearEaser(1000L);

    public InertiaController(double tiltFactor, double smoothingFactor, double maxTiltAngle) {
        this.lastUpdateTime = System.nanoTime();
        this.tiltFactor = tiltFactor;
        this.smoothingFactor = smoothingFactor;
        this.maxTiltAngle = maxTiltAngle;
        this.reset();
    }

    @Override
    public void onUpdateState(class_1309 player, GunClientState state) {
        long currentTime = System.nanoTime();
        double deltaTime = (double)(currentTime - this.lastUpdateTime) / 1.0E9;
        this.lastUpdateTime = currentTime;
        float currentYaw = player.method_36454();
        double deltaYaw = (double)currentYaw - this.previousYaw;
        double yawTurnSpeed = deltaYaw / deltaTime;
        float currentPitch = player.method_36455();
        double deltaPitch = (double)currentPitch - this.previousPitch;
        double pitchTurnSpeed = deltaPitch / deltaTime;
        double scaledTiltFactor = this.tiltFactor * (double)this.dynamicModifierEaser.update(this.dynamicModifier);
        double yawInterpolationSpeed = this.smoothingFactor * deltaTime;
        if (Math.abs(yawTurnSpeed) >= (double)this.threshold) {
            this.targetYawTiltAngle = yawTurnSpeed * (state.isAiming() ? 0.2 : 1.0) * scaledTiltFactor;
        } else {
            this.targetYawTiltAngle *= this.dampingFactor;
            yawInterpolationSpeed *= 30.0;
        }
        double pitchInterpolationSpeed = this.smoothingFactor * deltaTime;
        if (Math.abs(pitchTurnSpeed) >= (double)this.threshold) {
            this.targetPitchTiltAngle = pitchTurnSpeed * (state.isAiming() ? 0.2 : 1.0) * scaledTiltFactor;
        } else {
            this.targetPitchTiltAngle *= this.dampingFactor;
            pitchInterpolationSpeed *= 30.0;
        }
        this.targetYawTiltAngle = class_3532.method_15350((double)this.targetYawTiltAngle, (double)(-this.maxTiltAngle), (double)this.maxTiltAngle);
        this.targetPitchTiltAngle = class_3532.method_15350((double)this.targetPitchTiltAngle, (double)(-this.maxTiltAngle), (double)this.maxTiltAngle);
        this.yaw += (this.targetYawTiltAngle - this.yaw) * yawInterpolationSpeed;
        this.pitch += (this.targetPitchTiltAngle - this.pitch) * pitchInterpolationSpeed;
        this.roll += (this.targetYawTiltAngle - this.roll) * yawInterpolationSpeed;
        this.previousYaw = currentYaw;
        this.previousPitch = currentPitch;
    }

    @Override
    public void onRenderTick(class_1309 player, GunClientState state, class_1799 itemStack, class_811 itemDisplayContext, float partialTicks) {
    }

    public void reset() {
        this.yaw = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
        this.previousYaw = 0.0;
        this.previousPitch = 0.0;
        this.dynamicModifier = 1.0f;
        this.lastUpdateTime = System.nanoTime();
    }

    public void reset(class_1657 player) {
        this.yaw = 0.0;
        this.pitch = 0.0;
        this.roll = 0.0;
        this.previousYaw = player.method_36454();
        this.previousPitch = player.method_36455();
        this.dynamicModifier = 1.0f;
        this.lastUpdateTime = System.nanoTime();
    }

    public double getRoll() {
        return this.roll;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    void setTiltFactor(double tiltFactor) {
        this.tiltFactor = tiltFactor;
    }

    void setSmoothingFactor(double smoothingFactor) {
        this.smoothingFactor = smoothingFactor;
    }

    void setMaxTiltAngle(double maxTiltAngle) {
        this.maxTiltAngle = maxTiltAngle;
    }

    public void setDynamicModifier(float dynamicModifier) {
        if (dynamicModifier < this.dynamicModifier) {
            this.dynamicModifierEaser.update(dynamicModifier, true);
        }
        this.dynamicModifier = dynamicModifier;
    }
}

