/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.effect;

import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.client.effect.AbstractEffect;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.client.effect.EffectRenderContext;
import com.vicmatskiv.pointblank.client.particle.EffectParticles;
import com.vicmatskiv.pointblank.client.uv.SpriteUVProvider;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.joml.Vector3f;

public class TrailEffect
extends AbstractEffect {
    private class_243 previousPosition;
    private class_243 previousVelocity;
    private double longitudeOffset;

    @Override
    public boolean hasInfiniteBounds() {
        return false;
    }

    @Override
    public void render(EffectRenderContext effectRenderContext) {
        class_243 topLeft;
        class_243 bottomLeft;
        class_243 cameraRightVector;
        TrailRenderContext trailRenderContext = (TrailRenderContext)effectRenderContext;
        float progress = effectRenderContext.getProgress();
        float partialTick = effectRenderContext.getPartialTick();
        class_4184 camera = effectRenderContext.getCamera();
        class_243 cameraPos = camera.method_19326();
        Vector3f viewDirection3f = camera.method_19335();
        class_243 viewDirection = new class_243((double)viewDirection3f.x, (double)viewDirection3f.y, (double)viewDirection3f.z);
        class_243 cameraUpVector = new class_243(0.0, 1.0, 0.0);
        class_243 defaultVector = cameraRightVector = viewDirection.method_1036(cameraUpVector);
        class_243 position = effectRenderContext.getPosition();
        class_243 velocity = effectRenderContext.getVelocity();
        class_243 r2 = viewDirection.method_1036(velocity).method_1029();
        class_243 up2 = r2;
        if (up2.method_1027() < 1.0E-5) {
            up2 = defaultVector;
        }
        float halfWidth = this.widthProvider.getValue(progress) * 0.5f;
        if (trailRenderContext.prevVelocity != null && trailRenderContext.prevPos != null) {
            class_243 prevR2 = viewDirection.method_1036(trailRenderContext.prevVelocity).method_1029();
            class_243 prevUp2 = prevR2;
            if (prevUp2.method_1027() < 1.0E-5) {
                prevUp2 = defaultVector;
            }
            bottomLeft = this.getVerticePos(trailRenderContext.prevPos, trailRenderContext.prevVelocity, prevUp2, 1.0f, -halfWidth);
            topLeft = this.getVerticePos(trailRenderContext.prevPos, trailRenderContext.prevVelocity, prevUp2, 1.0f, halfWidth);
        } else {
            bottomLeft = this.getVerticePos(position, velocity, up2, 0.0f, -halfWidth);
            topLeft = this.getVerticePos(position, velocity, up2, 0.0f, halfWidth);
        }
        class_243 bottomRight = this.getVerticePos(position, velocity, up2, partialTick, -halfWidth);
        class_243 topRight = this.getVerticePos(position, velocity, up2, partialTick, halfWidth);
        bottomLeft = bottomLeft.method_1020(cameraPos);
        bottomRight = bottomRight.method_1020(cameraPos);
        topLeft = topLeft.method_1020(cameraPos);
        topRight = topRight.method_1020(cameraPos);
        SpriteUVProvider spriteUVProvider = effectRenderContext.getSpriteUVProvider();
        float[] uv = spriteUVProvider.getSpriteUV(progress);
        float u0 = uv[0];
        float v0 = uv[1];
        float u1 = uv[2];
        float v1 = uv[3];
        int lightColor = effectRenderContext.getLightColor();
        float alpha = this.alphaProvider.getValue(progress);
        float rCol = 1.0f;
        float gCol = 1.0f;
        float bCol = 1.0f;
        class_4588 vertexConsumer = effectRenderContext.getVertexBuffer();
        vertexConsumer.method_22912((float)topRight.field_1352, (float)topRight.field_1351, (float)topRight.field_1350).method_22913(u1, v1).method_22915(rCol, gCol, bCol, alpha).method_60803(lightColor);
        vertexConsumer.method_22912((float)bottomRight.field_1352, (float)bottomRight.field_1351, (float)bottomRight.field_1350).method_22913(u1, v0).method_22915(rCol, gCol, bCol, alpha).method_60803(lightColor);
        vertexConsumer.method_22912((float)bottomLeft.field_1352, (float)bottomLeft.field_1351, (float)bottomLeft.field_1350).method_22913(u0, v0).method_22915(rCol, gCol, bCol, alpha).method_60803(lightColor);
        vertexConsumer.method_22912((float)topLeft.field_1352, (float)topLeft.field_1351, (float)topLeft.field_1350).method_22913(u0, v1).method_22915(rCol, gCol, bCol, alpha).method_60803(lightColor);
    }

    private class_243 getVerticePos(class_243 position, class_243 velocity, class_243 side, float segmentProgress, float sideOffset) {
        class_243 vertixPos = position.method_1019(velocity.method_1021((double)segmentProgress)).method_1019(side.method_1021((double)sideOffset));
        return vertixPos;
    }

    @Override
    public void launch(class_1297 player) {
        class_310 mc = class_310.method_1551();
        EffectParticles.EffectParticle particle = new EffectParticles.EffectParticle(player, this);
        mc.field_1713.method_3058((class_703)particle);
    }

    public void launchNext(class_1297 owner, class_243 position, class_243 velocity) {
        class_310 mc = class_310.method_1551();
        class_243 positionWithOffset = position.method_1020(velocity.method_1029().method_1021(this.longitudeOffset));
        if (this.previousPosition != null) {
            TrailParticle particle = new TrailParticle(owner, this, positionWithOffset, velocity, this.previousPosition, this.previousVelocity);
            mc.field_1713.method_3058((class_703)particle);
        }
        this.previousVelocity = velocity;
        this.previousPosition = positionWithOffset;
    }

    private static class TrailRenderContext
    extends EffectRenderContext {
        private class_243 prevPos;
        private class_243 prevVelocity;

        private TrailRenderContext() {
        }
    }

    private static class TrailParticle
    extends EffectParticles.EffectParticle {
        private class_243 position;
        private class_243 velocity;
        private class_243 prevVelocity;
        private class_243 prevPos;
        private float segmentProgress;

        TrailParticle(class_638 level, double x, double y, double z) {
            super(level, x, y, z);
        }

        public TrailParticle(class_1297 owner, TrailEffect effect, class_243 position, class_243 velocity, class_243 prevPos, class_243 prevVelocity) {
            super(owner, effect);
            this.method_3063(position.field_1352, position.field_1351, position.field_1350);
            this.field_3858 = this.field_3874;
            this.field_3838 = this.field_3854;
            this.field_3856 = this.field_3871;
            this.position = position;
            this.velocity = velocity;
            this.prevPos = prevPos;
            this.prevVelocity = prevVelocity;
        }

        @Override
        public boolean shouldCull() {
            return false;
        }

        @Override
        public void method_3074(class_4588 vertexConsumer, class_4184 camera, float partialTick) {
            int lightColor = this.method_3068(partialTick);
            float progress = this.getProgress(partialTick);
            this.segmentProgress = this.segmentProgress < partialTick ? partialTick : 1.0f;
            TrailRenderContext effectRenderContext = (TrailRenderContext)new TrailRenderContext().withCamera(camera).withPosition(this.position).withVelocity(this.velocity).withVertexBuffer(vertexConsumer).withProgress(progress).withPartialTick(this.segmentProgress).withLightColor(lightColor).withSpriteUVProvider(this.spriteUVProvider);
            effectRenderContext.prevPos = this.prevPos;
            effectRenderContext.prevVelocity = this.prevVelocity;
            this.effect.render(effectRenderContext);
        }
    }

    public static class Builder
    extends AbstractEffect.AbstractEffectBuilder<Builder, TrailEffect> {
        private Collection<GunItem.FirePhase> compatiblePhases = Collections.singletonList(GunItem.FirePhase.FLYING);
        private double longitudeOffset;

        public Builder withLongitudeOffset(double longitudeOffset) {
            this.longitudeOffset = longitudeOffset;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            super.withJsonObject(obj);
            this.withLongitudeOffset(JsonUtil.getJsonFloat(obj, "longitudeOffset", 0.0f));
            return this;
        }

        @Override
        public Collection<GunItem.FirePhase> getCompatiblePhases() {
            return this.compatiblePhases;
        }

        @Override
        public boolean isEffectAttached() {
            return false;
        }

        @Override
        public TrailEffect build(EffectBuilder.Context effectContext) {
            TrailEffect effect = new TrailEffect();
            this.apply(effect, effectContext);
            effect.longitudeOffset = this.longitudeOffset;
            return effect;
        }
    }
}

