/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.vicmatskiv.pointblank.Enableable;
import com.vicmatskiv.pointblank.Platform;
import com.vicmatskiv.pointblank.client.gui.CustomButton;
import com.vicmatskiv.pointblank.client.render.RenderUtil;
import com.vicmatskiv.pointblank.client.uv.PlayOnceSpriteUVProvider;
import com.vicmatskiv.pointblank.client.uv.SpriteUVProvider;
import com.vicmatskiv.pointblank.crafting.Craftable;
import com.vicmatskiv.pointblank.crafting.PointBlankRecipe;
import com.vicmatskiv.pointblank.inventory.CraftingContainerMenu;
import com.vicmatskiv.pointblank.inventory.IngredientSlot;
import com.vicmatskiv.pointblank.inventory.SearchSlot;
import com.vicmatskiv.pointblank.network.CraftingRequestPacket;
import com.vicmatskiv.pointblank.registry.SoundRegistry;
import com.vicmatskiv.pointblank.util.CancellableSound;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.StateMachine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_478;
import net.minecraft.class_485;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;

public class CraftingScreen
extends class_485<CraftingContainerMenu> {
    public static final int CELL_WIDTH = 18;
    public static final int CELL_HEIGHT = 18;
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"pointblank", (String)"textures/gui/craftnew.png");
    private static final class_2960 GLOW_OUTLINE = class_2960.method_60655((String)"pointblank", (String)"textures/gui/glow_outline.png");
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"container/creative_inventory/scroller");
    private static final class_2960 SCROLLER_DISABLED_SPRITE = class_2960.method_60656((String)"container/creative_inventory/scroller_disabled");
    private StateMachine<CraftingState, Context> stateMachine;
    private float scrollOffs;
    private boolean scrolling;
    private class_342 searchBox;
    private CustomButton craftButton;
    private class_478 listener;
    private boolean ignoreTextInput;
    private boolean hasClickedOutside;
    private final Set<class_6862<class_1792>> visibleTags = new HashSet<class_6862<class_1792>>();
    private int scrollbarXOffset = 121;
    private int scrollbarYOffset = 18;
    private int scrollbarWidth = 14;
    private int scrollbarHeight = 126;
    private class_1799 selectedItem;
    private PointBlankRecipe selectedItemRecipe;
    private long craftingStartTime;
    private long craftingCompletedCooldownStartTime;
    private long craftingCompletedCooldownDuration = 2000L;
    private float itemRotationAngleDegrees;
    private float itemRotationAngleDegreesPerTick;
    private float idleItemRotationsPerSecond = 0.1f;
    private SpriteUVProvider glowOutlineSpriteUVProvider;

    public CraftingScreen(CraftingContainerMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, title);
        this.stateMachine = this.createStateMachine();
        playerInventory.field_7546.field_7512 = this.field_2797;
        this.field_2792 = 312;
        this.field_2779 = 151;
        this.itemRotationAngleDegreesPerTick = CraftingScreen.rotationsPerSecondToDegress(this.idleItemRotationsPerSecond);
        this.craftingCompletedCooldownDuration = 600L;
        this.glowOutlineSpriteUVProvider = new PlayOnceSpriteUVProvider(6, 6, 50, 600L);
    }

    private static float rotationsPerSecondToDegress(float rotationsPerSecond) {
        return 360.0f * rotationsPerSecond * 0.05f;
    }

    private StateMachine<CraftingState, Context> createStateMachine() {
        StateMachine.Builder<CraftingState, Context> builder = new StateMachine.Builder<CraftingState, Context>();
        builder.withTransition(CraftingState.IDLE, CraftingState.CRAFTING, context -> {
            Enableable en;
            class_1792 patt0$temp;
            return this.selectedItem != null && this.selectedItem.method_7909() instanceof Craftable && this.selectedItemRecipe != null && (!((patt0$temp = this.selectedItem.method_7909()) instanceof Enableable) || (en = (Enableable)patt0$temp).isEnabled()) && ((CraftingContainerMenu)this.field_2797).isIdle() && this.craftButton.isPressed();
        }, StateMachine.TransitionMode.EVENT, null, this::actionStartCrafting);
        builder.withTransition(CraftingState.CRAFTING, CraftingState.IDLE, context -> !this.craftButton.isPressed(), StateMachine.TransitionMode.AUTO, null, this::actionCancelCrafting);
        builder.withTransition(CraftingState.CRAFTING, CraftingState.IDLE, context -> true, StateMachine.TransitionMode.EVENT, null, null);
        builder.withTransition(CraftingState.CRAFTING, CraftingState.CRAFTING_COMPLETED, ctx -> System.currentTimeMillis() - this.craftingStartTime >= ((Craftable)this.selectedItem.method_7909()).getCraftingDuration(), StateMachine.TransitionMode.AUTO, null, this::actionCraftingCompleted);
        builder.withTransition(CraftingState.CRAFTING_COMPLETED, CraftingState.CRAFTING_COMPLETED_COOLDOWN, context -> true, StateMachine.TransitionMode.AUTO, null, (ctx, f, t) -> {
            this.craftingCompletedCooldownStartTime = System.currentTimeMillis();
        });
        builder.withTransition(CraftingState.CRAFTING_COMPLETED_COOLDOWN, CraftingState.IDLE, ctx -> System.currentTimeMillis() - this.craftingCompletedCooldownStartTime >= this.craftingCompletedCooldownDuration, StateMachine.TransitionMode.AUTO, null, null);
        builder.withOnSetStateAction(CraftingState.IDLE, this::actionIdle);
        return builder.build(CraftingState.IDLE);
    }

    private void actionIdle(Context context, CraftingState fromState, CraftingState toState) {
        this.craftButton.method_25365(false);
        this.itemRotationAngleDegreesPerTick = CraftingScreen.rotationsPerSecondToDegress(this.idleItemRotationsPerSecond);
    }

    private void actionStartCrafting(Context context, CraftingState fromState, CraftingState toState) {
        this.craftingStartTime = System.currentTimeMillis();
        class_1657 player = ClientUtil.getClientPlayer();
        this.field_22787.method_1483().method_4873((class_1113)new CancellableSound(player, SoundRegistry.CRAFTING_IN_PROGRESS.get(), player.method_5634(), player.method_59922(), s -> this.field_22787.field_1755 == this && this.stateMachine.getCurrentState() == CraftingState.CRAFTING));
        Platform.getInstance().getNetworkService().sendToServer(new CraftingRequestPacket(CraftingRequestPacket.RequestType.START_CRAFTING, this.selectedItemRecipe.getId(ClientUtil.getClientLevel())));
        this.craftButton.method_47400(null);
    }

    public void method_25419() {
        if (this.stateMachine.getCurrentState() == CraftingState.CRAFTING && this.selectedItemRecipe != null) {
            Platform.getInstance().getNetworkService().sendToServer(new CraftingRequestPacket(CraftingRequestPacket.RequestType.CANCEL_CRAFTING, this.selectedItemRecipe.getId(ClientUtil.getClientLevel())));
        }
        super.method_25419();
    }

    private void actionCancelCrafting(Context context, CraftingState fromState, CraftingState toState) {
        Platform.getInstance().getNetworkService().sendToServer(new CraftingRequestPacket(CraftingRequestPacket.RequestType.CANCEL_CRAFTING, this.selectedItemRecipe.getId(ClientUtil.getClientLevel())));
    }

    private void actionCraftingCompleted(Context context, CraftingState fromState, CraftingState toState) {
        ClientUtil.getClientPlayer().method_5783(SoundRegistry.CRAFTING_COMPLETED.get(), 1.0f, 1.0f);
    }

    private float getCraftingProgress() {
        if (this.stateMachine.getCurrentState() != CraftingState.CRAFTING) {
            return 0.0f;
        }
        return class_3532.method_15363((float)((float)(System.currentTimeMillis() - this.craftingStartTime) / (float)((Craftable)this.selectedItem.method_7909()).getCraftingDuration()), (float)0.0f, (float)1.0f);
    }

    private float getCraftingCompletedCooldownProgress() {
        if (this.stateMachine.getCurrentState() != CraftingState.CRAFTING_COMPLETED_COOLDOWN) {
            return 0.0f;
        }
        return class_3532.method_15363((float)((float)(System.currentTimeMillis() - this.craftingCompletedCooldownStartTime) / (float)this.craftingCompletedCooldownDuration), (float)0.0f, (float)1.0f);
    }

    private void refreshContents() {
        this.updateIngredientSlots();
    }

    public void method_37432() {
        if (this.field_22787 != null) {
            Context context = new Context(this);
            this.stateMachine.update(context);
            this.craftButton.field_22763 = this.selectedItem != null && (((CraftingContainerMenu)this.field_2797).isIdle() || ((CraftingContainerMenu)this.field_2797).isCrafting()) && (this.stateMachine.getCurrentState() == CraftingState.IDLE || this.stateMachine.getCurrentState() == CraftingState.CRAFTING && this.craftButton.isPressed());
            this.itemRotationAngleDegrees += this.itemRotationAngleDegreesPerTick;
            if (this.field_22787.field_1724 != null) {
                this.refreshContents();
            }
        }
    }

    protected void method_2383(class_1735 slot, int slotIndex, int mouseButton, class_1713 clickType) {
        if (((CraftingContainerMenu)this.field_2797).isIdle() && ((CraftingContainerMenu)this.field_2797).isCreativeSlot(slot)) {
            this.searchBox.method_1872(true);
            this.searchBox.method_1884(0);
            this.craftButton.method_25365(false);
            this.craftButton.field_22763 = false;
            this.onSelectCraftableItem(slot.method_7677());
        }
    }

    private void onSelectCraftableItem(class_1799 itemStack) {
        this.craftButton.field_22763 = false;
        this.selectedItem = itemStack;
        ((CraftingContainerMenu)this.field_2797).clearIngredientSlots();
        ClientUtil.getClientPlayer().method_5783(SoundRegistry.CRAFTING_ITEM_SELECTED.get(), 1.0f, 1.0f);
        if (this.selectedItem != null && !this.selectedItem.method_7960() && this.selectedItem.method_7909() instanceof Craftable) {
            this.selectedItemRecipe = PointBlankRecipe.getRecipe(ClientUtil.getClientLevel(), itemStack.method_7909());
            if (this.selectedItemRecipe != null) {
                this.updateIngredientSlots();
            }
        } else {
            this.selectedItemRecipe = null;
        }
    }

    private void updateIngredientSlots() {
        if (this.selectedItemRecipe == null) {
            this.craftButton.field_22763 = false;
            return;
        }
        this.craftButton.field_22763 = this.stateMachine.getCurrentState() == CraftingState.IDLE && ((CraftingContainerMenu)this.field_2797).updateIngredientSlots(this.selectedItemRecipe);
        this.craftButton.field_22763 = !(this.selectedItem == null || !((CraftingContainerMenu)this.field_2797).isIdle() && !((CraftingContainerMenu)this.field_2797).isCrafting() || this.stateMachine.getCurrentState() != CraftingState.IDLE && this.stateMachine.getCurrentState() != CraftingState.CRAFTING || !((CraftingContainerMenu)this.field_2797).updateIngredientSlots(this.selectedItemRecipe));
    }

    protected void method_25426() {
        super.method_25426();
        ((CraftingContainerMenu)this.field_2797).clearIngredientSlots();
        int searchBoxLeftOffset = 46;
        this.searchBox = new class_342(this.field_22793, this.field_2776 + searchBoxLeftOffset, this.field_2800 + 6, 80, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1862(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.searchBox);
        this.method_44339();
        this.searchBox.method_1862(true);
        this.searchBox.method_1856(false);
        this.searchBox.method_25365(true);
        this.searchBox.method_25358(89);
        this.searchBox.method_46421(this.field_2776 + (searchBoxLeftOffset + 89) - this.searchBox.method_25368());
        this.craftButton = CustomButton.builder((class_2561)class_2561.method_43471((String)"label.pointblank.craft"), b -> {
            Context context = new Context(this);
            this.stateMachine.setState(context, CraftingState.CRAFTING);
        }).onRelease(b -> {}).bounds(this.field_2776 + 256, this.field_2800 + 115, 46, 20).progressProvider(this::getCraftingProgress).tooltip(class_7919.method_47407((class_2561)class_2561.method_43471((String)"message.pointblank.press_and_hold_to_craft"))).build();
        this.craftButton.method_25365(false);
        this.craftButton.field_22763 = false;
        this.method_37063((class_364)this.craftButton);
        this.refreshSearchResults();
        this.scrollOffs = 0.0f;
        ((CraftingContainerMenu)this.field_2797).scrollTo(0.0f);
        this.selectedItem = null;
        this.selectedItemRecipe = null;
        this.field_22787.field_1724.field_7498.method_7603((class_1712)this.listener);
        this.listener = new class_478(this.field_22787);
        this.field_22787.field_1724.field_7498.method_7596((class_1712)this.listener);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        int i = ((CraftingContainerMenu)this.field_2797).getRowIndexForScroll(this.scrollOffs);
        String s = this.searchBox.method_1882();
        class_1799 currentSelectedItem = this.selectedItem;
        this.method_25423(minecraft, width, height);
        this.searchBox.method_1852(s);
        if (!this.searchBox.method_1882().isEmpty()) {
            this.refreshSearchResults();
        }
        this.onSelectCraftableItem(currentSelectedItem);
        this.scrollOffs = ((CraftingContainerMenu)this.field_2797).getScrollForRowIndex(i);
        ((CraftingContainerMenu)this.field_2797).scrollTo(this.scrollOffs);
    }

    public void method_25432() {
        super.method_25432();
        if (this.field_22787.field_1724 != null && this.field_22787.field_1724.method_31548() != null) {
            this.field_22787.field_1724.field_7498.method_7603((class_1712)this.listener);
        }
    }

    public boolean method_25400(char p_98521_, int p_98522_) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25400(p_98521_, p_98522_)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int p_98547_, int p_98548_, int p_98549_) {
        this.ignoreTextInput = false;
        boolean flag = !((CraftingContainerMenu)this.field_2797).isCreativeSlot(this.field_2787) || this.field_2787.method_7681();
        boolean flag1 = class_3675.method_15985((int)p_98547_, (int)p_98548_).method_30103().isPresent();
        if (flag && flag1 && this.method_2384(p_98547_, p_98548_)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.method_1882();
        if (this.searchBox.method_25404(p_98547_, p_98548_, p_98549_)) {
            if (!Objects.equals(s, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.method_25370() && this.searchBox.method_1885() && p_98547_ != 256 ? true : super.method_25404(p_98547_, p_98548_, p_98549_);
    }

    public boolean method_16803(int p_98612_, int p_98613_, int p_98614_) {
        this.ignoreTextInput = false;
        return super.method_16803(p_98612_, p_98613_, p_98614_);
    }

    private void refreshSearchResults() {
        ((CraftingContainerMenu)this.field_2797).refreshSearchResults(this.searchBox.method_1882());
        this.scrollOffs = 0.0f;
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        class_5250 label = this.selectedItem != null && !this.selectedItem.method_7960() ? this.selectedItem.method_7909().method_7864(this.selectedItem) : class_2561.method_43471((String)"label.pointblank.craft");
        guiGraphics.method_27534(this.field_22793, (class_2561)label, 225, 8, 0xFFFF00);
    }

    public boolean method_25402(double posX, double posY, int mouseButton) {
        if (mouseButton == 0 && this.insideScrollbar(posX, posY)) {
            this.scrolling = this.canScroll();
            return true;
        }
        return super.method_25402(posX, posY, mouseButton);
    }

    public boolean method_25406(double posX, double posY, int mouseButton) {
        if (this.craftButton.isPressed()) {
            this.craftButton.release();
        }
        if (mouseButton == 0) {
            this.scrolling = false;
        }
        return super.method_25406(posX, posY, mouseButton);
    }

    private boolean canScroll() {
        return ((CraftingContainerMenu)this.field_2797).canScroll();
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.canScroll()) {
            return false;
        }
        this.scrollOffs = ((CraftingContainerMenu)this.field_2797).subtractInputFromScroll(this.scrollOffs, scrollY);
        ((CraftingContainerMenu)this.field_2797).scrollTo(this.scrollOffs);
        return true;
    }

    protected boolean method_2381(double mouseX, double mouseY, int p_98543_, int p_98544_, int mouseButton) {
        this.hasClickedOutside = mouseX < (double)p_98543_ || mouseY < (double)p_98544_ || mouseX >= (double)(p_98543_ + this.field_2792) || mouseY >= (double)(p_98544_ + this.field_2779);
        return this.hasClickedOutside;
    }

    protected boolean insideScrollbar(double mouseX, double mouseY) {
        int i = this.field_2776;
        int j = this.field_2800;
        int k = i + this.scrollbarXOffset;
        int l = j + this.scrollbarYOffset;
        int i1 = k + this.scrollbarWidth;
        int j1 = l + this.scrollbarHeight;
        boolean inside = mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
        return inside;
    }

    public boolean method_25403(double p_98535_, double p_98536_, int p_98537_, double p_98538_, double p_98539_) {
        if (this.scrolling) {
            int i = this.field_2800 + 18;
            int j = i + 112;
            this.scrollOffs = ((float)p_98536_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            ((CraftingContainerMenu)this.field_2797).scrollTo(this.scrollOffs);
            return true;
        }
        return super.method_25403(p_98535_, p_98536_, p_98537_, p_98538_, p_98539_);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_2389(guiGraphics, partialTick, mouseX, mouseY);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    private void renderItemInHand(class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.selectedItem == null) {
            return;
        }
        int left = (this.field_22789 - this.field_2792) / 2;
        int top = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_44379(left + 151, top + 23, left + 300, top + 98);
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        float itemRotationAngleDegreesWithPartial = this.itemRotationAngleDegrees;
        float yOffset = 0.0f;
        float zoom = 1.0f;
        float partialTick = this.field_22787.method_60646().method_60637(true);
        yOffset = class_3532.method_15362((float)((itemRotationAngleDegreesWithPartial += this.itemRotationAngleDegreesPerTick * partialTick) * (float)Math.PI * 0.02f));
        if (this.stateMachine.getCurrentState() == CraftingState.CRAFTING_COMPLETED_COOLDOWN) {
            zoom += 0.2f * class_3532.method_15374((float)(this.getCraftingCompletedCooldownProgress() * (float)Math.PI * 2.0f + (float)Math.PI));
        }
        poseStack.method_46416((float)(left + 230), (float)(this.field_22790 / 2 - 18) + yOffset * 2.0f, 100.0f);
        float interactionPitch = -30.0f;
        float interactionYaw = 150.0f;
        poseStack.method_22907(new Quaternionf().rotationXYZ(interactionPitch * ((float)Math.PI / 180), interactionYaw * ((float)Math.PI / 180), 0.0f));
        poseStack.method_22905(zoom, zoom, zoom);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(-90.0f + itemRotationAngleDegreesWithPartial));
        poseStack.method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.method_22905(80.0f, 80.0f, 80.0f);
        Matrix4fStack modelStack = RenderSystem.getModelViewStack();
        modelStack.pushMatrix();
        modelStack.mul((Matrix4fc)poseStack.method_23760().method_23761());
        RenderSystem.applyModelViewMatrix();
        class_4597.class_4598 buffer = guiGraphics.method_51450();
        class_1087 model = this.field_22787.method_1480().method_4019(this.selectedItem, MiscUtil.getLevel((class_1297)this.field_22787.field_1724), (class_1309)this.field_22787.field_1724, this.field_22787.field_1724.method_5628() + class_811.field_4318.ordinal());
        this.field_22787.method_1480().method_23179(this.selectedItem, class_811.field_4318, false, new class_4587(), (class_4597)buffer, 0xF000F0, class_4608.field_21444, model);
        guiGraphics.method_51452();
        modelStack.popMatrix();
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        guiGraphics.method_44380();
    }

    public List<class_2561> method_51454(class_1799 itemStack) {
        boolean flag = this.field_2787 != null && this.field_2787 instanceof SearchSlot;
        boolean flag2 = true;
        class_1836.class_1837 tooltipflag$default = this.field_22787.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        class_1836.class_1837 tooltipflag = flag ? tooltipflag$default.method_47371() : tooltipflag$default;
        List list = itemStack.method_7950(class_1792.class_9635.method_59528((class_1937)ClientUtil.getClientLevel()), (class_1657)this.field_22787.field_1724, (class_1836)tooltipflag);
        ArrayList tooltipComponents = Lists.newArrayList((Iterable)list);
        if (flag2 && flag) {
            this.visibleTags.forEach(p_205407_ -> {
                if (itemStack.method_31573(p_205407_)) {
                    tooltipComponents.add(1, class_2561.method_43470((String)("#" + String.valueOf(p_205407_.comp_327()))).method_27692(class_124.field_1064));
                }
            });
        }
        return tooltipComponents;
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.method_25290(BACKGROUND_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 328, 328);
        this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int j = this.field_2776 + this.scrollbarXOffset;
        int k = this.field_2800 + this.scrollbarYOffset;
        int i = k + this.scrollbarHeight;
        class_2960 resourcelocation = this.canScroll() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.method_52706(resourcelocation, j, k + (int)((float)(i - k - 17) * this.scrollOffs), 12, 15);
        int ingredientSlotOffset = CraftingContainerMenu.SEARCH_CONTAINER.method_5439();
        for (i = 0; i < CraftingContainerMenu.INGREDIENT_CONTAINER.method_5439(); ++i) {
            IngredientSlot ingredientSlot = (IngredientSlot)((Object)((CraftingContainerMenu)this.field_2797).field_7761.get(ingredientSlotOffset + i));
            if (ingredientSlot.isIngredientAvailable()) continue;
            guiGraphics.method_25290(BACKGROUND_TEXTURE, this.field_2776 + ingredientSlot.field_7873 - 1, this.field_2800 + ingredientSlot.field_7872 - 1, 48.0f, 151.0f, 18, 18, 328, 328);
        }
        int left = (this.field_22789 - this.field_2792) / 2;
        int top = (this.field_22790 - this.field_2779) / 2;
        if (this.stateMachine.getCurrentState() == CraftingState.CRAFTING) {
            int topOffset = 98 - (int)(75.0f * this.getCraftingProgress());
            guiGraphics.method_25296(left + 151, top + topOffset, left + 300, top + 98, 0x1000FF00, 0x5000FF00);
        }
        if (this.stateMachine.getCurrentState() == CraftingState.CRAFTING_COMPLETED_COOLDOWN) {
            float progress = this.getCraftingCompletedCooldownProgress();
            int minAlpha = 32;
            int maxAlpha = 96;
            int alpha1 = (int)((float)minAlpha - (float)minAlpha * progress);
            int alpha2 = (int)((float)maxAlpha - (float)maxAlpha * progress);
            guiGraphics.method_25296(left + 151, top + 23, left + 300, top + 98, 0xFF00 | alpha1 << 24, 0xFF00 | alpha2 << 24);
            float[] spriteUV = this.glowOutlineSpriteUVProvider.getSpriteUV(progress);
            if (spriteUV != null) {
                float minU = spriteUV[0];
                float minV = spriteUV[1];
                float maxU = spriteUV[2];
                float maxV = spriteUV[3];
                RenderUtil.blit(guiGraphics, GLOW_OUTLINE, left + 139, left + 314, top - 30, top + 145, 0, minU, maxU, minV, maxV, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        RenderSystem.disableBlend();
        this.renderItemInHand(guiGraphics, mouseX, mouseY);
    }

    public void cancelCrafting() {
        this.stateMachine.setState(new Context(this), CraftingState.IDLE);
    }

    public static enum CraftingState {
        IDLE,
        CRAFTING,
        CRAFTING_COMPLETED,
        CRAFTING_COMPLETED_COOLDOWN;

    }

    private class Context {
        private Context(CraftingScreen craftingScreen) {
        }
    }
}

