/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.client.render.RenderTargetExt;
import com.vicmatskiv.pointblank.compat.iris.IrisCompat;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.mixin.GameRendererAccessorMixin;
import com.vicmatskiv.pointblank.mixin.MinecraftAccessorMixin;
import com.vicmatskiv.pointblank.util.ClientUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_6367;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;

public class AuxLevelRenderer {
    private class_276 renderTarget;
    private int textureWidth;
    private int textureHeight;
    private long frameCount = 0L;
    private boolean isRendering;
    private boolean isRenderingPip;
    private double fov;
    private double cullFrustrumFov;
    private boolean isStencilEnabled;

    public AuxLevelRenderer(int textureWidth, int textureHeight) {
        this.renderTarget = new class_6367(textureWidth, textureHeight, true, class_310.field_1703);
        this.renderTarget.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    public class_276 getRenderTarget() {
        return this.renderTarget;
    }

    public boolean isRenderingPip() {
        return this.isRenderingPip;
    }

    public double getFov() {
        return this.fov;
    }

    public double getCullFrustrumFov() {
        return this.cullFrustrumFov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderToTarget(class_9779 deltaTracker, float zoom) {
        IrisCompat irisCompat;
        class_1799 itemStack;
        class_1657 player;
        class_310 mc = class_310.method_1551();
        if (mc.field_1743 || mc.field_1761 == null || mc.field_1724 == null) {
            return;
        }
        if (!Config.pipScopesEnabled || this.frameCount % (long)Config.pipScopeRefreshFrame != 0L) {
            return;
        }
        this.isRenderingPip = true;
        float partialTick = deltaTracker.method_60637(true);
        double d0 = ((GameRendererAccessorMixin)mc.field_1773).invokeGetFov(mc.field_1773.method_19418(), partialTick, true);
        this.fov = d0 * (double)(1.0f - zoom);
        this.cullFrustrumFov = 110.0;
        class_276 origTarget = mc.method_1522();
        MinecraftAccessorMixin mm = (MinecraftAccessorMixin)mc;
        int originalWidth = mc.method_22683().method_4489();
        int originalHeight = mc.method_22683().method_4506();
        RenderTargetExt origTargetExt = (RenderTargetExt)origTarget;
        RenderTargetExt renderTargetExt = (RenderTargetExt)this.renderTarget;
        if (this.renderTarget.field_1482 != origTarget.field_1482 || this.renderTarget.field_1481 != origTarget.field_1481 || this.isStencilEnabled != origTargetExt.isPointblankStencilEnabled()) {
            this.renderTarget.method_1234(origTarget.field_1482, origTarget.field_1481, true);
            this.textureWidth = originalWidth;
            this.textureHeight = originalHeight;
            if (origTargetExt.isPointblankStencilEnabled()) {
                renderTargetExt.enablePointblankStencil();
            }
        }
        this.isStencilEnabled = origTargetExt.isPointblankStencilEnabled();
        mc.method_1522().method_1240();
        mc.method_1522().method_1230(false);
        mm.setMainRenderTarget(this.renderTarget);
        this.renderTarget.method_1235(true);
        try {
            mc.field_1773.method_35770(true);
            mc.field_1773.method_35769(false);
            mc.field_1773.method_35768(false);
            RenderSystem.clear((int)0, (boolean)class_310.field_1703);
            this.renderTarget.method_1230(false);
            this.renderTarget.method_1235(false);
            mc.field_1773.method_3188(deltaTracker);
        }
        finally {
            mc.field_1773.method_35770(false);
            mc.field_1773.method_35769(true);
            mc.field_1773.method_35768(true);
            mc.method_1522().method_1240();
            mm.setMainRenderTarget(origTarget);
            RenderSystem.clear((int)0, (boolean)class_310.field_1703);
            mc.method_1522().method_1230(true);
            mc.method_1522().method_1235(true);
            this.isRenderingPip = false;
        }
        if (!origTargetExt.isPointblankStencilEnabled() && (player = ClientUtil.getClientPlayer()) != null && (itemStack = GunItem.getMainHeldGunItemStack((class_1309)player)) != null && PipFeature.getMaskTexture(itemStack) != null) {
            origTargetExt.enablePointblankStencil();
        }
        if ((irisCompat = IrisCompat.getInstance()).isIrisLoaded() && irisCompat.isShaderPackEnabled()) {
            GL11.glDepthMask((boolean)true);
            GL11.glClear((int)17664);
            if (ClientUtil.getClientLevel().method_27983() != class_1937.field_25180) {
                GL11.glDepthMask((boolean)false);
            }
        }
    }

    public boolean isRendering() {
        return this.isRendering;
    }

    public void renderToBuffer(class_4587 poseStack, GeoQuad quad, class_4588 buffer, float red, float green, float blue, float alpha) {
        Matrix4f poseState = poseStack.method_23760().method_23761();
        float[][] texUV = new float[][]{{1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {1.0f, 0.0f}};
        for (int i = 0; i < 4; ++i) {
            GeoVertex v = quad.vertices()[i];
            buffer.method_22918(poseState, v.position().x, v.position().y, v.position().z).method_22913(texUV[i][0], texUV[i][1]).method_22915(red, green, blue, alpha);
        }
    }

    public void renderToBuffer(class_4587 poseStack, GeoQuad quad, class_4588 buffer, int packedLight) {
        int alpha;
        int blue;
        int green;
        int red;
        Matrix4f poseState = poseStack.method_23760().method_23761();
        float aspectRatio = class_3532.method_15363((float)((float)this.textureHeight / (float)this.textureWidth), (float)0.0f, (float)1.0f);
        float arH = (1.0f - aspectRatio) * 0.5f;
        float minU = 0.0f + arH;
        float maxU = 1.0f - arH;
        float minV = 0.0f;
        float maxV = 1.0f;
        float[][] texUV = new float[][]{{maxU, maxV}, {minU, maxV}, {minU, minV}, {maxU, minV}};
        IrisCompat irisCompat = IrisCompat.getInstance();
        if (irisCompat.isShaderPackEnabled()) {
            int colorBalance = irisCompat.getColorBalance();
            red = colorBalance >> 24 & 0xFF;
            green = colorBalance >> 16 & 0xFF;
            blue = colorBalance >> 8 & 0xFF;
            alpha = colorBalance & 0xFF;
        } else {
            alpha = 255;
            blue = 255;
            green = 255;
            red = 255;
        }
        for (int i = 0; i < 4; ++i) {
            GeoVertex v = quad.vertices()[i];
            buffer.method_22918(poseState, v.position().x, v.position().y, v.position().z).method_22913(texUV[i][0], texUV[i][1]).method_1336(red, green, blue, alpha);
        }
    }
}

