/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client.render;

import com.vicmatskiv.pointblank.Nameable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_811;

public class HierarchicalRenderContext
implements AutoCloseable {
    private static Deque<HierarchicalRenderContext> contextStack = new ArrayDeque<HierarchicalRenderContext>();
    private class_1799 itemStack;
    private String path;
    private class_811 itemDisplayContext;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    private HierarchicalRenderContext(class_1799 itemStack, HierarchicalRenderContext parent, class_811 itemDisplayContext) {
        this.itemStack = itemStack;
        this.itemDisplayContext = itemDisplayContext;
        if (parent == null) {
            this.path = "/";
        } else {
            String string;
            class_1792 class_17922 = itemStack.method_7909();
            if (class_17922 instanceof Nameable) {
                Nameable nameable = (Nameable)class_17922;
                string = nameable.getName();
            } else {
                string = itemStack.method_7909().toString();
            }
            String name = string;
            this.path = parent.getPath() + "/" + name;
        }
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public String getPath() {
        return this.path;
    }

    public class_811 getItemDisplayContext() {
        return this.itemDisplayContext;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public <T> T getAttribute(String name, T _default) {
        if (this.attributes.containsKey(name)) {
            return (T)this.attributes.get(name);
        }
        return _default;
    }

    public static HierarchicalRenderContext push(class_1799 itemStack, class_811 itemDisplayContext) {
        HierarchicalRenderContext parent = contextStack.peekFirst();
        HierarchicalRenderContext context = new HierarchicalRenderContext(itemStack, parent, itemDisplayContext);
        contextStack.addFirst(context);
        return context;
    }

    public static HierarchicalRenderContext push() {
        HierarchicalRenderContext current = HierarchicalRenderContext.current();
        if (current == null) {
            throw new IllegalStateException("No parent hierarchical render context to inherit from");
        }
        HierarchicalRenderContext context = new HierarchicalRenderContext(current.itemStack, current, current.itemDisplayContext);
        context.path = current.path;
        contextStack.addFirst(context);
        return context;
    }

    public static void pop() {
        contextStack.removeFirst();
    }

    public static HierarchicalRenderContext current() {
        return contextStack.peekFirst();
    }

    public static HierarchicalRenderContext getRoot() {
        return contextStack.peekLast();
    }

    public static class_1799 getRootItemStack() {
        HierarchicalRenderContext root = HierarchicalRenderContext.getRoot();
        return root != null ? root.itemStack : null;
    }

    @Override
    public void close() {
        HierarchicalRenderContext.pop();
    }
}

