/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.feature;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.feature.AccuracyFeature;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.AmmoCapacityFeature;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.DamageFeature;
import com.vicmatskiv.pointblank.feature.Feature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.feature.FireModeFeature;
import com.vicmatskiv.pointblank.feature.MuzzleFlashFeature;
import com.vicmatskiv.pointblank.feature.PartVisibilityFeature;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.feature.RecoilFeature;
import com.vicmatskiv.pointblank.feature.ReloadFeature;
import com.vicmatskiv.pointblank.feature.ReticleFeature;
import com.vicmatskiv.pointblank.feature.SkinFeature;
import com.vicmatskiv.pointblank.feature.SoundFeature;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.registry.FeatureTypeRegistry;
import com.vicmatskiv.pointblank.util.JsonUtil;
import com.vicmatskiv.pointblank.util.LRUCache;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class Features {
    private static final LRUCache<Pair<class_2520, Class<? extends Feature>>, List<EnabledFeature>> selectedItemFeatureCache = new LRUCache(200);
    private static final LRUCache<Pair<class_2520, GunItem.FirePhase>, List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>>> enabledPhaseEffects = new LRUCache(100);

    public static <T extends Feature> EnabledFeature getFirstEnabledFeature(class_1799 itemStack, Class<? extends Feature> featureClass) {
        List<EnabledFeature> enabledFeatures = Features.getEnabledFeatures(itemStack, featureClass);
        return !enabledFeatures.isEmpty() ? enabledFeatures.get(0) : null;
    }

    public static <T extends Feature> List<EnabledFeature> getEnabledFeatures(class_1799 itemStack, Class<? extends Feature> featureClass) {
        class_2487 tag = MiscUtil.getTag(itemStack);
        if (tag == null) {
            return Collections.emptyList();
        }
        return selectedItemFeatureCache.computeIfAbsent((Pair<class_2520, Class<? extends Feature>>)Pair.of((Object)tag, featureClass), p -> Features.computeEnabledFeatures(itemStack, featureClass));
    }

    private static List<EnabledFeature> computeEnabledFeatures(class_1799 rootStack, Class<? extends Feature> featureType) {
        FeatureProvider fp;
        Feature feature;
        NavigableMap<String, class_1799> attachmentStacks = Attachments.getAttachments(rootStack, true);
        ArrayList<EnabledFeature> result = new ArrayList<EnabledFeature>();
        for (Map.Entry entry : attachmentStacks.entrySet()) {
            FeatureProvider fp2;
            Feature feature2;
            class_1792 class_17922 = ((class_1799)entry.getValue()).method_7909();
            if (!(class_17922 instanceof FeatureProvider) || (feature2 = (fp2 = (FeatureProvider)class_17922).getFeature(featureType)) == null || !(((class_1799)entry.getValue()).method_7909() instanceof Attachment) || !feature2.isEnabledForAttachment(rootStack, (class_1799)entry.getValue())) continue;
            result.add(new EnabledFeature(feature2, (class_1799)entry.getValue(), (String)entry.getKey()));
        }
        class_1792 class_17923 = rootStack.method_7909();
        if (class_17923 instanceof FeatureProvider && (feature = (fp = (FeatureProvider)class_17923).getFeature(featureType)) != null && feature.isEnabled(rootStack)) {
            result.add(new EnabledFeature(feature, rootStack, "/"));
        }
        return result;
    }

    public static boolean hasFeature(class_1799 itemStack, Feature feature) {
        class_1792 class_17922 = itemStack.method_7909();
        if (!(class_17922 instanceof FeatureProvider)) {
            return false;
        }
        FeatureProvider fp = (FeatureProvider)class_17922;
        return fp.hasFeature(feature);
    }

    public static List<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>> getEnabledPhaseEffects(class_1799 itemStack, GunItem.FirePhase phase) {
        class_2487 tag = MiscUtil.getTag(itemStack);
        if (tag == null) {
            return Collections.emptyList();
        }
        List conditionalEffects = enabledPhaseEffects.computeIfAbsent((Pair<class_2520, GunItem.FirePhase>)Pair.of((Object)tag, (Object)((Object)phase)), p -> Features.computeEnabledPhaseEffects(itemStack, phase));
        ConditionContext context = new ConditionContext(itemStack);
        return conditionalEffects.stream().filter(p -> ((Predicate)p.getSecond()).test(context)).map(p -> (Supplier)p.getFirst()).toList();
    }

    private static List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>> computeEnabledPhaseEffects(class_1799 rootStack, GunItem.FirePhase firePhase) {
        NavigableMap<String, class_1799> attachmentStacks = Attachments.getAttachments(rootStack, true);
        ArrayList result = new ArrayList();
        for (Class<? extends Feature> featureType : FeatureTypeRegistry.getFeatureTypes().values()) {
            List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>> effectBuilders;
            FeatureProvider fp;
            Feature feature;
            for (Map.Entry entry : attachmentStacks.entrySet()) {
                List<Pair<Supplier<EffectBuilder<? extends EffectBuilder<?, ?>, ?>>, Predicate<ConditionContext>>> effectBuilders2;
                FeatureProvider fp2;
                Feature feature2;
                class_1792 class_17922 = ((class_1799)entry.getValue()).method_7909();
                if (!(class_17922 instanceof FeatureProvider) || (feature2 = (fp2 = (FeatureProvider)class_17922).getFeature(featureType)) == null || !(((class_1799)entry.getValue()).method_7909() instanceof Attachment) || !feature2.isEnabledForAttachment(rootStack, (class_1799)entry.getValue()) || (effectBuilders2 = feature2.getEffectBuilders().get((Object)firePhase)) == null) continue;
                result.addAll(effectBuilders2);
            }
            class_1792 class_17923 = rootStack.method_7909();
            if (!(class_17923 instanceof FeatureProvider) || (feature = (fp = (FeatureProvider)class_17923).getFeature(featureType)) == null || !feature.isEnabled(rootStack) || (effectBuilders = feature.getEffectBuilders().get((Object)firePhase)) == null) continue;
            result.addAll(effectBuilders);
        }
        return result;
    }

    public static FeatureBuilder<?, ?> fromJson(JsonObject obj) {
        String featureType = JsonUtil.getJsonString(obj, "type");
        switch (featureType.toUpperCase(Locale.ROOT)) {
            case "ACCURACY": {
                return new AccuracyFeature.Builder().withJsonObject(obj);
            }
            case "AIMING": {
                return new AimingFeature.Builder().withJsonObject(obj);
            }
            case "DAMAGE": {
                return new DamageFeature.Builder().withJsonObject(obj);
            }
            case "FIREMODE": {
                return new FireModeFeature.Builder().withJsonObject(obj);
            }
            case "AMMOCAPACITY": {
                return new AmmoCapacityFeature.Builder().withJsonObject(obj);
            }
            case "RELOAD": {
                return new ReloadFeature.Builder().withJsonObject(obj);
            }
            case "MUZZLEFLASH": {
                return new MuzzleFlashFeature.Builder().withJsonObject(obj);
            }
            case "PARTVISIBILITY": {
                return new PartVisibilityFeature.Builder().withJsonObject(obj);
            }
            case "PIP": {
                return new PipFeature.Builder().withJsonObject(obj);
            }
            case "RECOIL": {
                return new RecoilFeature.Builder().withJsonObject(obj);
            }
            case "RETICLE": {
                return new ReticleFeature.Builder().withJsonObject(obj);
            }
            case "SOUND": {
                return new SoundFeature.Builder().withJsonObject(obj);
            }
            case "SKIN": {
                return new SkinFeature.Builder().withJsonObject(obj);
            }
        }
        throw new IllegalArgumentException("Invalid feature type: " + featureType);
    }

    public record EnabledFeature(Feature feature, class_1799 ownerStack, String ownerPath) {
    }
}

