/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.inventory;

import com.google.common.collect.Lists;
import com.vicmatskiv.pointblank.inventory.AttachmentContainerMenu;
import com.vicmatskiv.pointblank.inventory.VirtualInventory;
import com.vicmatskiv.pointblank.util.MiscUtil;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleAttachmentContainer
implements class_1263,
class_1737 {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    private int containerIndex;
    private final int size;
    private final class_2371<class_1799> items;
    private List<class_1265> listeners;
    private AttachmentContainerMenu menu;
    private VirtualInventory virtualInventory;
    private SimpleAttachmentContainer parentContainer;

    public SimpleAttachmentContainer(int containerIndex, AttachmentContainerMenu menu, int size) {
        this.containerIndex = containerIndex;
        this.menu = menu;
        this.size = size;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public SimpleAttachmentContainer(class_1799 ... itemStacks) {
        this.size = itemStacks.length;
        this.items = class_2371.method_10212((Object)class_1799.field_8037, (Object[])itemStacks);
    }

    public int getContainerIndex() {
        return this.containerIndex;
    }

    void setParentContainer(SimpleAttachmentContainer parentContainer) {
        this.parentContainer = parentContainer;
    }

    public SimpleAttachmentContainer getParentContainer() {
        return this.parentContainer;
    }

    void setVirtualInventory(VirtualInventory virtualInventory) {
        this.virtualInventory = virtualInventory;
    }

    public VirtualInventory getVirtualInventory() {
        return this.virtualInventory;
    }

    public void addListener(class_1265 listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(class_1265 listeners) {
        if (this.listeners != null) {
            this.listeners.remove(listeners);
        }
    }

    public void removeAllListeners() {
        this.listeners = null;
    }

    public class_1799 method_5438(int index) {
        return index >= 0 && index < this.items.size() ? (class_1799)this.items.get(index) : class_1799.field_8037;
    }

    public List<class_1799> removeAllItems() {
        List<class_1799> list = this.items.stream().filter(itemStack -> !itemStack.method_7960()).collect(Collectors.toList());
        this.method_5448();
        return list;
    }

    public class_1799 method_5434(int p_19159_, int p_19160_) {
        class_1799 itemstack = class_1262.method_5430(this.items, (int)p_19159_, (int)p_19160_);
        if (!itemstack.method_7960()) {
            this.method_5431();
        }
        return itemstack;
    }

    public class_1799 removeItemType(class_1792 item, int p_19172_) {
        class_1799 itemstack = new class_1799((class_1935)item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            class_1799 itemstack1 = this.method_5438(i);
            if (!itemstack1.method_7909().equals(item)) continue;
            int j = p_19172_ - itemstack.method_7947();
            class_1799 itemstack2 = itemstack1.method_7971(j);
            itemstack.method_7933(itemstack2.method_7947());
            if (itemstack.method_7947() == p_19172_) break;
        }
        if (!itemstack.method_7960()) {
            this.method_5431();
        }
        return itemstack;
    }

    public class_1799 addItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStackCopy = itemStack.method_7972();
        this.moveItemToOccupiedSlotsWithSameType(itemStackCopy);
        if (itemStackCopy.method_7960()) {
            return class_1799.field_8037;
        }
        this.moveItemToEmptySlots(itemStackCopy);
        return itemStackCopy.method_7960() ? class_1799.field_8037 : itemStackCopy;
    }

    public boolean canAddItem(class_1799 item) {
        boolean flag = false;
        for (class_1799 itemstack : this.items) {
            if (!itemstack.method_7960() && (!class_1799.method_31577((class_1799)itemstack, (class_1799)item) || itemstack.method_7947() >= itemstack.method_7914())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public class_1799 method_5441(int itemIndex) {
        class_1799 itemstack = (class_1799)this.items.get(itemIndex);
        if (itemstack.method_7960()) {
            return class_1799.field_8037;
        }
        this.items.set(itemIndex, (Object)class_1799.field_8037);
        return itemstack;
    }

    public void method_5447(int index, class_1799 itemStack) {
        LOGGER.debug("Setting item {} in container {} to stack {} with tag {}", (Object)index, (Object)this, (Object)itemStack, (Object)MiscUtil.getTag(itemStack));
        this.items.set(index, (Object)itemStack);
        if (!itemStack.method_7960() && itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void method_5431() {
        if (this.listeners != null) {
            for (class_1265 containerlistener : this.listeners) {
                containerlistener.method_5453((class_1263)this);
            }
        }
    }

    public boolean method_5443(class_1657 p_19167_) {
        return true;
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public void method_7683(class_1662 p_19169_) {
        for (class_1799 itemstack : this.items) {
            p_19169_.method_7400(itemstack);
        }
    }

    public String toString() {
        return String.format("{Container #%d id: %d, items: %s }", this.containerIndex, System.identityHashCode(this), this.items);
    }

    private void moveItemToEmptySlots(class_1799 p_19190_) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemstack = this.method_5438(i);
            if (!itemstack.method_7960()) continue;
            this.method_5447(i, p_19190_.method_51164());
            return;
        }
    }

    private void moveItemToOccupiedSlotsWithSameType(class_1799 p_19192_) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemstack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemstack, (class_1799)p_19192_)) continue;
            this.moveItemsBetweenStacks(p_19192_, itemstack);
            if (!p_19192_.method_7960()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(class_1799 fromStack, class_1799 toStack) {
        int i = Math.min(this.method_5444(), toStack.method_7914());
        int j = Math.min(fromStack.method_7947(), i - toStack.method_7947());
        if (j > 0) {
            toStack.method_7933(j);
            fromStack.method_7934(j);
            this.method_5431();
        }
    }

    AttachmentContainerMenu getMenu() {
        return this.menu;
    }

    public static int getContainerStartIndex(SimpleAttachmentContainer[] attachmentContainers, int containerIndex) {
        int startIndex = 0;
        for (int i = 0; i < containerIndex; ++i) {
            SimpleAttachmentContainer container = attachmentContainers[i];
            startIndex += container.method_5439();
        }
        return startIndex;
    }
}

