/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.platform.fabric.mixin;

import com.google.gson.Gson;
import com.vicmatskiv.pointblank.platform.fabric.BakingModelHelper;
import com.vicmatskiv.pointblank.platform.fabric.BlockModelBakingContext;
import com.vicmatskiv.pointblank.platform.fabric.BlockModelExt;
import com.vicmatskiv.pointblank.platform.fabric.ContextualBlockModelBaker;
import com.vicmatskiv.pointblank.platform.fabric.ExtendedBlockModelDeserializer;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_799;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_793.class})
public class BlockModelMixin
implements BlockModelExt {
    @Unique
    private static final int LOOKAHEAD_LIMIT = 4096;
    @Unique
    private BlockModelBakingContext pointBlankCustomData;
    @Shadow
    @Final
    private List<class_799> field_4255;
    @Shadow
    @Final
    static Gson field_4254;

    @Override
    public BlockModelBakingContext getPointBlankCustomData() {
        if (this.pointBlankCustomData == null) {
            this.pointBlankCustomData = new BlockModelBakingContext((class_793)this);
        }
        return this.pointBlankCustomData;
    }

    @Inject(method={"fromStream"}, at={@At(value="HEAD")}, cancellable=true)
    private static void onFromStream(Reader reader, CallbackInfoReturnable<class_793> cir) {
        PushbackReader pushbackReader = new PushbackReader(reader, 4096);
        boolean shouldHandle = true;
        StringBuilder contentBuilder = new StringBuilder();
        char[] buffer = new char[4096];
        try {
            int length = pushbackReader.read(buffer, 0, 4096);
            if (length > 0) {
                contentBuilder.append(buffer, 0, length);
                String initialContent = contentBuilder.toString();
                String sanitizedContent = initialContent.replaceAll("\\s", "");
                shouldHandle = sanitizedContent.contains("\"loader\":\"forge:separate_transforms\"");
                pushbackReader.unread(buffer, 0, length);
            }
        }
        catch (IOException ioe) {
            shouldHandle = false;
        }
        class_793 blockModel = shouldHandle ? (class_793)class_3518.method_15276((Gson)ExtendedBlockModelDeserializer.INSTANCE, (Reader)pushbackReader, class_793.class) : (class_793)class_3518.method_15276((Gson)field_4254, (Reader)pushbackReader, class_793.class);
        cir.setReturnValue((Object)blockModel);
        cir.cancel();
    }

    @Inject(method={"bake(Lnet/minecraft/client/resources/model/ModelBaker;Ljava/util/function/Function;Lnet/minecraft/client/resources/model/ModelState;)Lnet/minecraft/client/resources/model/BakedModel;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onBake(class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 state, CallbackInfoReturnable<class_1087> cir) {
        class_793 blockModel = (class_793)this;
        class_1087 bakedModel = BakingModelHelper.bakeModel(blockModel, baker, spriteGetter, state);
        if (bakedModel != null) {
            cir.setReturnValue((Object)bakedModel);
            cir.cancel();
        }
    }

    @Inject(method={"resolveParents"}, at={@At(value="RETURN")})
    public void onResolveParents(Function<class_2960, class_1100> resolver, CallbackInfo ci) {
        ContextualBlockModelBaker geometry;
        if (this.pointBlankCustomData != null && (geometry = this.pointBlankCustomData.getCustomGeometry()) != null) {
            geometry.resolveParents(resolver, this.pointBlankCustomData);
        }
    }
}

